/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.guicomponents.SelectFile;

public abstract class Exporter {
    private static File lastSaveFile = null;
    private static final String defaultDateFormatString = "yyyy-MM-dd_HH:mm:ss";
    private static final String defaultDateFormatFileString = "yyyy-MM-dd_HH-mm-ss";
    private static String dateFormatString = "yyyy-MM-dd_HH:mm:ss";
    private static String dateFormatFileString = "yyyy-MM-dd_HH-mm-ss";

    public static void setDateFormatString(String aDateFormatString) {
        dateFormatString = aDateFormatString;
    }

    public static void setDateFormatFileString(String aDateFormatFileString) {
        dateFormatFileString = aDateFormatFileString;
    }

    private static void checkExportDir(File exportDir) throws IOException {
        boolean success;
        if (!exportDir.exists() && !(success = exportDir.mkdirs())) {
            throw new IOException("Export directory " + exportDir + " does not exist, attempt to create failed.");
        }
        if (!exportDir.isDirectory() || !exportDir.canWrite()) {
            throw new IOException("Export directory `" + exportDir + "' is not a writable directory.");
        }
    }

    protected static String getDateString() {
        return new SimpleDateFormat(dateFormatString).format(new Date());
    }

    public static synchronized File getLastSaveFile() {
        return lastSaveFile;
    }

    private static synchronized void setLastSaveFile(File theLastSaveFile) {
        lastSaveFile = theLastSaveFile;
    }

    protected Exporter() {
    }

    public String getDateFormatString() {
        return dateFormatString;
    }

    public abstract String[][] getFileExtensions();

    public abstract String getPreferredFileExtension();

    public abstract String getFormatName();

    private File selectExportFile(Component parent, File exportDir) {
        File answer = SelectFile.selectFile(parent, "Select file for " + this.getFormatName() + " export.", exportDir.getPath(), true, false, 0, this.getFileExtensions());
        if (answer != null && this.getPreferredFileExtension() != null && !this.getPreferredFileExtension().isEmpty()) {
            answer = new File(IrpUtils.addExtensionIfNotPresent(answer.getPath(), this.getPreferredFileExtension()));
        }
        return answer;
    }

    private File automaticFilename(File exportDir) throws IOException {
        Exporter.checkExportDir(exportDir);
        String name = this.getFormatName().toLowerCase(Locale.US).replace(File.separator, "_") + "_" + new SimpleDateFormat(dateFormatFileString).format(new Date());
        if (this.getPreferredFileExtension() != null) {
            name = name + "." + this.getPreferredFileExtension();
        }
        return new File(exportDir, name);
    }

    public File exportFilename(boolean automatic, Component parent, File exportDir) throws IOException {
        File file;
        File file2 = file = automatic ? this.automaticFilename(exportDir) : this.selectExportFile(parent, exportDir);
        if (file != null) {
            Exporter.setLastSaveFile(file);
        }
        return file;
    }
}

