/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

public class ExporterUtils {
    private static final String formattingCode = "%02X";

    public static int reverse(int n, int bits) {
        int mask = (1 << bits) - 1;
        return Integer.reverse(n & mask) >>> 32 - bits;
    }

    public static String twoDigitHex(int n) {
        return String.format(formattingCode, n);
    }

    public static String twoDigitReverseHex(int n) {
        return ExporterUtils.twoDigitHex(Integer.reverse(n) >>> 24);
    }

    public static String rc5Data(int D, int F, int T) {
        int data = (~F & 0x40) << 6 | (T & 1) << 11 | (D & 0x1F) << 6 | F & 0x3F;
        return String.format("%X", data);
    }

    public static String sony12Data(int D, int F) {
        int data = ExporterUtils.reverse(F, 7) << 5;
        return Integer.toHexString(data |= ExporterUtils.reverse(D, 5));
    }

    public static String sony15Data(int D, int F) {
        int data = ExporterUtils.reverse(F, 7) << 8;
        return Integer.toHexString(data |= ExporterUtils.reverse(D, 8));
    }

    public static String sony20Data(int D, int S, int F) {
        int data = ExporterUtils.reverse(F, 7) << 13 | ExporterUtils.reverse(D, 5) << 8 | ExporterUtils.reverse(S, 8);
        return Integer.toHexString(data);
    }

    private ExporterUtils() {
    }
}

