/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.io.File;
import java.io.IOException;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.irscrutinizer.exporter.IRemoteSetExporter;
import org.harctoolbox.irscrutinizer.exporter.RemoteSetExporter;
import org.w3c.dom.Document;

public class GirrExporter
extends RemoteSetExporter
implements IRemoteSetExporter {
    private String girrStyleSheetType;
    private String girrStyleSheetUrl;
    private boolean fatRaw;
    private boolean createSchemaLocation;
    private boolean generateRaw;
    private boolean generateCcf;
    private boolean generateParameters;
    private Command.CommandTextFormat[] extraFormats;

    private GirrExporter() {
    }

    public GirrExporter(String creatingUser, String girrStyleSheetType, String girrStyleSheetUrl, boolean fatRaw, boolean createSchemaLocation, boolean generateRaw, boolean generateCcf, boolean generateParameters, Command.CommandTextFormat ... extraFormats) {
        super(creatingUser);
        this.girrStyleSheetType = girrStyleSheetType;
        this.girrStyleSheetUrl = girrStyleSheetUrl;
        this.fatRaw = fatRaw;
        this.createSchemaLocation = createSchemaLocation;
        this.generateRaw = generateRaw;
        this.generateCcf = generateCcf;
        this.generateParameters = generateParameters;
        this.extraFormats = extraFormats;
    }

    @Override
    public void export(RemoteSet remoteSet, String title, int count, File file, String charsetName) throws IOException, IrpMasterException {
        for (Command.CommandTextFormat formatter : this.extraFormats) {
            remoteSet.addFormat(formatter, count);
        }
        Document document = remoteSet.xmlExportDocument(title, this.girrStyleSheetType, this.girrStyleSheetUrl, this.fatRaw, this.createSchemaLocation, this.generateRaw, this.generateCcf, this.generateParameters);
        new XmlExporter(document).printDOM(file, charsetName);
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Girr files (*.girr)", "girr"}, {"XML files", "xml"}};
    }

    @Override
    public String getPreferredFileExtension() {
        return "girr";
    }

    @Override
    public String getFormatName() {
        return "Girr";
    }

    @Override
    public boolean supportsEmbeddedFormats() {
        return true;
    }

    @Override
    public boolean supportsMetaData() {
        return true;
    }
}

