/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIconSet;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.ProntoModel;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.exporter.IRemoteSetExporter;
import org.harctoolbox.irscrutinizer.exporter.RemoteSetExporter;

public class ProntoClassicExporter
extends RemoteSetExporter
implements IRemoteSetExporter {
    private static final int buttonLabelLength = 100;
    private ProntoModel prontoModel;
    private CCF ccf = null;
    private int buttonWidth;
    private int buttonHeight;
    private int screenWidth;
    private int screenHeight;

    public ProntoClassicExporter() {
    }

    public ProntoClassicExporter(ProntoModel prontomodel, int buttonwidth, int buttonheight, int screenwidth, int screenheight) {
        this();
        this.prontoModel = prontomodel;
        this.buttonWidth = buttonwidth;
        this.buttonHeight = buttonheight;
        this.screenWidth = screenwidth;
        this.screenHeight = screenheight;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"ccf", "Pronto classic configuration files (*.ccf)"}};
    }

    @Override
    public String getPreferredFileExtension() {
        return "ccf";
    }

    @Override
    public String getFormatName() {
        return "ProntoClassic";
    }

    @Override
    public void export(RemoteSet remoteSet, String title, int count, File saveFile, String charsetName) throws IrpMasterException, IOException {
        this.setup(remoteSet);
        this.ccf.save(saveFile.getPath());
    }

    private void setup(RemoteSet remoteSet) throws IrpMasterException {
        if (this.prontoModel.getModel() != 0) {
            this.screenWidth = this.prontoModel.getScreenSize().width;
            this.screenHeight = this.prontoModel.getScreenSize().height;
        }
        int usedScreenHeight = this.screenHeight;
        int usedScreenWidth = this.screenWidth;
        int rows = usedScreenHeight / this.buttonHeight;
        int columns = usedScreenWidth / this.buttonWidth;
        int vRest = usedScreenHeight % this.buttonHeight;
        int hRest = usedScreenWidth % this.buttonWidth;
        this.ccf = new CCF(this.prontoModel);
        if (this.prontoModel.getModel() == 0) {
            this.ccf.setScreenSize(this.screenWidth, this.screenHeight);
        }
        this.ccf.setVersionString("IrScrutinizer CCF");
        for (Remote remote : remoteSet.getRemotes()) {
            String remoteName = remote.getName();
            HashMap<String, Command> cmds = remote.getCommands();
            Iterator<Command> it = cmds.values().iterator();
            CCFDevice dev = this.ccf.createDevice(remoteName);
            this.ccf.appendDevice(dev);
            for (int panelNo = 0; panelNo < (int)((double)cmds.size() / (double)(rows * columns) + 0.999); ++panelNo) {
                CCFPanel panel = dev.createPanel(remoteName + "_codes_" + (panelNo + 1));
                dev.addPanel(panel);
                for (int x = 0; x < columns; ++x) {
                    for (int y = 0; y < rows && it.hasNext(); ++y) {
                        Command cmd = it.next();
                        String buttonName = cmd.getName();
                        if (buttonName.length() > 100) {
                            buttonName = buttonName.substring(0, 100);
                        }
                        CCFButton b1 = panel.createButton(buttonName);
                        b1.setFont(CCFFont.SIZE_8);
                        b1.setTextAlignment(2);
                        b1.setLocation(new Point(x * this.buttonWidth + x * hRest / (columns - 1), y * this.buttonHeight + y * vRest / (rows - 1)));
                        b1.setSize(new Dimension(this.buttonWidth, this.buttonHeight));
                        panel.addButton(b1);
                        String ccfstring = cmd.getCcf();
                        if (this.prontoModel.getModel() == 0 || (this.prontoModel.getCapability() & 0x40000) != 0) {
                            ccfstring = "0000 0000 0000 " + ccfstring;
                        }
                        CCFIRCode code = new CCFIRCode(dev.getHeader(), ccfstring);
                        b1.appendAction(new ActionIRCode(code));
                        CCFIconSet iconSet = b1.getIconSet();
                        iconSet.setForeground(2, CCFColor.getColor(0));
                        iconSet.setBackground(2, CCFColor.getColor(245));
                        iconSet.setForeground(3, CCFColor.getColor(245));
                        iconSet.setBackground(3, CCFColor.getColor(0));
                        b1.setIconSet(iconSet);
                    }
                }
            }
        }
    }
}

