/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.exporter.Exporter;

public abstract class RemoteSetExporter
extends Exporter {
    protected String creatingUser;

    protected RemoteSetExporter() {
        this(System.getProperty("user.name", "unknown"));
    }

    protected RemoteSetExporter(String creatingUser) {
        this.creatingUser = creatingUser;
    }

    public void export(RemoteSet remoteSet, String title, int repeatCount, boolean automaticFilenames, Component parent, File exportDir, String charsetName) throws IOException, IrpMasterException {
        this.export(remoteSet, title, repeatCount, this.exportFilename(automaticFilenames, parent, exportDir), charsetName);
    }

    public abstract void export(RemoteSet var1, String var2, int var3, File var4, String var5) throws IOException, IrpMasterException;

    public void export(Remote remote, String title, String source, int repeatCount, File saveFile, String charsetName) throws IrpMasterException, IOException {
        RemoteSet remoteSet = new RemoteSet(this.creatingUser, source, Exporter.getDateString(), "IrScrutinizer", "1.3", "DecodeIR", DecodeIR.getVersion(), null, remote);
        this.export(remoteSet, title, repeatCount, saveFile, charsetName);
    }

    public void export(HashMap<String, Command> commands, String source, String title, Remote.MetaData metaData, int repeatCount, File saveFile, String charsetName) throws IrpMasterException, IOException {
        Remote remote = new Remote(metaData, "Export from IrScrutinizer", null, commands, null, null, null);
        this.export(remote, title, source, repeatCount, saveFile, charsetName);
    }

    public File export(HashMap<String, Command> commands, String source, String title, Remote.MetaData metaData, int repeatCount, boolean automaticFilenames, Component parent, File exportDir, String charsetName) throws IrpMasterException, IOException {
        File file = this.exportFilename(automaticFilenames, parent, exportDir);
        if (file == null) {
            return null;
        }
        Remote remote = new Remote(metaData, "Export from IrScrutinizer", null, commands, null, null, null);
        this.export(remote, title, source, repeatCount, file, charsetName);
        return file;
    }

    public void export(Collection<Command> commands, String source, String title, int repeatCount, File saveFile, String charsetName) throws IOException, IrpMasterException {
        HashMap<String, Command> cmds = new HashMap<String, Command>(32);
        for (Command command : commands) {
            cmds.put(command.getName(), command);
        }
        this.export(cmds, source, title, new Remote.MetaData(), repeatCount, saveFile, charsetName);
    }

    public File export(Command command, String title, String source, int repeatCount, boolean automaticFilenames, Component parent, File exportDir, String charsetName) throws IOException, IrpMasterException {
        File file = this.exportFilename(automaticFilenames, parent, exportDir);
        if (file == null) {
            return null;
        }
        this.export(command, title, source, repeatCount, file, charsetName);
        return file;
    }

    public void export(Command command, String title, String source, int repeatCount, File saveFile, String charsetName) throws IrpMasterException, IOException {
        HashMap<String, Command> commands = new HashMap<String, Command>(1);
        commands.put(command.getName(), command);
        this.export(commands, title, source, new Remote.MetaData("IrScrutinizerExport"), repeatCount, saveFile, charsetName);
    }

    public boolean supportsEmbeddedFormats() {
        return false;
    }

    public boolean considersRepetitions() {
        return false;
    }

    public boolean supportsMetaData() {
        return false;
    }
}

