/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.exporter.IRemoteSetExporter;
import org.harctoolbox.irscrutinizer.exporter.RemoteSetExporter;

public class TextExporter
extends RemoteSetExporter
implements IRemoteSetExporter {
    private boolean generateRaw;
    private boolean generateCcf;
    private boolean generateParameters;
    private Command.CommandTextFormat[] extraFormatters;
    private PrintStream printStream;

    public TextExporter(boolean generateRaw, boolean generateCcf, boolean generateParameters, Command.CommandTextFormat ... extraFormatters) {
        this.generateRaw = generateRaw;
        this.generateCcf = generateCcf;
        this.generateParameters = generateParameters;
        this.extraFormatters = extraFormatters;
    }

    public TextExporter() {
        this(false, true, true, null);
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Text files (*.txt *.text)", "txt", "text"}};
    }

    @Override
    public String getFormatName() {
        return "Text";
    }

    @Override
    public String getPreferredFileExtension() {
        return "txt";
    }

    private void open(File file, String charsetName) throws FileNotFoundException, UnsupportedEncodingException {
        this.printStream = new PrintStream(file, charsetName);
    }

    private void close() {
        if (this.printStream != null) {
            this.printStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String payload, File exportFile, String charsetName) throws IrpMasterException, FileNotFoundException, UnsupportedEncodingException {
        this.open(exportFile, charsetName);
        try {
            this.printStream.println(payload);
        }
        finally {
            this.printStream.close();
        }
    }

    public File export(String payload, boolean automaticFilenames, Component parent, File exportDir, String charsetName) throws IrpMasterException, IOException {
        File file = this.exportFilename(automaticFilenames, parent, exportDir);
        this.export(payload, file, charsetName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(RemoteSet remoteSet, String title, int count, File file, String charsetName) throws IOException, IrpMasterException {
        this.open(file, charsetName);
        try {
            for (Command command : remoteSet.getAllCommands()) {
                this.printStream.println(this.formatCommand(command, count));
            }
        }
        finally {
            this.close();
        }
    }

    private String formatCommand(Command command, int count) throws IrpMasterException {
        StringBuilder str = new StringBuilder(128);
        String linefeed = System.getProperty("line.separator", "\n");
        str.append(this.generateParameters ? command.nameProtocolParameterString() : command.getName()).append(linefeed);
        if (this.generateCcf) {
            str.append(command.getCcf()).append(linefeed);
        }
        if (this.generateRaw) {
            str.append(command.getIntro()).append(linefeed);
            str.append(command.getRepeat()).append(linefeed);
            if (command.getEnding() != null && !command.getEnding().isEmpty()) {
                str.append(command.getEnding()).append(linefeed);
            }
        }
        for (Command.CommandTextFormat formatter : this.extraFormatters) {
            command.addFormat(formatter, count);
            str.append(command.getFormat(formatter.getName())).append(linefeed);
        }
        return str.toString();
    }

    @Override
    public boolean supportsEmbeddedFormats() {
        return true;
    }
}

