/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Wave;
import org.harctoolbox.girr.Command;
import org.harctoolbox.guicomponents.AudioParametersBean;
import org.harctoolbox.irscrutinizer.exporter.CommandExporter;
import org.harctoolbox.irscrutinizer.exporter.ICommandExporter;

public class WaveExporter
extends CommandExporter
implements ICommandExporter {
    private int sampleFrequency;
    private int sampleSize;
    private int channels;
    private boolean bigEndian;
    private boolean omitTail;
    private boolean square;
    private boolean divideCarrier;

    public WaveExporter(int sampleFrequency, int sampleSize, int channels, boolean bigEndian, boolean omitTail, boolean square, boolean divideCarrier) {
        this.sampleFrequency = sampleFrequency;
        this.sampleSize = sampleSize;
        this.channels = channels;
        this.bigEndian = bigEndian;
        this.omitTail = omitTail;
        this.square = square;
        this.divideCarrier = divideCarrier;
    }

    public WaveExporter(AudioParametersBean exportAudioParametersBean) {
        this(exportAudioParametersBean.getSampleFrequency(), exportAudioParametersBean.getSampleSize(), exportAudioParametersBean.getChannels(), exportAudioParametersBean.getBigEndian(), exportAudioParametersBean.getOmitTrailingGap(), exportAudioParametersBean.getSquare(), exportAudioParametersBean.getDivideCarrier());
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Wave files (*.wav *.wave)", "wav", "wave"}};
    }

    @Override
    public String getFormatName() {
        return "Wave";
    }

    @Override
    public String getPreferredFileExtension() {
        return "wav";
    }

    public void export(Command command, String source, String title, int repeatCount, File exportFile) throws IrpMasterException, FileNotFoundException {
        this.export(command, source, title, repeatCount, exportFile, null);
    }

    @Override
    public void export(Command command, String source, String title, int repeatCount, File exportFile, String charsetName) throws IrpMasterException, FileNotFoundException {
        ModulatedIrSequence seq = command.toIrSignal().toModulatedIrSequence(repeatCount);
        Wave wave = new Wave(seq, this.sampleFrequency, this.sampleSize, this.channels, this.bigEndian, this.omitTail, this.square, this.divideCarrier);
        wave.export(exportFile);
    }

    @Override
    public boolean considersRepetitions() {
        return true;
    }
}

