/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.ProntoModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IFileImporter;
import org.harctoolbox.irscrutinizer.importer.ProntoIrCode;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public class CcfImporter
extends RemoteSetImporter
implements IFileImporter {
    private CCF ccf;
    private boolean translateProntoFont = true;

    public static RemoteSet importCcf(String filename, String creatingUser) throws IOException, ParseException, IrpMasterException {
        CcfImporter importer = new CcfImporter();
        importer.load(filename);
        return importer.remoteSet;
    }

    public static void main(String[] args) {
        try {
            RemoteSet remoteSet = CcfImporter.importCcf(args[0], "The Creator");
            System.out.println(remoteSet);
        }
        catch (IOException | ParseException | IrpMasterException exception) {
            // empty catch block
        }
    }

    public void setTranslateProntoFont(boolean translateProntoFont) {
        this.translateProntoFont = translateProntoFont;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Pronto (classic) save files (*.ccf)", "ccf"}};
    }

    private Remote loadDevice(CCFDevice dev) {
        boolean totalUniqueNames = true;
        String deviceName = dev.getName();
        HashMap<String, Command> commands = new HashMap<String, Command>(64);
        for (CCFPanel panel = dev.getFirstPanel(); panel != null; panel = panel.getNextPanel()) {
            String panelName = panel.getName();
            ArrayList<Command> commandList = this.loadChildren(panel.getChildren(), deviceName, panelName);
            boolean uniqueNames = this.addCommands(commandList);
            totalUniqueNames = totalUniqueNames && uniqueNames;
            for (Command command : commandList) {
                commands.put(command.getName(), command);
            }
        }
        Remote remote = new Remote(new Remote.MetaData(deviceName), this.origin, "Imported by IrScrutinizer", commands, null);
        return remote;
    }

    private ArrayList<Command> loadChildren(CCFChild[] children, String deviceName, String panelName) {
        ArrayList<Command> commandList = new ArrayList<Command>(16);
        for (CCFChild child : children) {
            CCFButton button = child.getButton();
            String ccfString = null;
            if (button != null) {
                CCFAction[] action;
                boolean has_content = false;
                String buttonName = button.getName();
                if (buttonName == null) {
                    buttonName = "";
                }
                if ((action = button.getActions()) != null) {
                    int no_ccf = 0;
                    for (CCFAction action1 : action) {
                        if (action1.getActionType() != 1) continue;
                        has_content = true;
                        ActionIRCode code = (ActionIRCode)action1;
                        CCFIRCode ir = code.getIRCode();
                        if (ccfString == null) {
                            ccfString = ir.getCode();
                        }
                        ++no_ccf;
                    }
                    if (no_ccf > 1) {
                        System.err.println("Warning: " + no_ccf + " > 1 codes found in button " + buttonName + " in panel " + panelName + ". Ignoring all but the first.");
                    }
                }
                if (!has_content) continue;
                try {
                    Command command = new Command(this.translateProntoFont ? ProntoIrCode.translateProntoFont(buttonName) : buttonName, deviceName + "/" + panelName, ccfString);
                    commandList.add(command);
                }
                catch (IrpMasterException ex) {
                    System.err.println(ex.getMessage());
                }
                continue;
            }
            CCFFrame frame = child.getFrame();
            ArrayList<Command> childCommands = this.loadChildren(frame.getChildren(), deviceName, panelName + "/" + frame.getName());
            commandList.addAll(childCommands);
        }
        return commandList;
    }

    @Override
    public void load(Reader reader, String origin) throws IOException, FileNotFoundException, ParseException {
        this.dumbLoad(reader, origin, "windows-1252");
    }

    @Override
    public void load(File file, String origin, String charsetName) throws IOException {
        this.ccf = new CCF(ProntoModel.getModel(8));
        String filename = file.getPath();
        this.ccf.load(filename);
        this.load(this.ccf, origin);
    }

    private void load(CCF ccf, String origin) throws IOException {
        Remote remote;
        CCFDevice dev;
        this.prepareLoad(origin);
        HashMap<String, Remote> remotes = new HashMap<String, Remote>(16);
        for (dev = ccf.getFirstDevice(); dev != null; dev = dev.getNextDevice()) {
            remote = this.loadDevice(dev);
            if (remote.getCommands().isEmpty()) continue;
            remotes.put(remote.getName(), remote);
        }
        for (dev = ccf.getFirstHomeDevice(); dev != null; dev = dev.getNextDevice()) {
            remote = this.loadDevice(dev);
            if (remote.getCommands().isEmpty()) continue;
            remotes.put(remote.getName(), remote);
        }
        for (dev = ccf.getFirstMacroDevice(); dev != null; dev = dev.getNextDevice()) {
            remote = this.loadDevice(dev);
            if (remote.getCommands().isEmpty()) continue;
            remotes.put(remote.getName(), remote);
        }
        this.remoteSet = new RemoteSet(this.getCreatingUser(), origin, new Date().toString(), "IrScrutinizer", "1.3", null, null, null, remotes);
    }

    @Override
    public String getFormatName() {
        return "Pronto CCF";
    }
}

