/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IFileImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public class CmlImporter
extends RemoteSetImporter
implements IFileImporter,
Serializable {
    private static final int remoteToken = -1145324613;
    private static final int commandToken = -858993460;
    private static final int EOF = -1;
    private final String defaultCharsetName = "WINDOWS-1252";
    private String charactersetName = null;

    public static void main(String[] args) {
        try {
            CmlImporter cmlImporter = new CmlImporter();
            cmlImporter.load(args[0]);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CmlImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CmlImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParseException | IrpMasterException ex) {
            Logger.getLogger(CmlImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void load(Reader reader, String origin) throws IOException, ParseException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void load(File file, String origin, String charsetName) throws IOException, ParseException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.load(fileInputStream, origin, charsetName);
        }
    }

    @Override
    public void load(InputStream reader, String origin, String charsetName) throws IOException, ParseException {
        this.charactersetName = charsetName;
        this.prepareLoad(origin);
        this.remoteSet = this.parseRemoteSet(reader, origin);
        this.setupCommands();
    }

    private RemoteSet parseRemoteSet(InputStream inputStream, String origin) throws IOException, ParseException {
        int token;
        HashMap<String, Remote> remotes = new HashMap<String, Remote>(64);
        while ((token = this.searchToken(inputStream)) != -1145324613) {
            if (token != 0) continue;
            return null;
        }
        while (inputStream.available() > 0) {
            Remote remote = this.parseRemote(inputStream);
            if (remote == null) continue;
            remotes.put(remote.getName(), remote);
        }
        this.remoteSet = new RemoteSet(this.getCreatingUser(), origin, new Date().toString(), "IrScrutinizer", "1.3", null, null, null, remotes);
        return this.remoteSet;
    }

    private int searchToken(InputStream inputStream) throws IOException {
        int noHitsRemote = 0;
        int noHitsCommand = 0;
        do {
            int b;
            if ((b = inputStream.read()) == -1) {
                return 0;
            }
            noHitsRemote = b == 187 ? noHitsRemote + 1 : 0;
            int n = noHitsCommand = b == 204 ? noHitsCommand + 1 : 0;
            if (noHitsRemote != 4) continue;
            return -1145324613;
        } while (noHitsCommand != 4);
        return -858993460;
    }

    private Remote parseRemote(InputStream inputStream) throws IOException {
        int token;
        long status = inputStream.skip(12L);
        if (status != 12L) {
            return null;
        }
        String vendor = this.getString(inputStream, 21);
        String kind = this.getString(inputStream, 21);
        String model = this.getString(inputStream, 21);
        String remoteName = vendor + "_" + kind + "_" + model;
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>(32);
        while ((token = this.searchToken(inputStream)) == -858993460) {
            Command command = this.parseCommand(inputStream, remoteName);
            if (command == null) continue;
            commands.put(command.getName(), command);
        }
        if (commands.isEmpty()) {
            System.err.println("Remote " + remoteName + " has no commands, ignored.");
            return null;
        }
        Remote.MetaData metaData = new Remote.MetaData(remoteName, null, vendor, model, kind, null);
        return new Remote(metaData, null, null, commands, null);
    }

    private Command parseCommand(InputStream inputStream, String remoteName) throws IOException {
        byte[] x = this.getBytes(inputStream, 23);
        int wav = this.byte2unsigned(x[9]) + 256 * this.byte2unsigned(x[10]);
        int frequency = wav != 0 ? 1000000000 / wav : 0;
        int noTimings = this.byte2unsigned(x[11]);
        int introLength = this.byte2unsigned(x[12]) + 256 * this.byte2unsigned(x[13]);
        int repeatLength = this.byte2unsigned(x[14]) + 256 * this.byte2unsigned(x[15]);
        String commandName = this.getString(inputStream, 21);
        if (noTimings == 0) {
            return null;
        }
        byte[][] timingData = new byte[noTimings][3];
        for (int i = 0; i < noTimings; ++i) {
            int status = inputStream.read(timingData[i], 0, 3);
            if (status == 3) continue;
            throw new IOException("too short read");
        }
        int[] timingsTable = new int[noTimings];
        for (int i = 0; i < noTimings; ++i) {
            byte[] v = timingData[i];
            timingsTable[i] = (this.byte2unsigned(v[2]) + 1) * 32768 - this.byte2unsigned(v[0]) / 2 - 128 * this.byte2unsigned(v[1]);
        }
        int totalLength = introLength + repeatLength;
        int[] timingsMicroseconds = new int[totalLength];
        byte[] encodedDuration = this.getBytes(inputStream, totalLength);
        for (int i = 0; i < totalLength; ++i) {
            int index = this.byte2unsigned(encodedDuration[i]) - 1;
            timingsMicroseconds[i] = timingsTable[index];
        }
        if ((introLength & 1) != 0 || (repeatLength & 1) != 0) {
            System.err.println(String.format("%s/%s: funny lengths (%d, %d), command ignored", remoteName, commandName, introLength, repeatLength));
            return null;
        }
        IrSignal irSignal = new IrSignal(timingsMicroseconds, introLength / 2, repeatLength / 2, frequency);
        Command command = new Command(commandName, null, irSignal);
        return command;
    }

    private byte[] getBytes(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        int status = in.read(buf, 0, length);
        if (status != length) {
            throw new IOException("too short read");
        }
        return buf;
    }

    private String getString(InputStream in, int length) throws IOException {
        byte[] buf = this.getBytes(in, length);
        String str = new String(buf, this.charactersetName);
        int n = str.indexOf(0);
        return n == -1 ? str.trim() : str.substring(0, n).trim();
    }

    int byte2unsigned(byte x) {
        return x >= 0 ? x : x + 256;
    }

    @Override
    public boolean canImportDirectories() {
        return false;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"CML files (*.cml)", "cml"}, {"Zipped files (*.zip)", "zip"}};
    }

    @Override
    public String getFormatName() {
        return "CML";
    }
}

