/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public class CommandFusionImporter
extends RemoteSetImporter
implements IReaderImporter,
Serializable {
    public static final String homeUrl = "http://www.commandfusion.com/index.php";

    public static void main(String[] args) {
        CommandFusionImporter importer = new CommandFusionImporter();
        try {
            importer.load(args[0]);
        }
        catch (IOException | ParseException | IrpMasterException ex) {
            Logger.getLogger(CommandFusionImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void load(Reader reader, String origin) throws IOException {
        this.prepareLoad(origin);
        JsonObject jsonObject = JsonObject.readFrom(reader);
        Remote remote = this.parseRemote(jsonObject);
        this.remoteSet = new RemoteSet(this.getCreatingUser(), origin, new Date().toString(), "IrScrutinizer", "1.3", null, null, null, remote);
        this.setupCommands();
    }

    Remote parseRemote(JsonObject jsonObject) {
        JsonObject remoteInfo = (JsonObject)jsonObject.get("RemoteInfo");
        JsonArray remoteFunctions = (JsonArray)jsonObject.get("RemoteFunctions");
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>(8);
        for (JsonValue c : remoteFunctions) {
            Command command = this.parseCommand((JsonObject)c);
            if (command == null) continue;
            commands.put(command.getName(), command);
        }
        String name = remoteInfo.getString("RemoteID", null);
        String deviceClass = remoteInfo.getString("DeviceFamily", null);
        String manufacturer = remoteInfo.getString("Manufacturer", null);
        String model = remoteInfo.getString("DeviceModel", null);
        String remoteName = remoteInfo.getString("RemoteModel", null);
        String notes = remoteInfo.getString("Description", null);
        Remote remote = new Remote(new Remote.MetaData(name, null, manufacturer, model, deviceClass, remoteName), null, notes, commands, null);
        return remote;
    }

    private Command parseCommand(JsonObject cmd) {
        String name = cmd.getString("ID", null);
        String ccf = cmd.getString("CCF", null);
        Command command = null;
        try {
            command = new Command(name, null, ccf);
        }
        catch (IrpMasterException ex) {
            Logger.getLogger(CommandFusionImporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return command;
    }

    @Override
    public boolean canImportDirectories() {
        return false;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"CommandFusion files (*.cfir)", "cfir"}};
    }

    @Override
    public String getFormatName() {
        return "CommandFusion";
    }
}

