/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.importer.DatabaseImporter;
import org.harctoolbox.irscrutinizer.importer.IRemoteSetImporter;
import org.harctoolbox.irscrutinizer.importer.Importer;

public class ControlTowerIrDatabase
extends DatabaseImporter
implements IRemoteSetImporter {
    public static final String protocol = "https";
    public static final String controlTowerIrDatabaseHost = "irdb.globalcache.com";
    public static final int portNo = 8081;
    public static final String path = "/api";
    private static final String globalCacheDbOrigin = "irdb.globalcache.com";
    private boolean verbose = false;
    private String apiKey;
    private final String email;
    private final String password;
    private int codesRequestedToday = -1;
    private String accountType = null;
    private String name = null;
    private String company = null;
    private HashMap<String, String> manufacturerMap;
    private HashMap<String, String> typesMap;
    private String manufacturer;
    private String deviceType;
    private RemoteSet remoteSet;

    private JsonObject postAndGetObject(String str, String payload) throws MalformedURLException, IOException, LoginException {
        int httpResult;
        URL url = new URL(protocol, "irdb.globalcache.com", 8081, path + str);
        if (this.verbose) {
            System.err.println("Opening (POST) " + url.toString());
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json; charset=US-ASCII");
        connection.setRequestProperty("Content-Length", "" + Integer.toString(payload == null ? 0 : payload.getBytes(IrpUtils.dumbCharset).length));
        connection.setRequestProperty("Content-Language", "en-US");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(payload != null);
        if (payload != null) {
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(payload.getBytes("US-ASCII"));
                outputStream.flush();
            }
        }
        if ((httpResult = connection.getResponseCode()) != 200) {
            connection.disconnect();
            throw new LoginException("HTTP error " + httpResult);
        }
        InputStream is = connection.getInputStream();
        InputStreamReader isr = new InputStreamReader(is, IrpUtils.dumbCharset);
        JsonObject response = JsonObject.readFrom(isr);
        connection.disconnect();
        return response;
    }

    private String apiKeyString(char separator) {
        return this.apiKey == null ? "" : separator + "apiKey=" + this.apiKey;
    }

    private void evaluateAccount(JsonObject acct) {
        this.accountType = acct.get("AccountType").asString();
        this.apiKey = acct.get("ApiKey").asString();
        this.codesRequestedToday = acct.get("CodesRequestedToday").asInt();
    }

    private void evaluateAccount() {
        this.accountType = null;
        this.apiKey = null;
        this.codesRequestedToday = -1;
    }

    public void login() throws MalformedURLException, IOException, LoginException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("Email", this.email);
        jsonObject.add("Password", this.password);
        String payload = jsonObject.toString();
        JsonObject response = this.postAndGetObject("/account/login", payload);
        String status = response.get("Status").asString();
        if (!status.equals("success")) {
            throw new LoginException(response.get("Message").asString());
        }
        JsonObject acct = response.get("Account").asObject();
        this.evaluateAccount(acct);
    }

    public void logout() throws MalformedURLException, IOException, LoginException {
        if (this.apiKey == null) {
            throw new LoginException("Not logged in");
        }
        JsonObject response = this.postAndGetObject("/account/logout" + this.apiKeyString('?'), "");
        String status = response.get("Status").asString();
        if (!status.equals("success")) {
            throw new LoginException(response.get("Message").asString());
        }
        this.evaluateAccount();
    }

    private InputStreamReader getReader(String str) throws IOException {
        URL url = new URL(protocol, "irdb.globalcache.com", 8081, "/api/" + str);
        if (this.verbose) {
            System.err.println("Opening " + url.toString());
        }
        URLConnection urlConnection = url.openConnection();
        InputStream is = urlConnection.getInputStream();
        InputStreamReader isr = new InputStreamReader(is, IrpUtils.dumbCharset);
        return isr;
    }

    private JsonArray getJsonArray(String str) throws IOException {
        JsonArray arr = JsonArray.readFrom(this.getReader(str));
        return arr;
    }

    private JsonObject getJsonObject(String str) throws IOException {
        JsonObject obj = JsonObject.readFrom(this.getReader(str));
        return obj;
    }

    private HashMap<String, String> getMap(String urlFragment, String keyName, String valueName) throws IOException {
        JsonArray array = this.getJsonArray(urlFragment);
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (JsonValue val : array) {
            JsonObject obj = val.asObject();
            map.put(obj.get(keyName).asString(), obj.get(valueName).asString());
        }
        return map;
    }

    private void loadManufacturers() throws IOException {
        this.manufacturerMap = this.getMap("brands", "Name", "$id");
    }

    private void loadTypes() throws IOException {
        this.typesMap = this.getMap("types", "Name", "$id");
    }

    public String getStatus() throws IOException {
        if (this.apiKey == null) {
            return "Not logged in";
        }
        JsonObject obj = this.getJsonObject("account" + this.apiKeyString('?'));
        this.evaluateAccount(obj);
        return obj.toString();
    }

    public Collection<String> getManufacturers() throws IOException {
        if (this.manufacturerMap == null) {
            this.loadManufacturers();
        }
        return this.manufacturerMap.keySet();
    }

    public Collection<String> getDeviceTypes() throws IOException {
        if (this.typesMap == null) {
            this.loadTypes();
        }
        return this.typesMap.keySet();
    }

    public Collection<String> getDeviceTypes(String manufacturerKey) throws IOException {
        return this.getMap("brands/" + ControlTowerIrDatabase.httpEncode(manufacturerKey) + "/types", "Type", "$id").keySet();
    }

    public Collection<String> getManufacturers(String type) throws IOException {
        return this.getMap("types/" + ControlTowerIrDatabase.httpEncode(type) + "/brands", "Brand", "$id").keySet();
    }

    public HashMap<String, String> getModels(String manufacturer, String type) throws IOException {
        return this.getMap("brands/" + ControlTowerIrDatabase.httpEncode(manufacturer) + "/types/" + ControlTowerIrDatabase.httpEncode(type) + "/models", "Name", "ID");
    }

    public Model getModel(int setId) throws IOException {
        JsonObject obj = this.getJsonObject("/codesets/" + Integer.toString(setId) + "/models");
        return new Model(obj);
    }

    public HashMap<String, String> getCodesetTable(String manufacturerKey, String deviceTypeKey) throws IOException {
        return this.getMap("brands/" + ControlTowerIrDatabase.httpEncode(manufacturerKey) + "/types/" + ControlTowerIrDatabase.httpEncode(deviceTypeKey) + "/models", "Name", "ID");
    }

    public Collection<String> getCommands(int setId) throws IOException {
        return this.getMap("codesets/" + Integer.toString(setId) + "/functions", "Function", "$id").keySet();
    }

    public void getCodeset(int setId, boolean email) throws IOException, LoginException {
        if (this.apiKey == null) {
            throw new LoginException("Must be logged in");
        }
        if (email) {
            JsonObject obj = this.getJsonObject("codesets/" + Integer.toString(setId) + "?output=email" + this.apiKeyString('&'));
            if (!obj.get("Status").asString().equals("success")) {
                System.err.println(obj.get("Message").asString());
            }
            String str = obj.toString();
            System.out.println(str);
        } else {
            JsonObject obj = this.getJsonObject("codesets/" + Integer.toString(setId) + "?output=direct" + this.apiKeyString('&'));
            System.out.println(obj.toString());
            if (!obj.get("Status").asString().equals("success")) {
                System.err.println(obj.get("Message").asString());
            }
            String str = obj.toString();
            System.out.println(str);
        }
    }

    public void load(String manufacturerKey, String deviceTypeKey, String codeSet) throws IOException {
        this.clearCommands();
        this.manufacturer = manufacturerKey;
        this.deviceType = deviceTypeKey;
        JsonArray array = this.getJsonArray("codesets/" + codeSet + "/functions");
        for (JsonValue val : array) {
            JsonObject obj = val.asObject();
            String keyName = obj.get("Function").asString();
            Command cmd = new Command(keyName);
            this.addCommand(cmd);
        }
        Remote.MetaData metaData = new Remote.MetaData(this.manufacturer + "_" + this.deviceType + "_" + codeSet, this.manufacturer + " " + this.deviceType + " " + codeSet, this.manufacturer, null, this.deviceType, null);
        Remote remote = new Remote(metaData, null, null, this.getCommandIndex(), null);
        this.remoteSet = new RemoteSet(this.getCreatingUser(), this.origin, remote);
    }

    private static String httpEncode(String s) throws UnsupportedEncodingException {
        String str = s.replaceAll("&", "xampx").replaceAll("/", "xfslx").replaceAll(">", "xgtx").replaceAll("<", "xltx").replaceAll(":", "xcolx").replaceAll("\\?", "xquex").replaceAll("%", "xmodx").replaceAll("\\+", "xaddx");
        return URLEncoder.encode(str, "utf-8").replaceAll("\\+", "%20");
    }

    public ControlTowerIrDatabase(String apiKey, boolean verbose) {
        super("irdb.globalcache.com");
        this.email = null;
        this.password = null;
        this.apiKey = apiKey;
        this.verbose = verbose;
    }

    public ControlTowerIrDatabase(boolean verbose) {
        this(null, null, verbose);
    }

    public ControlTowerIrDatabase(String email, String password, boolean verbose) {
        super("irdb.globalcache.com");
        this.email = email;
        this.password = password;
        this.apiKey = null;
        this.verbose = verbose;
    }

    @Override
    public RemoteSet getRemoteSet() {
        return this.remoteSet;
    }

    public static void main(String[] args) {
        Props props = new Props(null);
        Importer.setProperties(props);
        try {
            ControlTowerIrDatabase gcdb = new ControlTowerIrDatabase(args[0], args[1], true);
            System.out.println(gcdb.getDeviceTypes("Sony"));
            System.out.println(gcdb.getModels("Sony", "Projector"));
            System.out.println(gcdb.getManufacturers("Blu Ray"));
            System.out.println(gcdb.getModels("Oppo Digital", "Blu Ray"));
            System.out.println(gcdb.getModel(1758));
            gcdb.login();
            System.out.println(gcdb.getStatus());
            gcdb.getCodeset(1758, false);
            System.out.println(gcdb.getStatus());
            gcdb.logout();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ControlTowerIrDatabase.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (LoginException ex) {
            System.err.println("Login failed: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public String getFormatName() {
        return "Global Cach\u00e9 Control Tower IR Database";
    }

    public static class Model {
        private final String brand;
        private final String type;
        private final String name;
        private final String notes;

        public Model(JsonObject obj) {
            this.brand = obj.get("Brand").asString();
            this.type = obj.get("Type").asString();
            this.name = obj.get("Name").asString();
            this.notes = obj.get("Notes").asString();
        }

        public String toString() {
            return "Brand: " + this.brand + "; Type: " + this.type + "; Name: " + this.name + "; Notes: " + this.notes;
        }
    }

    public static class LoginException
    extends Exception {
        public LoginException(String message) {
            super(message);
        }
    }
}

