/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.Serializable;
import java.util.ArrayList;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public abstract class CsvImporter
extends RemoteSetImporter
implements IReaderImporter,
Serializable {
    protected static final int invalid = -1;
    private static final String[][] separators = new String[][]{{", (comma)", ","}, {"; (semicolon)", ";"}, {": (colon)", ":"}, {"TAB", "\t"}, {"WHITESPACE", "\\s+"}};
    protected String separator;
    protected int nameColumn;
    protected boolean nameMultiColumn;
    protected int lineNo;

    public static String[] separatorsArray() {
        String[] result = new String[separators.length];
        for (int i = 0; i < separators.length; ++i) {
            result[i] = separators[i][0];
        }
        return result;
    }

    public static String getSeparator(int index) {
        return separators[index][1];
    }

    protected static String gobbleString(String[] chunks, int column, String aPriori, boolean includeTail, int offset) {
        if (column <= 0) {
            return aPriori;
        }
        if (column > chunks.length) {
            return null;
        }
        if (column + offset > chunks.length) {
            return null;
        }
        StringBuilder str = new StringBuilder(chunks[column - 1 + offset]);
        if (str.length() > 0 && str.charAt(str.length() - 1) == '\"') {
            str.deleteCharAt(str.length() - 1);
        }
        if (str.length() > 0 && str.charAt(0) == '\"') {
            str.deleteCharAt(0);
        }
        if (includeTail) {
            for (int c = column + offset; c < chunks.length; ++c) {
                str.append(" ").append(chunks[c]);
            }
        }
        return str.toString();
    }

    protected static String[] gobbleString(String[] chunks, int column, boolean nameMultiColumn, int basis, String aPriori, boolean rejectNumbers) {
        if (column <= 0) {
            return new String[]{aPriori};
        }
        if (column > chunks.length) {
            return new String[0];
        }
        String str = chunks[column - 1];
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        if (!nameMultiColumn) {
            return new String[]{str};
        }
        ArrayList<String> arrayList = new ArrayList<String>(8);
        arrayList.add(str);
        for (int index = column; index < chunks.length; ++index) {
            String chunk = chunks[index];
            if (basis == 16 && chunk.startsWith("0x")) {
                chunk = chunk.substring(2);
            }
            if (rejectNumbers && chunk.length() > 1) {
                try {
                    Integer.parseInt(chunk, basis);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            arrayList.add(chunk);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static String join(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder(128);
        for (String s : arr) {
            if (str.length() > 0) {
                str.append(" ");
            }
            str.append(s);
        }
        return str.toString();
    }

    public CsvImporter(String separator, int nameColumn, boolean nameMultiColumn) {
        this.nameMultiColumn = nameMultiColumn;
        this.separator = separator;
        this.nameColumn = nameColumn;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setSeparatorIndex(int separatorIndex) {
        this.separator = CsvImporter.getSeparator(separatorIndex);
    }

    public void setNameColumn(int nameColumn) {
        this.nameColumn = nameColumn;
    }

    public boolean isNameMultiColumn() {
        return this.nameMultiColumn;
    }

    public void setNameMultiColumn(boolean nameMultiColumn) {
        this.nameMultiColumn = nameMultiColumn;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Text files (*.txt *.text)", "txt", "text"}, {"CVS files (*.csv *.txt *.tsv)", "csv", "txt", "tsv"}};
    }

    @Override
    public boolean canImportDirectories() {
        return false;
    }

    @Override
    public String getFormatName() {
        return "Text (csv)";
    }
}

