/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.irscrutinizer.importer.CsvImporter;

public class CsvParametrizedImporter
extends CsvImporter {
    private int numberBase;
    private int fColumn;
    private int dColumn;
    private int sColumn;
    private int protocolColumn;

    public void setProtocolColumn(int protocolColumn) {
        this.protocolColumn = protocolColumn;
    }

    public void setNumberBase(int numberBase) {
        this.numberBase = numberBase;
    }

    public void setFColumn(int fColumn) {
        this.fColumn = fColumn;
    }

    public void setDColumn(int dColumn) {
        this.dColumn = dColumn;
    }

    public void setSColumn(int sColumn) {
        this.sColumn = sColumn;
    }

    public CsvParametrizedImporter(int separatorIndex, int nameColumn, boolean nameMultiColumn, boolean verbose, int base, int Fcolumn, int Dcolumn, int Scolumn, int protocolColumn) {
        this(CsvImporter.getSeparator(separatorIndex), nameColumn, nameMultiColumn, verbose, base, Fcolumn, Dcolumn, Scolumn, protocolColumn);
    }

    public CsvParametrizedImporter(String separator, int nameColumn, boolean nameMultiColumn, boolean verbose, int numberBase, int Fcolumn, int Dcolumn, int Scolumn, int protocolColumn) {
        super(separator, nameColumn, nameMultiColumn);
        this.numberBase = numberBase;
        this.fColumn = Fcolumn;
        this.dColumn = Dcolumn;
        this.sColumn = Scolumn;
        this.protocolColumn = protocolColumn;
    }

    @Override
    public void load(File file, String origin, String charsetName) throws FileNotFoundException, IOException, ParseException {
        try (FileInputStream stream = new FileInputStream(file);){
            this.load(stream, origin, charsetName);
        }
    }

    @Override
    public void load(Reader reader, String origin) throws IOException {
        String line;
        this.prepareLoad(origin);
        boolean rejectNumbers = this.nameColumn < this.protocolColumn || this.nameColumn < this.dColumn || this.nameColumn < this.sColumn || this.nameColumn < this.fColumn;
        this.lineNo = 1;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            block4: {
                String[] chunks = line.split(this.separator);
                try {
                    Command command = this.scrutinizeParameters(chunks, "Line " + this.lineNo + ", " + origin, rejectNumbers);
                    if (command != null) {
                        this.addCommand(command);
                    }
                }
                catch (IrpMasterException ex) {
                    if (!this.isVerbose()) break block4;
                    System.err.println("Errors parsing line " + this.lineNo + ": \"" + line + "\": " + ex.getMessage());
                }
            }
            ++this.lineNo;
        }
        this.setupRemoteSet();
    }

    private Command scrutinizeParameters(String[] chunks, String sourceAsComment, boolean rejectNumbers) throws IrpMasterException {
        long S;
        String[] nameArray = CsvParametrizedImporter.gobbleString(chunks, this.nameColumn, this.nameMultiColumn, this.numberBase, "-", rejectNumbers);
        if (nameArray == null || nameArray.length == 0) {
            return null;
        }
        int offset = nameArray.length - 1;
        String name = CsvParametrizedImporter.join(nameArray);
        HashMap<String, Long> parameters = new HashMap<String, Long>(3);
        long F = this.gobbleLong(chunks, this.fColumn, "F", this.nameColumn < this.fColumn ? offset : 0);
        if (F == -1L) {
            return null;
        }
        parameters.put("F", F);
        long D = this.gobbleLong(chunks, this.dColumn, "D", this.nameColumn < this.dColumn ? offset : 0);
        if (D != -1L) {
            parameters.put("D", D);
        }
        if ((S = this.gobbleLong(chunks, this.sColumn, "S", this.nameColumn < this.sColumn ? offset : 0)) != -1L) {
            parameters.put("S", S);
        }
        String protocol = CsvParametrizedImporter.gobbleString(chunks, this.protocolColumn, "-", false, this.nameColumn < this.protocolColumn ? offset : 0);
        return new Command(this.uniqueName(name), sourceAsComment, protocol, parameters);
    }

    private long gobbleLong(String[] chunks, int column, String name, int offset) {
        block5: {
            int colIndex;
            if (column == 0) {
                return -1L;
            }
            int n = colIndex = column > 0 ? column - 1 + offset : chunks.length + column;
            if (colIndex < chunks.length) {
                try {
                    String num = chunks[colIndex];
                    if (this.numberBase == 16 && num.startsWith("0x")) {
                        num = num.substring(2);
                    }
                    return Long.parseLong(num, this.numberBase);
                }
                catch (NumberFormatException ex) {
                    if (!this.isVerbose()) break block5;
                    System.err.println("Errors parsing " + name + " (= " + chunks[colIndex] + ") in line " + this.lineNo);
                }
            }
        }
        return -1L;
    }

    public static Collection<Command> process(Reader reader, String separator, int nameColumn, boolean nameMultiColumn, String filename, boolean verbose, int base, int Fcolumn, int Dcolumn, int Scolumn, int protocolColumn) throws IOException, IrpMasterException {
        CsvParametrizedImporter csvImportParametrized = new CsvParametrizedImporter(separator, nameColumn, nameMultiColumn, verbose, base, Fcolumn, Dcolumn, Scolumn, protocolColumn);
        csvImportParametrized.load(reader, filename);
        return csvImportParametrized.getCommands();
    }

    public static void main(String[] args) {
        try {
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(args[0]), IrpUtils.dumbCharset);
            Collection<Command> signals = CsvParametrizedImporter.process(r, ",", 1, false, args[0], true, 10, 3, -1, -1, -1);
            for (Command s : signals) {
                System.out.println(s.toString());
            }
        }
        catch (IOException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

