/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.harchardware.ir.InterpretStringHardware;
import org.harctoolbox.irscrutinizer.importer.CsvImporter;

public class CsvRawImporter
extends CsvImporter {
    private int codeColumn;
    private boolean includeTail;

    public static Collection<Command> process(File file, String separator, int nameColumn, boolean nameMultiColumn, int codeColumn, boolean includeTail, boolean invokeAnalyzer, boolean invokeRepeatFinder, boolean verbose, String charsetName) throws IOException, ParseException, IrpMasterException {
        CsvRawImporter csvImportRaw = new CsvRawImporter(separator, nameColumn, nameMultiColumn, codeColumn, includeTail);
        csvImportRaw.load(file, charsetName);
        return csvImportRaw.getCommands();
    }

    public static void main(String[] args) {
        try {
            Collection<Command> signals = CsvRawImporter.process(new File(args[0]), " ", 3, false, 6, true, true, true, true, "WINDOWS-1252");
            for (Command signal : signals) {
                System.out.println(signal.toPrintString());
            }
        }
        catch (IOException | ParseException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public CsvRawImporter(int separatorIndex, int nameColumn, boolean nameMultiColumn, int codeColumn, boolean includeTail) {
        this(CsvImporter.getSeparator(separatorIndex), nameColumn, nameMultiColumn, codeColumn, includeTail);
    }

    public CsvRawImporter(String separator, int nameColumn, boolean nameMultiColumn, int codeColumn, boolean includeTail) {
        super(separator, nameColumn, nameMultiColumn);
        this.separator = separator;
        this.nameColumn = nameColumn;
        this.codeColumn = codeColumn;
        this.includeTail = includeTail;
    }

    private CsvRawImporter() {
        this(0, 0, false, 1, false);
    }

    public void setCodeColumn(int codeColumn) {
        this.codeColumn = codeColumn;
    }

    public void setIncludeTail(boolean includeTail) {
        this.includeTail = includeTail;
    }

    @Override
    public void load(File file, String origin, String charsetName) throws IOException, ParseException {
        try (FileInputStream stream = new FileInputStream(file);){
            this.load(stream, origin, charsetName);
        }
    }

    private String[] csvSplit(String line, String separator) {
        StringBuilder str = new StringBuilder(line.trim());
        ArrayList<String> chunks = new ArrayList<String>(16);
        Pattern pattern = Pattern.compile(separator);
        while (str.length() > 0) {
            String chunk;
            if (str.length() >= separator.length() && separator.equals(str.substring(0, separator.length()))) {
                str.delete(0, separator.length());
            }
            while (str.length() > 0 && Character.isWhitespace(str.charAt(0))) {
                str.deleteCharAt(0);
            }
            if (str.length() > 0 && str.charAt(0) == '\"') {
                int n = str.indexOf("\"", 1);
                chunk = str.substring(1, n);
                str.delete(0, n + 1);
            } else {
                Matcher matcher = pattern.matcher(str);
                boolean success = matcher.find();
                if (success) {
                    chunk = str.substring(0, matcher.start());
                    str.delete(0, matcher.end());
                } else {
                    chunk = str.toString();
                    str.setLength(0);
                }
            }
            chunks.add(chunk.trim());
        }
        return chunks.toArray(new String[chunks.size()]);
    }

    @Override
    public void load(Reader reader, String origin) throws IOException {
        this.prepareLoad(origin);
        boolean rejectNumbers = this.nameColumn < this.codeColumn;
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.lineNo = 1;
        String line = bufferedReader.readLine();
        while (line != null) {
            String[] chunks = this.csvSplit(line, this.separator);
            Command signal = this.scrutinizeRaw(chunks, rejectNumbers);
            if (signal != null) {
                this.addCommand(signal);
            }
            ++this.lineNo;
            line = bufferedReader.readLine();
        }
        this.setupRemoteSet();
    }

    private Command scrutinizeRaw(String[] chunks, boolean rejectNumbers) {
        IrSignal irSignal;
        String[] nameArray = CsvRawImporter.gobbleString(chunks, this.nameColumn, this.nameMultiColumn, 16, "-", rejectNumbers);
        String name = CsvRawImporter.join(nameArray);
        if (name.isEmpty()) {
            return null;
        }
        int offset = nameArray.length - 1;
        String code = CsvRawImporter.gobbleString(chunks, this.codeColumn, null, this.includeTail, offset);
        if (code == null || code.isEmpty()) {
            if (this.isVerbose()) {
                System.err.println("Empty code in line " + this.lineNo);
            }
            return null;
        }
        try {
            irSignal = InterpretStringHardware.interpretString(code, 38000.0, this.isInvokeRepeatFinder(), this.isInvokeAnalyzer());
        }
        catch (IrpMasterException ex) {
            if (this.isVerbose()) {
                System.err.println("Error parsing code in line " + this.lineNo + " (" + ex.getMessage() + ")");
            }
            return null;
        }
        return irSignal != null ? new Command(this.uniqueName(name), "Line " + this.lineNo + ", " + this.origin, irSignal) : null;
    }
}

