/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.guicomponents.SelectFile;
import org.harctoolbox.irscrutinizer.importer.Importer;

public abstract class FileImporter
extends Importer {
    protected FileImporter() {
    }

    public abstract void load(File var1, String var2, String var3) throws IOException, ParseException;

    public final void load(File file, String charsetName) throws IOException, ParseException {
        if (!file.exists()) {
            throw new IOException("File does not exist.");
        }
        if (!file.isFile() && !this.canImportDirectories()) {
            throw new IOException("Not a normal file. Selected importer cannot import directories.");
        }
        this.load(file, file.getPath(), charsetName);
    }

    public boolean loadFileSelector(Component component, String title, String defaultDir, String charsetName) throws IOException, ParseException, IrpMasterException {
        File file = SelectFile.selectFile(component, title, defaultDir, false, false, this.canImportDirectories() ? 2 : 0, this.getFileExtensions());
        if (file == null) {
            return false;
        }
        this.load(file, charsetName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumbLoad(Reader reader, String origin, String charsetName) throws FileNotFoundException, IOException, ParseException {
        try (FileOutputStream out = null;){
            int c;
            File file = File.createTempFile("IrScrutinizer" + origin, null);
            out = new FileOutputStream(file);
            while ((c = reader.read()) != -1) {
                out.write(c);
            }
            this.load(file, charsetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void possiblyZipLoad(File file, String charsetName) throws ParseException, IOException {
        if (file.getName().toLowerCase(IrpUtils.dumbLocale).endsWith(".zip")) {
            boolean success;
            String extension = this.getFileExtensions()[0][1];
            File tmpFile = this.unzipFirstMatch(file, extension);
            try {
                this.load(tmpFile, file.getPath(), charsetName);
            }
            finally {
                success = tmpFile.delete();
            }
            if (!success) {
                throw new IOException("Deletion of temporary file " + file.getAbsolutePath() + " failed.");
            }
        } else {
            this.load(file, charsetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzipFirstMatch(File file, String extension) throws IOException {
        ZipFile zip = new ZipFile(file, 1);
        String payload = null;
        ZipEntry entry = null;
        int index = 0;
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (payload == null && enumeration.hasMoreElements()) {
            entry = enumeration.nextElement();
            if (extension == null || index == 0 && !enumeration.hasMoreElements() || entry.getName().toLowerCase(IrpUtils.dumbLocale).endsWith(extension)) {
                payload = entry.getName();
            }
            ++index;
        }
        if (payload == null) {
            zip.close();
            throw new IOException((extension == null ? "No content" : "No file with extension ." + extension) + " in " + file.getCanonicalPath());
        }
        InputStream in = null;
        FileOutputStream out = null;
        File outFile = null;
        try {
            int len;
            in = zip.getInputStream(entry);
            outFile = File.createTempFile("IrScrutinizer" + this.origin, null);
            outFile.deleteOnExit();
            out = new FileOutputStream(outFile);
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                zip.close();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        return outFile;
    }

    public boolean canImportDirectories() {
        return false;
    }

    public abstract String[][] getFileExtensions();

    public String[][] getFileExtensions(boolean zip) {
        String[][] exts = this.getFileExtensions();
        if (!zip) {
            return exts;
        }
        String[][] extensions = new String[exts.length + 1][2];
        System.arraycopy(exts, 0, extensions, 0, exts.length);
        extensions[exts.length][0] = "Zip files (*.zip)";
        extensions[exts.length][1] = "zip";
        return extensions;
    }
}

