/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.guicomponents.CopyClipboardText;
import org.harctoolbox.guicomponents.CopyPastePopupMenu;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.SelectFile;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.importer.IFileImporter;
import org.harctoolbox.irscrutinizer.importer.IImporter;
import org.harctoolbox.irscrutinizer.importer.IModulatedIrSequenceImporter;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.IRemoteSetImporter;
import org.harctoolbox.irscrutinizer.importer.TreeImporter;

public class FileImporterBean<T extends IFileImporter & IImporter>
extends JPanel {
    private transient T importer;
    private GuiUtils guiUtils;
    private transient Props properties;
    private CopyPastePopupMenu copyPastePopupMenu1;
    private JButton editBrowseButton;
    private JLabel fileUrlLabel;
    private JTextField filenameTextField;
    private JButton loadClipboardButton;
    private JButton loadFileButton;
    private JButton selectButton;
    private TreeImporter treeImporter;

    public FileImporterBean(GuiUtils guiUtils, Props properties, T importer) {
        this.guiUtils = guiUtils;
        this.importer = importer;
        this.properties = properties;
        this.setTransferHandler(new FileImporterBeanTransferHandler());
        this.initComponents();
        boolean sane = this.isSane();
        this.setEnabled(sane);
    }

    public FileImporterBean() {
        this.initComponents();
    }

    private boolean isSane() {
        if (this.guiUtils == null) {
            System.err.println("guiUtils is not setup in FileImporterBean");
            return false;
        }
        if (this.importer == null) {
            this.guiUtils.error("importer is null in FileImporterBean");
            return false;
        }
        if (this.properties == null) {
            this.guiUtils.error("properties is null in FileImporterBean");
            return false;
        }
        return true;
    }

    private void importSetUrl(String url) {
        this.filenameTextField.setText(url.trim());
        this.importUrl(url.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importUrl(String url) {
        if (url.isEmpty()) {
            return;
        }
        Cursor oldCursor = this.getCursor();
        this.repaint();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RemoteSet remoteSet = this.remoteSetImporterLoadFile(url);
            this.treeImporter.setRemoteSet(remoteSet);
        }
        catch (IOException | UnsupportedOperationException | ParseException | IrpMasterException ex) {
            this.treeImporter.clear();
            this.guiUtils.error(ex);
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    private RemoteSet getRemoteSet(T importer) {
        return IRemoteSetImporter.class.isInstance(importer) ? ((IRemoteSetImporter)importer).getRemoteSet() : (IModulatedIrSequenceImporter.class.isInstance(importer) ? new RemoteSet(((IImporter)importer).getFormatName() + " import", this.properties.getCreatingUser(), ((IModulatedIrSequenceImporter)importer).getModulatedIrSequence().toIrSignal(), "unnamed", null, "unknown") : null);
    }

    private RemoteSet remoteSetImporterLoadFile(String url) throws IOException, ParseException, IrpMasterException {
        if (IReaderImporter.class.isInstance(this.importer)) {
            ((IReaderImporter)this.importer).load(url, this.properties.getImportOpensZipFiles(), this.properties.getImportCharsetName());
        } else {
            this.importer.possiblyZipLoad(new File(url), this.properties.getImportCharsetName());
        }
        return this.getRemoteSet(this.importer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteSet remoteSetImporterLoadClipboard() throws IOException, ParseException, IrpMasterException {
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String payload = new CopyClipboardText(null).fromClipboard();
            if (payload == null) {
                this.guiUtils.error("No usable clipboard content");
                RemoteSet remoteSet = null;
                return remoteSet;
            }
            ((IReaderImporter)this.importer).load(payload, "<clipboard>", this.properties.getImportCharsetName());
            RemoteSet remoteSet = this.getRemoteSet(this.importer);
            return remoteSet;
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.treeImporter.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
        this.loadFileButton.setEnabled(enabled);
        this.loadClipboardButton.setEnabled(enabled && IReaderImporter.class.isInstance(this.importer));
        this.editBrowseButton.setEnabled(enabled);
        if (!IReaderImporter.class.isInstance(this.importer)) {
            this.loadClipboardButton.setVisible(false);
            this.loadFileButton.setText("Load File");
            this.fileUrlLabel.setText("File");
        }
    }

    private void initComponents() {
        this.copyPastePopupMenu1 = new CopyPastePopupMenu(true);
        this.treeImporter = new TreeImporter(this.guiUtils);
        this.filenameTextField = new JTextField();
        this.fileUrlLabel = new JLabel();
        this.selectButton = new JButton();
        this.loadFileButton = new JButton();
        this.loadClipboardButton = new JButton();
        this.editBrowseButton = new JButton();
        this.setToolTipText("Files \"dropped\" here will be imported.");
        this.filenameTextField.setComponentPopupMenu(this.copyPastePopupMenu1);
        this.fileUrlLabel.setText("File/URL:");
        this.selectButton.setText("...");
        this.selectButton.setToolTipText("Allows for selecting a local file by the use of a file selector. Does not load it, however. For this, use the \"Load File/URL\" button\".");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileImporterBean.this.selectButtonActionPerformed(evt);
            }
        });
        this.loadFileButton.setText("Load File/URL");
        this.loadFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileImporterBean.this.loadFileButtonActionPerformed(evt);
            }
        });
        this.loadClipboardButton.setText("Load from clipboard");
        this.loadClipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileImporterBean.this.loadClipboardButtonActionPerformed(evt);
            }
        });
        this.editBrowseButton.setText("Edit/View");
        this.editBrowseButton.setToolTipText("Allows for viewing or editing of the selected file/URL.");
        this.editBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileImporterBean.this.editBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.treeImporter, GroupLayout.Alignment.LEADING, -1, 595, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loadFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadClipboardButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editBrowseButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.fileUrlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filenameTextField).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectButton))))).addGap(0, 0, 0)));
        layout.linkSize(0, this.editBrowseButton, this.loadClipboardButton, this.loadFileButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileUrlLabel).addComponent(this.filenameTextField, -2, -1, -2).addComponent(this.selectButton)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadFileButton).addComponent(this.loadClipboardButton).addComponent(this.editBrowseButton)).addGap(6, 6, 6).addComponent(this.treeImporter, -1, 210, Short.MAX_VALUE)));
        layout.linkSize(1, this.editBrowseButton, this.loadClipboardButton, this.loadFileButton);
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        if (!this.isSane()) {
            return;
        }
        int selectionType = this.importer.canImportDirectories() ? 2 : 0;
        String[][] filetypes = this.importer.getFileExtensions(this.properties.getImportOpensZipFiles());
        File importFile = SelectFile.selectFile((Component)this, "Select " + ((IImporter)this.importer).getFormatName() + " file to import", this.properties.getDefaultImportDir(), false, false, selectionType, filetypes);
        if (importFile != null) {
            this.filenameTextField.setText(importFile.getPath());
            this.treeImporter.clear();
            try {
                this.properties.setDefaultImportDir(importFile.getParentFile().getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadFileButtonActionPerformed(ActionEvent evt) {
        if (this.filenameTextField.getText().isEmpty()) {
            this.selectButtonActionPerformed(evt);
        }
        this.importUrl(this.filenameTextField.getText().trim());
    }

    private void editBrowseButtonActionPerformed(ActionEvent evt) {
        String filename = this.filenameTextField.getText();
        if (filename.isEmpty()) {
            this.guiUtils.error("File/URL empty");
            return;
        }
        this.guiUtils.browseOrEdit(filename);
    }

    private void loadClipboardButtonActionPerformed(ActionEvent evt) {
        try {
            RemoteSet remoteSet = this.remoteSetImporterLoadClipboard();
            this.treeImporter.setRemoteSet(remoteSet);
        }
        catch (IOException | ParseException | IrpMasterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private class FileImporterBeanTransferHandler
    extends TransferHandler {
        private FileImporterBeanTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean copySupported;
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
            if (!copySupported) {
                return false;
            }
            support.setDropAction(1);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() != 1) {
                    FileImporterBean.this.guiUtils.error("Only one file may be dropped");
                    return false;
                }
                String filename = ((File)list.get(0)).getCanonicalPath();
                FileImporterBean.this.importSetUrl(filename);
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
            return true;
        }
    }
}

