/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GirrImporter
extends RemoteSetImporter
implements IReaderImporter,
Serializable {
    public static final String homeUrl = "http://www.harctoolbox.org/girr";
    private transient Schema schema = null;
    private transient URL url;
    private boolean validate;

    public GirrImporter(boolean validate, URL url) {
        this.url = url;
        this.validate = validate;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    private void loadSchema() throws SAXException {
        if (this.validate && this.schema == null && this.url != null) {
            this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.url);
        }
    }

    private void load(Document doc, String origin) throws ParseException, NotGirrRemoteSetException {
        this.prepareLoad(origin);
        this.remoteSet = null;
        this.loadIncremental(doc, origin);
        this.setupCommands();
    }

    private void loadIncremental(Document doc, String origin) throws ParseException, NotGirrRemoteSetException {
        if (!doc.getDocumentElement().getTagName().equals("remotes")) {
            throw new NotGirrRemoteSetException();
        }
        RemoteSet rs = new RemoteSet(doc);
        if (this.remoteSet == null) {
            this.remoteSet = rs;
        } else {
            this.remoteSet.append(rs);
        }
    }

    @Override
    public void load(InputStream inputStream, String origin, String charsetName) throws IOException, ParseException {
        try {
            this.loadSchema();
            this.load(XmlUtils.openXmlStream(inputStream, this.validate ? this.schema : null, false, false), origin);
        }
        catch (SAXParseException ex) {
            throw new ParseException(ex.getMessage(), ex.getLineNumber());
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (NotGirrRemoteSetException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void load(InputStream inputStream, String origin) throws IOException, ParseException {
        this.load(inputStream, origin, null);
    }

    @Override
    public void load(Reader reader, String origin) throws IOException, ParseException {
        try {
            this.loadSchema();
            this.load(XmlUtils.openXmlReader(reader, this.validate ? this.schema : null, false, false), origin);
        }
        catch (SAXParseException ex) {
            throw new ParseException(ex.getMessage(), ex.getLineNumber());
        }
        catch (NotGirrRemoteSetException | SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void load(File file, String origin, String charsetName) throws IOException {
        try {
            this.loadSchema();
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
        this.prepareLoad(origin);
        this.remoteSet = null;
        this.loadRecursive(file, origin);
        this.setupCommands();
    }

    private void loadRecursive(File fileOrDirectory, String origin) throws IOException {
        if (fileOrDirectory.isDirectory()) {
            File[] files;
            for (File file : files = fileOrDirectory.listFiles()) {
                if (file.getName().endsWith(".jpg") || file.getName().endsWith(".png") || file.getName().endsWith(".gif") || file.getName().endsWith(".html")) continue;
                this.loadRecursive(file, file.getCanonicalPath());
            }
        } else {
            try {
                this.loadIncremental(XmlUtils.openXmlFile(fileOrDirectory, this.validate ? this.schema : null, true, true), origin);
            }
            catch (ParseException | SAXParseException files) {
            }
            catch (NotGirrRemoteSetException | SAXException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    @Override
    public boolean canImportDirectories() {
        return true;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Girr files (*.girr)", "girr"}, {"XML files (*.xml)", "xml"}};
    }

    @Override
    public String getFormatName() {
        return "Girr";
    }

    private static class NotGirrRemoteSetException
    extends Exception {
        NotGirrRemoteSetException() {
            super("Not a Girr file with root element \"remotes\".");
        }
    }
}

