/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.importer.DatabaseImporter;
import org.harctoolbox.irscrutinizer.importer.IRemoteSetImporter;
import org.harctoolbox.irscrutinizer.importer.Importer;

public class GlobalCacheIrDatabase
extends DatabaseImporter
implements IRemoteSetImporter {
    public static final String globalCacheIrDatabaseHost = "irdatabase.globalcache.com";
    private static final String path = "/api/v1/";
    private static final String globalCacheDbOrigin = "irdatabase.globalcache.com";
    private boolean verbose = false;
    private final String apiKey;
    private HashMap<String, String> manufacturerMap = null;
    private String manufacturer;
    private String deviceType;
    private RemoteSet remoteSet;

    private static String httpEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "utf-8").replaceAll("\\+", "%20");
    }

    public static void main(String[] args) {
        Props props = new Props(null);
        Importer.setProperties(props);
        try {
            GlobalCacheIrDatabase gcdb = new GlobalCacheIrDatabase(props.getGlobalCacheApiKey(), true);
            System.out.println(gcdb.getManufacturers());
            System.out.println(gcdb.getDeviceTypes("philips"));
            System.out.println(gcdb.getCodeset("sony", "laser disc"));
            System.out.println(gcdb.getCommands("sony", "laser disc", "201"));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public GlobalCacheIrDatabase(String apiKey, boolean verbose) {
        super("irdatabase.globalcache.com");
        this.apiKey = apiKey;
        this.verbose = verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private JsonArray getJsonArray(String str) throws IOException {
        URL url = new URL("http", "irdatabase.globalcache.com", path + this.apiKey + "/" + str);
        if (this.verbose) {
            System.err.println("Opening " + url.toString());
        }
        URLConnection urlConnection = url.openConnection();
        return JsonArray.readFrom(new InputStreamReader(urlConnection.getInputStream(), IrpUtils.dumbCharset));
    }

    private HashMap<String, String> getMap(String urlFragment, String keyName, String valueName) throws IOException {
        JsonArray array = this.getJsonArray(urlFragment);
        HashMap<String, String> map = new HashMap<String, String>(64);
        for (JsonValue val : array) {
            JsonObject obj = val.asObject();
            map.put(obj.get(keyName).asString(), obj.get(valueName).asString());
        }
        return map;
    }

    private void loadManufacturers() throws IOException {
        this.manufacturerMap = this.getMap("manufacturers", "Manufacturer", "Key");
    }

    public Collection<String> getManufacturers() throws IOException {
        if (this.manufacturerMap == null) {
            this.loadManufacturers();
        }
        return this.manufacturerMap.values();
    }

    public Collection<String> getDeviceTypes(String manufacturerKey) throws IOException {
        return this.getMap("manufacturers/" + GlobalCacheIrDatabase.httpEncode(manufacturerKey) + "/devicetypes", "DeviceType", "Key").values();
    }

    public Collection<String> getCodeset(String manufacturerKey, String deviceTypeKey) throws IOException {
        return this.getMap("manufacturers/" + GlobalCacheIrDatabase.httpEncode(manufacturerKey) + "/devicetypes/" + GlobalCacheIrDatabase.httpEncode(deviceTypeKey) + "/codesets", "Codeset", "Key").values();
    }

    public ArrayList<Command> getCommands(String manufacturerKey, String deviceTypeKey, String codeSet) throws IOException {
        this.load(manufacturerKey, deviceTypeKey, codeSet);
        return this.getCommands();
    }

    public void load(String manufacturerKey, String deviceTypeKey, String codeSet) throws IOException {
        this.clearCommands();
        this.manufacturer = manufacturerKey;
        this.deviceType = deviceTypeKey;
        JsonArray array = this.getJsonArray("manufacturers/" + GlobalCacheIrDatabase.httpEncode(manufacturerKey) + "/devicetypes/" + GlobalCacheIrDatabase.httpEncode(deviceTypeKey) + "/codesets/" + codeSet);
        for (JsonValue val : array) {
            JsonObject obj = val.asObject();
            String str = obj.get("IRCode").asString();
            String[] chunks = str.split(",");
            int index = 0;
            int frequency = Integer.parseInt(chunks[index++].trim());
            int n = ++index;
            int repIndex = Integer.parseInt(chunks[n].trim());
            int[] durations = new int[chunks.length - ++index];
            double T = 1000000.0 / (double)frequency;
            for (int i = 0; i < chunks.length - index; ++i) {
                durations[i] = (int)Math.round((double)Integer.parseInt(chunks[i + index]) * T);
            }
            IrSignal irSignal = new IrSignal(durations, (repIndex - 1) / 2, (durations.length - repIndex + 1) / 2, frequency);
            String keyName = obj.get("KeyName").asString();
            Command cmd = new Command(keyName, "GCDB: " + this.manufacturer + "/" + this.deviceType + "/" + codeSet, irSignal);
            this.addCommand(cmd);
        }
        Remote.MetaData metaData = new Remote.MetaData(this.manufacturer + "_" + this.deviceType + "_" + codeSet, null, this.manufacturer, null, this.deviceType, null);
        Remote remote = new Remote(metaData, null, null, this.getCommandIndex(), null);
        this.remoteSet = new RemoteSet(this.getCreatingUser(), this.origin, remote);
    }

    @Override
    public RemoteSet getRemoteSet() {
        return this.remoteSet;
    }

    @Override
    public String getFormatName() {
        return "Global Cach\u00e9 IR Database";
    }
}

