/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.harctoolbox.IrpMaster.InterpretString;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public class IctImporter
extends RemoteSetImporter
implements IReaderImporter,
Serializable {
    private static final int invalid = -1;
    private static final int lengthInsertedGap = 100000;
    private int lineNumber;
    private int frequency = -1;
    private int sampleCount = -1;
    private int noSamples;
    private boolean hasComplainedAboutMissingFrequency;

    public static Collection<Command> importer(File file, String charsetName) throws IOException, ParseException, IrpMasterException {
        IctImporter imp = new IctImporter();
        imp.load(file, file.getCanonicalPath(), charsetName);
        return imp.getCommands();
    }

    public static Collection<Command> importer(BufferedReader reader) throws IOException {
        IctImporter imp = new IctImporter();
        imp.load(reader, null);
        return imp.getCommands();
    }

    @Override
    public void load(Reader reader, String origin) throws IOException {
        String line;
        this.prepareLoad(origin);
        this.hasComplainedAboutMissingFrequency = false;
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.lineNumber = 0;
        this.noSamples = 0;
        String name = "unnamed";
        ArrayList<Integer> data = new ArrayList<Integer>(64);
        while ((line = bufferedReader.readLine()) != null) {
            ++this.lineNumber;
            String[] chunks = line.split("[ ,=]");
            if (chunks[0].equals("carrier_frequency")) {
                this.frequency = Integer.parseInt(chunks[1]);
                continue;
            }
            if (chunks[0].equals("sample_count")) {
                this.sampleCount = Integer.parseInt(chunks[1]);
                continue;
            }
            if (chunks[0].startsWith("+")) {
                data.add(Integer.parseInt(chunks[0].substring(1)));
                ++this.noSamples;
                continue;
            }
            if (chunks[0].equals("pulse")) {
                data.add(Integer.parseInt(chunks[1]));
                ++this.noSamples;
                continue;
            }
            if (chunks[0].equals("note")) {
                this.processSignal(data, name, origin);
                data.clear();
                name = chunks[1];
                continue;
            }
            if (chunks[0].equals("irscope")) continue;
            if (chunks[0].startsWith("-")) {
                data.add(Integer.parseInt(chunks[0].substring(1)));
                ++this.noSamples;
                continue;
            }
            if (chunks[0].equals("space")) {
                if (data.isEmpty()) continue;
                data.add(Integer.parseInt(chunks[1]));
                ++this.noSamples;
                continue;
            }
            if (chunks[0].startsWith("#")) continue;
            System.err.println("Warning: Ignored line: " + this.lineNumber);
        }
        this.processSignal(data, name, origin);
        if (this.noSamples != this.sampleCount) {
            System.err.println("Warning: sample_count erroneous or missing (expected " + this.noSamples + " was " + this.sampleCount + ")");
        }
        this.setupRemoteSet();
    }

    private void processSignal(ArrayList<Integer> data, String name, String origin) {
        if (data.isEmpty()) {
            return;
        }
        if (data.size() % 2 == 1) {
            System.err.println("Warning: Last sample was pulse, appending a 100000 microsecond gap");
            data.add(100000);
        }
        int[] dataArray = new int[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            dataArray[i] = data.get(i);
        }
        if (this.frequency < 0 && this.hasComplainedAboutMissingFrequency) {
            this.hasComplainedAboutMissingFrequency = true;
            this.frequency = 38000;
            System.err.println("Warning: carrier_frequency missing, assuming 38000");
        }
        IrSignal irSignal = InterpretString.interpretIrSequence(dataArray, this.frequency, this.isInvokeRepeatFinder(), this.isInvokeAnalyzer());
        Command command = new Command(this.uniqueName(name), origin == null ? "ICT import" : "ICT import from " + origin, irSignal);
        this.addCommand(command);
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"IrScope files (*.ict)", "ict"}};
    }

    @Override
    public String getFormatName() {
        return "IrScope ict";
    }
}

