/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.girr.Command;
import org.harctoolbox.irscrutinizer.Props;

public abstract class Importer {
    private static Props properties = null;
    private final ArrayList<Command> commands = new ArrayList(32);
    private final LinkedHashMap<String, Command> commandIndex = new LinkedHashMap(32);
    protected String origin = null;

    public static void setProperties(Props newProperties) {
        properties = newProperties;
    }

    protected Importer() {
    }

    protected String getCreatingUser() {
        return properties != null ? properties.getCreatingUser() : null;
    }

    protected boolean isInvokeDecodeIr() {
        return properties != null && properties.getInvokeDecodeIr();
    }

    protected boolean isInvokeRepeatFinder() {
        return properties.getInvokeRepeatFinder();
    }

    protected boolean isInvokeAnalyzer() {
        return properties.getInvokeAnalyzer();
    }

    protected boolean isVerbose() {
        return properties.getVerbose();
    }

    protected boolean isGenerateRaw() {
        return properties != null && properties.getGenerateRaw();
    }

    protected boolean isGenerateCcf() {
        return properties.getGenerateCcf();
    }

    protected double getFallbackFrequency() {
        return properties.getFallbackFrequency();
    }

    protected double getEndTimeout() {
        return properties.getCaptureEndTimeout();
    }

    protected void prepareLoad(String origin) {
        this.origin = origin;
        this.clearCommands();
    }

    protected String uniqueName(String name) {
        String uniqueName = name;
        int index = 1;
        while (this.commandIndex.containsKey(uniqueName)) {
            uniqueName = name + '$' + Integer.toString(index++);
        }
        return uniqueName;
    }

    protected boolean addCommand(Command command) {
        this.commands.add(command);
        if (this.commandIndex.containsKey(command.getName())) {
            return false;
        }
        this.commandIndex.put(command.getName(), command);
        return true;
    }

    protected boolean addCommands(Collection<Command> commands) {
        boolean totalStatus = true;
        for (Command command : commands) {
            boolean status = this.addCommand(command);
            totalStatus = totalStatus && status;
        }
        return totalStatus;
    }

    public ArrayList<Command> getCommands() {
        return this.commands;
    }

    public Command getCommand(String name) {
        return this.commandIndex.get(name);
    }

    public ModulatedIrSequence getConcatenatedCommands() throws IrpMasterException {
        ModulatedIrSequence[] array = new ModulatedIrSequence[this.commands.size()];
        int index = 0;
        for (Command command : this.commands) {
            array[index++] = command.toIrSignal().toModulatedIrSequence(1);
        }
        return new ModulatedIrSequence(array);
    }

    public HashMap<String, Command> getCommandIndex() {
        return this.commandIndex;
    }

    protected void clearCommands() {
        this.commands.clear();
        this.commandIndex.clear();
    }

    public String getOrigin() {
        return this.origin;
    }

    public URL getHomeUrl() {
        return null;
    }
}

