/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public class IrTransImporter
extends RemoteSetImporter
implements IReaderImporter,
Serializable {
    public static final String homeUrl = "http://www.irtrans.com";
    public static final String defaultCharsetName = "windows-1252";
    private static final int dummyEndingGap = 50000;

    private Remote parseRemote(LineNumberReader reader) throws IOException, ParseException {
        String name = this.parseName(reader);
        if (name == null) {
            return null;
        }
        ArrayList<Timing> timings = this.parseTimings(reader);
        LinkedHashMap<String, IrTransCommand> parsedCommands = this.parseCommands(reader, timings);
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>(4);
        for (IrTransCommand cmd : ((HashMap)parsedCommands).values()) {
            try {
                Command command = cmd.toCommand();
                commands.put(command.getName(), command);
            }
            catch (IrpMasterException ex) {
                System.err.println(cmd.name + " Unparsable signal: " + ex.getMessage());
            }
        }
        return new Remote(new Remote.MetaData(name), null, null, commands, null);
    }

    private String parseName(LineNumberReader reader) throws IOException, ParseException {
        boolean success = this.gobbleTo(reader, "[REMOTE]", true);
        if (!success) {
            return null;
        }
        String line = reader.readLine();
        if (line == null) {
            throw new ParseException("[NAME] not found.", reader.getLineNumber());
        }
        String[] arr = line.trim().split("]");
        if (!arr[0].equals("[NAME")) {
            throw new ParseException("[NAME] not found.", reader.getLineNumber());
        }
        return arr[1];
    }

    private LinkedHashMap<String, IrTransCommand> parseCommands(LineNumberReader reader, ArrayList<Timing> timings) throws IOException, ParseException {
        String line;
        this.gobbleTo(reader, "[COMMANDS]", true);
        LinkedHashMap<String, IrTransCommand> commands = new LinkedHashMap<String, IrTransCommand>(32);
        while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
            try {
                IrTransCommand command = this.parseCommand(line, timings, reader.getLineNumber());
                commands.put(command.name, command);
            }
            catch (NumberFormatException | ParseException ex) {
                System.err.println("Command " + line + " (line " + reader.getLineNumber() + ") did not parse, ignored.");
            }
        }
        return commands;
    }

    private IrTransCommand parseCommand(String line, ArrayList<Timing> timings, int lineNo) throws ParseException {
        String type;
        IrTransCommand command = null;
        String[] arr = line.trim().split("[\\[\\]]");
        int index = 1;
        String name = arr[index++];
        int n = ++index;
        ++index;
        switch (type = arr[n]) {
            case "RAW": {
                String data;
                String[] numbers;
                int noNumbers = Integer.parseInt(arr[index++]);
                if (!arr[index++].equals("FREQ")) {
                    throw new ParseException("No FREQ in raw signal", lineNo);
                }
                int frequency = Integer.parseInt(arr[index++]);
                if (!arr[index++].equals("D")) {
                    throw new ParseException("[D] not found", lineNo);
                }
                if ((numbers = (data = arr[index++]).split(" ")).length != noNumbers) {
                    throw new ParseException("Wrong number of durations", lineNo);
                }
                int[] times = new int[noNumbers + noNumbers % 2];
                int durationIndex = 0;
                int numberIndex = 0;
                while (numberIndex < noNumbers) {
                    int t = Integer.parseInt(numbers[numberIndex]);
                    if (t == 0) {
                        times[durationIndex] = 256 * Integer.parseInt(numbers[numberIndex + 1]) + Integer.parseInt(numbers[numberIndex + 2]);
                        numberIndex += 3;
                    } else {
                        times[durationIndex] = t;
                        ++numberIndex;
                    }
                    ++durationIndex;
                }
                if (durationIndex % 2 != 0) {
                    times[durationIndex++] = 50000;
                }
                command = new IrTransCommandRaw(name, frequency, times, durationIndex);
                break;
            }
            case "CCF": {
                command = new IrTransCommandCcf(name, arr[index++]);
                break;
            }
            case "T": {
                int timingNo = Integer.parseInt(arr[index++]);
                if (!arr[index++].equals("D")) {
                    throw new ParseException("[D] not found", lineNo);
                }
                String data = arr[index++];
                command = new IrTransCommandIndexed(name, data, timings.get(timingNo));
                break;
            }
            default: {
                throw new ParseException("Unknown command type " + type, lineNo);
            }
        }
        if (index != arr.length) {
            throw new ParseException("unparsable line", lineNo);
        }
        return command;
    }

    private boolean gobbleTo(LineNumberReader reader, String target, boolean throwException) throws IOException, ParseException {
        String line = "";
        reader.mark(255);
        while (line.isEmpty()) {
            line = reader.readLine();
            if (line != null) continue;
            return false;
        }
        if (!line.trim().equals(target)) {
            if (throwException) {
                throw new ParseException(target + " not found.", reader.getLineNumber());
            }
            reader.reset();
            return false;
        }
        return true;
    }

    private ArrayList<Timing> parseTimings(LineNumberReader reader) throws IOException, ParseException {
        String line;
        ArrayList<Timing> timings = new ArrayList<Timing>(16);
        boolean hasTiming = this.gobbleTo(reader, "[TIMING]", false);
        if (!hasTiming) {
            return null;
        }
        while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
            String[] arr = line.trim().split("[\\[\\]]");
            int number = Integer.parseInt(arr[1]);
            Timing timing = new Timing();
            timings.add(number, timing);
            int index = 3;
            while (index < arr.length) {
                String token = arr[index];
                if (token.isEmpty()) {
                    ++index;
                    continue;
                }
                switch (token) {
                    case "N": {
                        timing.durations = new int[Integer.parseInt(arr[++index])][2];
                        break;
                    }
                    case "RC": {
                        timing.repetitions = Integer.parseInt(arr[++index]);
                        break;
                    }
                    case "RP": {
                        timing.pause = Integer.parseInt(arr[++index]);
                        break;
                    }
                    case "FL": {
                        timing.framelength = Integer.parseInt(arr[++index]);
                        timing.pause = -1;
                        break;
                    }
                    case "FREQ": {
                        timing.frequency = Integer.parseInt(arr[++index]);
                        break;
                    }
                    case "FREQ-MEAS": {
                        timing.freqMeas = true;
                        break;
                    }
                    case "SB": {
                        timing.startBit = true;
                        break;
                    }
                    case "RS": {
                        timing.repeatStart = true;
                        break;
                    }
                    case "RC5": {
                        timing.type = TimingType.rc5;
                        break;
                    }
                    case "RC6": {
                        timing.type = TimingType.rc6;
                        break;
                    }
                    case "NOTOG": {
                        timing.noToggle = true;
                        break;
                    }
                    case "RCMM-TOGGLE": {
                        timing.rcmmToggle = true;
                        break;
                    }
                    case "RO": {
                        ++index;
                        break;
                    }
                    case "IRDA": 
                    case "IRDA-RAW": {
                        break;
                    }
                    default: {
                        try {
                            int timingNumber = Integer.parseInt(token);
                            String[] durations = arr[++index].split(" ");
                            for (int i = 0; i < 2; ++i) {
                                timing.durations[timingNumber - 1][i] = Integer.parseInt(durations[i]);
                            }
                            break;
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException("Unknown token: " + token, reader.getLineNumber());
                        }
                    }
                }
                ++index;
            }
        }
        return timings;
    }

    @Override
    public void load(Reader reader, String origin) throws IOException, ParseException {
        Remote remote;
        this.prepareLoad(origin);
        LineNumberReader bufferedReader = new LineNumberReader(reader);
        HashMap<String, Remote> remotes = new HashMap<String, Remote>(16);
        while ((remote = this.parseRemote(bufferedReader)) != null) {
            remotes.put(remote.getName(), remote);
        }
        this.remoteSet = new RemoteSet(this.getCreatingUser(), origin, new Date().toString(), "IrScrutinizer", "1.3", null, null, null, remotes);
    }

    public void load(File file) throws IOException, ParseException {
        this.load(file, defaultCharsetName);
    }

    @Override
    public boolean canImportDirectories() {
        return false;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"IrTrans files (*.rem)", "rem"}};
    }

    @Override
    public String getFormatName() {
        return "IrTrans";
    }

    public static void main(String[] args) {
        IrTransImporter importer = new IrTransImporter();
        try {
            importer.load(new File(args[0]));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage() + ex.getErrorOffset());
        }
    }

    private static class IrTransCommandCcf
    extends IrTransCommand {
        String ccf;

        IrTransCommandCcf(String name, String ccf) {
            super(name);
            this.ccf = ccf;
        }

        @Override
        Command toCommand() throws IrpMasterException {
            return new Command(this.name, null, this.ccf);
        }
    }

    private static class IrTransCommandRaw
    extends IrTransCommand {
        private final int[] durations;
        private final int frequency;

        IrTransCommandRaw(String name, int frequency, int[] durations, int effectiveLength) {
            super(name);
            this.frequency = frequency;
            this.durations = new int[effectiveLength];
            System.arraycopy(durations, 0, this.durations, 0, effectiveLength);
        }

        @Override
        Command toCommand() {
            IrSignal irSignal = new IrSignal(this.durations, 0, this.durations.length / 2, 1000 * this.frequency);
            return new Command(this.name, null, irSignal);
        }
    }

    private static class IrTransCommandIndexed
    extends IrTransCommand {
        private final String data;
        private final Timing timing;

        IrTransCommandIndexed(String name, String data, Timing timing) {
            super(name);
            this.data = data;
            this.timing = timing;
        }

        @Override
        Command toCommand() throws IrpMasterException {
            if (this.timing.type == TimingType.rc5) {
                long payload = Long.parseLong(this.data, 2);
                long F6 = (payload >> 12 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                long F = F6 << 6 | payload & 0x3FL;
                long D = payload >> 6 & 0x1FL;
                long T = payload >> 11 & 1L;
                HashMap<String, Long> parameters = new HashMap<String, Long>(4);
                parameters.put("F", F);
                parameters.put("D", D);
                parameters.put("T", T);
                return new Command(this.name, null, "RC5", parameters);
            }
            if (this.timing.type == TimingType.rc6) {
                long payload = Long.parseLong(this.data.substring(2), 2);
                long F = payload & 0xFFL;
                long D = payload >> 8 & 0xFFL;
                HashMap<String, Long> parameters = new HashMap<String, Long>(4);
                parameters.put("F", F);
                parameters.put("D", D);
                return new Command(this.name, null, "RC6", parameters);
            }
            int[] times = new int[2 * this.data.length()];
            for (int i = 0; i < this.data.length(); ++i) {
                int index;
                char ch = this.data.charAt(i);
                int n = ch == 'S' ? 0 : (index = Character.digit(ch, 36) + (this.timing.startBit ? 1 : 0));
                if (index >= this.timing.durations.length) {
                    throw new IrpMasterException("Undefined timing :" + ch);
                }
                times[2 * i] = this.timing.durations[index][0];
                times[2 * i + 1] = this.timing.durations[index][1];
            }
            IrSignal irSignal = new IrSignal(times, 0, times.length / 2, 1000 * this.timing.frequency);
            return new Command(this.name, null, irSignal);
        }
    }

    private static abstract class IrTransCommand {
        String name;

        private IrTransCommand() {
        }

        protected IrTransCommand(String name) {
            this.name = name;
        }

        abstract Command toCommand() throws IrpMasterException;
    }

    private static enum CommandType {
        raw,
        ccf,
        timing;

    }

    private static class Timing {
        int[][] durations = null;
        int repetitions = -1;
        int pause = -1;
        int framelength = -1;
        int frequency = -1;
        boolean freqMeas = false;
        boolean startBit = false;
        boolean repeatStart = false;
        TimingType type = TimingType.normal;
        boolean noToggle = false;
        boolean rcmmToggle = false;

        private Timing() {
        }
    }

    private static enum TimingType {
        rc5,
        rc6,
        normal;

    }
}

