/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.DatabaseImporter;
import org.harctoolbox.irscrutinizer.importer.IRemoteSetImporter;

public class IrdbImporter
extends DatabaseImporter
implements IRemoteSetImporter {
    private static final Proxy proxy = Proxy.NO_PROXY;
    private static final long invalid = -1L;
    private static final String irdbOriginName = "IRDB";
    private static ArrayList<String> manufacturers;
    private static final String irdbHost = "irdb.tk";
    private static final String urlFormat = "/api/code/?brand=%s&page=%d";
    private static final String urlFormatBrands = "/api/brand/?page=%d";
    private boolean verbose = false;
    private String manufacturer;
    private RemoteSet remoteSet;
    private HashMap<String, HashMap<ProtocolDeviceSubdevice, HashMap<String, Long>>> deviceTypes;

    public static URI getHomeUri() {
        try {
            return new URI("http", irdbHost, null, null);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    private static long parseLong(String str) {
        try {
            return str == null || str.isEmpty() ? -1L : Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static String[] getManufacturers(boolean verbose) throws IOException {
        if (manufacturers == null) {
            IrdbImporter.setupManufacturers(verbose);
        }
        return manufacturers.toArray(new String[manufacturers.size()]);
    }

    private static JsonObject getJsonObject(String urlString, boolean verbose) throws IOException {
        URL url;
        URL uRL = url = urlString.contains("//") ? new URL(urlString) : new URL("http", irdbHost, urlString);
        if (verbose) {
            System.err.print("Accessing " + url.toString() + "...");
        }
        URLConnection urlConnection = url.openConnection(proxy);
        InputStream stream = urlConnection.getInputStream();
        return JsonObject.readFrom(new InputStreamReader(stream, IrpUtils.dumbCharset));
    }

    private static void setupManufacturers(boolean verbose) throws IOException {
        manufacturers = new ArrayList(1024);
        String path = String.format(urlFormatBrands, 1);
        for (int index = 1; index <= 100 && !path.isEmpty(); ++index) {
            JsonObject o = IrdbImporter.getJsonObject(path, verbose);
            JsonValue meta = o.get("meta");
            JsonObject metaObject = meta.asObject();
            path = metaObject.get("next").asString();
            if (verbose) {
                System.err.println("Read page " + metaObject.get("page").asInt());
            }
            JsonArray objects = o.get("objects").asArray();
            for (JsonValue val : objects) {
                JsonObject obj = val.asObject();
                String brand = obj.get("brand").asString();
                if (manufacturers.contains(brand)) continue;
                manufacturers.add(brand);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String[] manufacturers = IrdbImporter.getManufacturers(true);
            IrdbImporter irdb = new IrdbImporter(manufacturers[11], true);
            System.out.println(irdb.deviceTypes);
            System.out.println(irdb.getDeviceTypes());
            for (String type : irdb.getDeviceTypes()) {
                System.out.println(irdb.getProtocolDeviceSubdevice(type));
                for (ProtocolDeviceSubdevice pds : irdb.getProtocolDeviceSubdevice(type)) {
                    System.out.println(irdb.getCommands(type, pds));
                }
            }
        }
        catch (IOException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public IrdbImporter(String manufacturer, boolean verbose) throws IOException {
        super(irdbOriginName);
        this.manufacturer = manufacturer;
        this.verbose = verbose;
        this.deviceTypes = new LinkedHashMap<String, HashMap<ProtocolDeviceSubdevice, HashMap<String, Long>>>(16);
        String path = String.format(urlFormat, URLEncoder.encode(manufacturer, "utf-8"), 1);
        for (int index = 1; index <= 100 && !path.isEmpty(); ++index) {
            JsonObject o = IrdbImporter.getJsonObject(path, verbose);
            JsonValue meta = o.get("meta");
            JsonObject metaObject = meta.asObject();
            path = metaObject.get("next").asString();
            if (verbose) {
                System.err.println("Read page " + metaObject.get("page").asInt());
            }
            JsonArray objects = o.get("objects").asArray();
            for (JsonValue val : objects) {
                JsonObject obj = val.asObject();
                String deviceType = obj.get("devicetype").asString();
                if (!this.deviceTypes.containsKey(deviceType)) {
                    this.deviceTypes.put(deviceType, new LinkedHashMap(8));
                }
                HashMap<ProtocolDeviceSubdevice, HashMap<String, Long>> devCollection = this.deviceTypes.get(deviceType);
                ProtocolDeviceSubdevice pds = new ProtocolDeviceSubdevice(obj);
                if (pds.getProtocol() == null) {
                    System.err.println("Null protocol ignored");
                    continue;
                }
                if (!devCollection.containsKey(pds)) {
                    devCollection.put(pds, new LinkedHashMap(8));
                }
                HashMap<String, Long> cmnds = devCollection.get(pds);
                long function = IrdbImporter.parseLong(obj.get("function").asString());
                String functionName = obj.get("functionname").asString();
                if (cmnds.containsKey(functionName)) {
                    System.err.println("functionname " + functionName + " more than once present, overwriting");
                }
                cmnds.put(functionName, function);
            }
        }
    }

    @Override
    public RemoteSet getRemoteSet() {
        return this.remoteSet;
    }

    @Override
    public String getFormatName() {
        return irdbOriginName;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Set<String> getDeviceTypes() {
        return this.deviceTypes.keySet();
    }

    public Set<ProtocolDeviceSubdevice> getProtocolDeviceSubdevice(String deviceType) {
        HashMap<ProtocolDeviceSubdevice, HashMap<String, Long>> map = this.deviceTypes.get(deviceType);
        return map == null ? null : map.keySet();
    }

    public void load(String deviceType, ProtocolDeviceSubdevice pds) throws IrpMasterException {
        this.clearCommands();
        HashMap<ProtocolDeviceSubdevice, HashMap<String, Long>> map = this.deviceTypes.get(deviceType);
        if (map == null) {
            return;
        }
        HashMap<String, Long> commandMap = map.get(pds);
        this.load(commandMap, pds, deviceType);
        Remote.MetaData metaData = new Remote.MetaData(this.manufacturer + "_" + deviceType + "_" + pds.toString(), null, null, null, deviceType, null);
        Remote remote = new Remote(metaData, null, null, this.getCommandIndex(), null);
        this.remoteSet = new RemoteSet(this.getCreatingUser(), irdbOriginName, remote);
    }

    public void load(String deviceType) throws IrpMasterException {
        this.clearCommands();
        HashMap<ProtocolDeviceSubdevice, HashMap<String, Long>> map = this.deviceTypes.get(deviceType);
        if (map == null) {
            return;
        }
        LinkedHashMap<String, Remote> remoteList = new LinkedHashMap<String, Remote>(16);
        for (Map.Entry<ProtocolDeviceSubdevice, HashMap<String, Long>> kvp : map.entrySet()) {
            HashMap<String, Long> commandMap = kvp.getValue();
            ProtocolDeviceSubdevice pds = kvp.getKey();
            HashMap<String, Command> cmds = this.load(commandMap, pds, deviceType);
            Remote.MetaData metaData = new Remote.MetaData(this.manufacturer + "_" + deviceType + "_" + pds.toString(), null, null, null, deviceType, null);
            Remote remote = new Remote(metaData, null, null, cmds, null);
            remoteList.put(remote.getName(), remote);
        }
        this.remoteSet = new RemoteSet(this.getCreatingUser(), irdbOriginName, remoteList);
    }

    private HashMap<String, Command> load(HashMap<String, Long> commandMap, ProtocolDeviceSubdevice pds, String deviceType) throws IrpMasterException {
        LinkedHashMap<String, Command> cmds = new LinkedHashMap<String, Command>(16);
        for (Map.Entry<String, Long> kvp : commandMap.entrySet()) {
            HashMap<String, Long> parameters = IrpUtils.mkParameters(pds.getDevice(), pds.subdevice, kvp.getValue());
            Command command = new Command(kvp.getKey(), "IRDB: " + this.manufacturer + "/" + deviceType + "/" + pds.toString(), pds.getProtocol(), parameters);
            cmds.put(command.getName(), command);
            this.addCommand(command);
        }
        return cmds;
    }

    public ArrayList<Command> getCommands(String deviceType, ProtocolDeviceSubdevice pds) throws IrpMasterException {
        this.load(deviceType, pds);
        return this.getCommands();
    }

    public void load(String deviceType, String protocol, long device, long subdevice) throws IrpMasterException {
        this.load(deviceType, new ProtocolDeviceSubdevice(protocol, device, subdevice));
    }

    public Command getCommand(String deviceType, String protocol, long device, long subdevice, String functionName) throws IrpMasterException {
        this.load(deviceType, new ProtocolDeviceSubdevice(protocol, device, subdevice));
        return this.getCommand(functionName);
    }

    public static class ProtocolDeviceSubdevice
    implements Serializable {
        private String protocol;
        private long device;
        private long subdevice;

        public ProtocolDeviceSubdevice(String protocol, long device, long subdevice) {
            this.protocol = protocol;
            this.device = device;
            this.subdevice = subdevice;
        }

        public ProtocolDeviceSubdevice(JsonValue jprotocol, long device, long subdevice) {
            this(jprotocol.isString() ? jprotocol.asString() : null, device, subdevice);
        }

        public ProtocolDeviceSubdevice(String protocol, long device) {
            this(protocol, device, -1L);
        }

        public ProtocolDeviceSubdevice(JsonObject json) {
            this(json.get("protocol"), IrdbImporter.parseLong(json.get("device").asString()), IrdbImporter.parseLong(json.get("subdevice").asString()));
        }

        public long getDevice() {
            return this.device;
        }

        public long getSubdevice() {
            return this.subdevice;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ProtocolDeviceSubdevice dsd = (ProtocolDeviceSubdevice)o;
            return this.protocol.equals(dsd.protocol) && this.device == dsd.device && this.subdevice == dsd.subdevice;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.protocol != null ? this.protocol.hashCode() : 0);
            hash = 97 * hash + (int)(this.device ^ this.device >>> 32);
            hash = 97 * hash + (int)(this.subdevice ^ this.subdevice >>> 32);
            return hash;
        }

        public String toString() {
            return "protocol=" + this.protocol + ", device=" + Long.toString(this.device) + (this.subdevice == -1L ? "" : ", subdevice=" + Long.toString(this.subdevice));
        }
    }
}

