/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collection;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;
import org.harctoolbox.jirc.ConfigFile;
import org.harctoolbox.jirc.IrRemote;

public class LircImporter
extends RemoteSetImporter
implements IReaderImporter,
Serializable {
    public static final String remotesUrl = "http://lirc.sourceforge.net/remotes/";
    public static final String homeUrl = "http://www.lirc.org/";
    private static final int debug = 0;
    private static final boolean alternatingSigns = true;
    private boolean rejectLircCode = false;

    public void setRejectLircCode(boolean newRejectLircCode) {
        this.rejectLircCode = newRejectLircCode;
    }

    private void load(Collection<IrRemote> lircRemotes, String origin) {
        this.prepareLoad(origin);
        this.remoteSet = IrRemote.newRemoteSet(lircRemotes, origin, this.getCreatingUser(), true, 0);
        this.setupCommands();
    }

    @Override
    public void load(InputStream inputStream, String origin, String charsetName) throws IOException {
        this.load(ConfigFile.readConfig(new InputStreamReader(inputStream, charsetName), origin, this.rejectLircCode), origin);
    }

    @Override
    public void load(String input, String origin) throws IOException {
        this.load(ConfigFile.readConfig(new StringReader(input), origin, this.rejectLircCode), origin);
    }

    @Override
    public void load(File file, String origin, String charsetName) throws IOException {
        this.load(ConfigFile.readConfig(file, charsetName, this.rejectLircCode), origin);
    }

    @Override
    public void load(Reader reader, String origin) throws IOException {
        this.load(ConfigFile.readConfig(reader, origin, this.rejectLircCode), origin);
    }

    @Override
    public boolean canImportDirectories() {
        return true;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Conf files (*.conf)", "conf"}, {"Lirc files (*.lirc)", "lirc"}};
    }

    @Override
    public String getFormatName() {
        return "LIRC";
    }
}

