/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.irscrutinizer.importer.IModulatedIrSequenceImporter;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.ReaderImporter;

public class Mode2Importer
extends ReaderImporter
implements IModulatedIrSequenceImporter,
IReaderImporter {
    private ModulatedIrSequence sequence;

    @Override
    public void load(Reader reader, String origin) throws IOException, ParseException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<Integer> data = new ArrayList<Integer>(256);
        boolean lastWasPulse = false;
        int lineNo = 0;
        while ((line = bufferedReader.readLine()) != null) {
            int duration;
            boolean isPulse;
            ++lineNo;
            if (line.isEmpty()) continue;
            if (line.startsWith("pulse")) {
                isPulse = true;
            } else if (line.startsWith("space")) {
                isPulse = false;
                if (data.isEmpty()) {
                    continue;
                }
            } else {
                throw new ParseException("Unknown line: " + line, lineNo);
            }
            try {
                duration = Integer.parseInt(line.substring(6));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unparsable data: " + line, lineNo);
            }
            if (lastWasPulse != isPulse) {
                data.add(duration);
            } else {
                int index = data.size() - 1;
                data.set(index, (Integer)data.get(index) + duration);
            }
            lastWasPulse = isPulse;
        }
        if (data.size() % 2 != 0) {
            data.add((int)(1000.0 * this.getEndTimeout()));
        }
        int[] array = new int[data.size()];
        int i = 0;
        for (Integer duration : data) {
            array[i++] = duration;
        }
        try {
            this.sequence = new ModulatedIrSequence(array, this.getFallbackFrequency());
        }
        catch (IncompatibleArgumentException ex) {
            throw new ParseException(ex.getMessage(), lineNo);
        }
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Mode2 files (*.mode2 *.txt)", "mode2", "txt"}};
    }

    @Override
    public String getFormatName() {
        return "Mode2";
    }

    @Override
    public ModulatedIrSequence getModulatedIrSequence() {
        return this.sequence;
    }
}

