/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.IrpUtils;

public class ProtocolsIni
implements Serializable {
    private HashMap<Integer, HashMap<String, String>> pidMap = new LinkedHashMap<Integer, HashMap<String, String>>(256);
    private HashMap<String, HashMap<String, String>> nameMap = new LinkedHashMap<String, HashMap<String, String>>(32);

    private static long reverse(long x, int width) {
        long y = Long.reverse(x);
        if (width > 0) {
            y >>>= 64 - width;
        }
        return y;
    }

    private static long complement(long x, int width) {
        long y = 0xFFFFFFFFFFFFFFFFL ^ x;
        return (long)((1 << width) - 1) & y;
    }

    public static void main(String[] args) {
        try {
            ProtocolsIni protocolsIni = new ProtocolsIni(new File(args[0]));
            System.out.println(protocolsIni);
        }
        catch (IOException | ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public ProtocolsIni(File file) throws IOException, ParseException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), IrpUtils.dumbCharset));
    }

    public ProtocolsIni(Reader reader) throws IOException, ParseException {
        BufferedReader in = new BufferedReader(reader);
        LinkedHashMap<String, String> currentProtocol = null;
        int lineNo = 0;
        String lineRead = in.readLine();
        while (lineRead != null) {
            String payload;
            ++lineNo;
            String line = lineRead.trim();
            String[] kw = line.split("=", 2);
            String keyword = kw[0];
            String string = payload = kw.length > 1 ? kw[1].trim() : null;
            while (payload != null && payload.endsWith("\\")) {
                payload = payload.substring(0, payload.length() - 1);
                payload = payload + in.readLine();
            }
            if (!line.startsWith("#") && !line.isEmpty()) {
                if (line.startsWith("[")) {
                    String name = line.substring(1, line.length() - 1);
                    currentProtocol = new LinkedHashMap<String, String>(16);
                    currentProtocol.put("name", name);
                    this.nameMap.put(name, currentProtocol);
                } else {
                    if (currentProtocol == null) {
                        throw new ParseException("currentProtocol not defined", lineNo);
                    }
                    currentProtocol.put(keyword, payload);
                    if (keyword.equals("PID")) {
                        if (payload == null) {
                            throw new ParseException("payload not defined", lineNo);
                        }
                        int pid = Integer.parseInt(payload.replaceAll(" ", ""), 16);
                        this.pidMap.put(pid, currentProtocol);
                    }
                }
            }
            lineRead = in.readLine();
        }
    }

    public String getProperty(int pid, String property) {
        return this.pidMap.get(pid).get(property);
    }

    public String getProperty(String protocol, String property) {
        return this.nameMap.get(protocol).get(property);
    }

    public String[] getDeviceParameters(String protocol) {
        return this.getDeviceParameters(this.nameMap.get(protocol));
    }

    public String[] getDeviceParameters(int pid) {
        return this.getDeviceParameters(this.pidMap.get(pid));
    }

    private String[] getDeviceParameters(HashMap<String, String> map) {
        if (map == null) {
            return new String[0];
        }
        String str = map.get("DevParms");
        if (str == null) {
            return new String[0];
        }
        String[] params = str.split(",");
        for (int i = 0; i < params.length; ++i) {
            String in = params[i].split("=")[0];
            params[i] = this.translate(in);
        }
        return params;
    }

    private String translate(String in) {
        return in.equals("Device Number") ? "D" : (in.equals("Device Code") ? "D" : (in.equals("Device") ? "D" : (in.equals("Sub Device") ? "S" : null)));
    }

    public ICmdTranslator[] getCmdTranslators(String protocol) {
        return this.getCmdTranslators(this.nameMap.get(protocol));
    }

    public ICmdTranslator[] getCmdTranslators(int pid) {
        return this.getCmdTranslators(this.pidMap.get(pid));
    }

    private ICmdTranslator[] getCmdTranslators(HashMap<String, String> map) {
        if (map == null) {
            return new ICmdTranslator[0];
        }
        String str = map.get("CmdTranslator");
        if (str == null) {
            return new ICmdTranslator[0];
        }
        String[] chunks = str.split(" ");
        ICmdTranslator[] translators = new ICmdTranslator[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            translators[i] = this.translator(chunks[i]);
        }
        return translators;
    }

    private ICmdTranslator translator(String name) {
        return name.equals("Translator(lsb,comp)") ? new LsbComp() : (name.equals("Translator(lsb,comp,3)") ? new LsbComp3() : null);
    }

    public static interface ICmdTranslator {
        public long translate(long var1);
    }

    public static class LsbComp3
    implements ICmdTranslator {
        @Override
        public long translate(long x) {
            long y = x >> 8;
            return ProtocolsIni.reverse(ProtocolsIni.complement(y, 8), 8);
        }
    }

    public static class LsbComp
    implements ICmdTranslator {
        @Override
        public long translate(long x) {
            return ProtocolsIni.reverse(ProtocolsIni.complement(x, 8), 8);
        }
    }
}

