/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.harchardware.ir.InterpretStringHardware;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;

public class RawLineImporter
extends RemoteSetImporter
implements IReaderImporter {
    public static void main(String[] args) {
        RawLineImporter rli = new RawLineImporter();
        try {
            rli.load(new File(args[0]), "WINDOWS-1252");
            for (Command command : rli.getCommands()) {
                System.out.println(command.toPrintString());
            }
        }
        catch (IOException | ParseException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Text files (*.txt *.text)", "txt", "text"}};
    }

    @Override
    public void load(Reader reader, String origin) throws IOException {
        String line;
        this.prepareLoad(origin);
        BufferedReader bufferedReader = new BufferedReader(reader);
        String name = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            IrSignal irSignal = null;
            try {
                irSignal = InterpretStringHardware.interpretString(line, this.getFallbackFrequency(), this.isInvokeRepeatFinder(), this.isInvokeAnalyzer());
            }
            catch (IrpMasterException ex) {
                name = line;
            }
            if (name == null || irSignal == null) continue;
            Command command = new Command(this.uniqueName(name), null, irSignal);
            this.addCommand(command);
            name = null;
        }
        this.setupRemoteSet();
    }

    @Override
    public String getFormatName() {
        return "Text file";
    }
}

