/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.irscrutinizer.importer.FileImporter;

public abstract class ReaderImporter
extends FileImporter {
    protected ReaderImporter() {
    }

    public abstract void load(Reader var1, String var2) throws IOException, ParseException;

    @Override
    public void load(File file, String origin, String charsetName) throws IOException, ParseException {
        this.load(new InputStreamReader((InputStream)new FileInputStream(file), charsetName), origin);
    }

    public void load(String charsetName) throws IOException, ParseException, IrpMasterException {
        this.load(System.in, "<STDIN>", charsetName);
    }

    public void load(InputStream inputStream, String origin, String charsetName) throws IOException, ParseException {
        this.load(new InputStreamReader(inputStream, charsetName), origin);
    }

    public void load(String payload, String origin, String charsetName) throws IOException, ParseException, IrpMasterException {
        this.load(new ByteArrayInputStream(payload.getBytes(charsetName)), origin, charsetName);
    }

    public void load(String urlOrFilename, boolean zip, String charsetName) throws IOException, ParseException {
        if (urlOrFilename == null || urlOrFilename.isEmpty()) {
            throw new IOException("Empty file name/URL");
        }
        try {
            URL url = new URL(urlOrFilename);
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            this.load(inputStream, urlOrFilename, charsetName);
        }
        catch (MalformedURLException ex) {
            if (zip) {
                this.possiblyZipLoad(new File(urlOrFilename), charsetName);
            }
            this.load(new File(urlOrFilename), charsetName);
        }
    }

    public void load(String urlOrFilename, String charsetName) throws IOException, ParseException, IrpMasterException {
        this.load(urlOrFilename, false, charsetName);
    }
}

