/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.ProtocolsIni;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;
import org.w3c.dom.Document;

public class RmduImporter
extends RemoteSetImporter
implements Serializable,
IReaderImporter {
    public static final String homeUrl = "http://www.hifi-remote.com/wiki/index.php?title=Remote_Master_Manual";
    public static final String defaultCharsetName = "WINDOWS-1252";
    private static final String separator = "=";
    private static JCommander argumentParser;
    private static CommandLineArgs commandLineArgs;
    private HashMap<String, String> parameters;
    private Remote remote;
    private ProtocolsIni protocolsIni;

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder(256);
        argumentParser.usage(str);
        (exitcode == 0 ? System.out : System.err).println(str);
        RmduImporter.doExit(exitcode);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        String configFilename;
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("Lirc2Xml");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        if (RmduImporter.commandLineArgs.helpRequested) {
            RmduImporter.usage(0);
        }
        if (RmduImporter.commandLineArgs.versionRequested) {
            System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
            System.exit(0);
        }
        String string = configFilename = RmduImporter.commandLineArgs.configfile.isEmpty() ? "STDIN" : RmduImporter.commandLineArgs.configfile.get(0);
        if (RmduImporter.commandLineArgs.debug > 0) {
            System.err.println("debug = " + RmduImporter.commandLineArgs.debug);
            System.err.println("outputfilename = " + RmduImporter.commandLineArgs.outputfile);
            System.err.println("configfile = " + configFilename);
        }
        try {
            ProtocolsIni protocolsIni = RmduImporter.commandLineArgs.inifile != null ? new ProtocolsIni(new File(RmduImporter.commandLineArgs.inifile)) : null;
            RmduImporter rmdu = new RmduImporter(protocolsIni);
            if (RmduImporter.commandLineArgs.configfile.isEmpty()) {
                rmdu.load();
            } else {
                rmdu.load(new File(RmduImporter.commandLineArgs.configfile.get(0)));
            }
            RemoteSet remoteSet = new RemoteSet(null, configFilename, rmdu.getRemote());
            Document doc = remoteSet.xmlExportDocument("Rmdu import of " + IrpUtils.basename(configFilename), "xsl", RmduImporter.commandLineArgs.stylesheetUrl, true, true, true, true, true);
            XmlUtils.printDOM(new File(RmduImporter.commandLineArgs.outputfile), doc);
        }
        catch (IOException | ParseException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public RmduImporter() {
    }

    public RmduImporter(ProtocolsIni protocolsIni) {
        this.protocolsIni = protocolsIni;
    }

    public void setProtocolsIni(ProtocolsIni protocolsIni) {
        this.protocolsIni = protocolsIni;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"RemoteMaster device updates (*.rmdu)", "rmdu"}, {"RemoteMaster all files (*.rmdu *.rmir)", "rmdu", "rmir"}, {"RemoteMaster remote configurations (*.rmir)", "rmir"}};
    }

    public Remote getRemote() {
        return this.remote;
    }

    public void load() throws IOException, ParseException, IrpMasterException {
        this.load(defaultCharsetName);
    }

    public void load(File file) throws IOException, ParseException {
        this.load(file, defaultCharsetName);
    }

    @Override
    public void load(Reader reader, String origin) throws IOException, ParseException {
        String[] devParams;
        ProtocolsIni.ICmdTranslator[] translators;
        this.prepareLoad(origin);
        this.parameters = new LinkedHashMap<String, String>(8);
        BufferedReader bufferedReader = new BufferedReader(reader);
        HashMap<Integer, Long> functionHex = new HashMap<Integer, Long>(8);
        HashMap<Integer, String> functionName = new HashMap<Integer, String>(8);
        HashMap<Integer, String> functionNotes = new HashMap<Integer, String>(8);
        int lineNo = 0;
        while (true) {
            String line = bufferedReader.readLine();
            ++lineNo;
            if (line == null) break;
            String[] chunks = line.split(separator);
            if (chunks.length != 2) continue;
            String key = chunks[0];
            String value = chunks[1];
            if (key.startsWith("Function.")) {
                int number = Integer.parseInt(key.substring(9, key.lastIndexOf(46)));
                if (key.endsWith(".name")) {
                    functionName.put(number, value);
                    continue;
                }
                if (key.endsWith(".hex")) {
                    functionHex.put(number, Long.parseLong(value.replaceAll(" ", ""), 16));
                    continue;
                }
                if (key.endsWith(".notes")) {
                    functionNotes.put(number, value);
                    continue;
                }
                System.err.println("Unknown stuff");
                continue;
            }
            if (this.parameters.containsKey(key)) {
                System.err.println("Warning: multiple occurances of key " + key + ", ignoring all but the first");
                continue;
            }
            this.parameters.put(key, value);
        }
        String protocolName = this.parameters.get("Protocol.name");
        if (protocolName == null) {
            throw new ParseException("Protocol.name not found", lineNo);
        }
        ProtocolsIni.ICmdTranslator[] iCmdTranslatorArray = translators = this.protocolsIni != null ? this.protocolsIni.getCmdTranslators(protocolName) : null;
        if ((translators == null || translators.length == 0) && this.protocolsIni != null) {
            translators = this.protocolsIni.getCmdTranslators(Integer.parseInt(this.parameters.get("Protocol").replaceAll(" ", ""), 16));
        }
        String[] stringArray = devParams = this.protocolsIni != null ? this.protocolsIni.getDeviceParameters(this.parameters.get("Protocol.name")) : null;
        if ((devParams == null || devParams.length == 0) && this.protocolsIni != null) {
            devParams = this.protocolsIni.getDeviceParameters(Integer.parseInt(this.parameters.get("Protocol").replaceAll(" ", ""), 16));
        }
        HashMap<String, Long> protocolParams = new HashMap<String, Long>(8);
        String protocolParamsString = this.parameters.get("ProtocolParms");
        String[] params = protocolParamsString != null ? protocolParamsString.split(" ") : new String[]{};
        for (int i = 0; i < params.length; ++i) {
            try {
                String paramName = devParams != null && i < devParams.length && devParams[i] != null ? devParams[i] : "param" + i;
                protocolParams.put(paramName, Long.parseLong(params[i]));
                continue;
            }
            catch (NumberFormatException paramName) {
                // empty catch block
            }
        }
        for (Map.Entry kvp : functionName.entrySet()) {
            long hex;
            Integer functionNo = (Integer)kvp.getKey();
            HashMap<String, Long> commandParameters = new HashMap<String, Long>(8);
            commandParameters.putAll(protocolParams);
            Long hexObject = (Long)functionHex.get(functionNo);
            long l = hex = hexObject != null ? hexObject : -1L;
            if (hex != -1L) {
                commandParameters.put("hex", hex);
            }
            if (translators != null && translators.length > 0 && translators[0] != null && hex != -1L) {
                commandParameters.put("F", translators[0].translate(hex));
            }
            try {
                Command command = new Command((String)kvp.getValue(), functionNotes.get(functionNo) != null ? (String)functionNotes.get(functionNo) : "Function." + functionNo, this.getParameters().get("Protocol.name"), commandParameters);
                this.addCommand(command);
            }
            catch (IrpMasterException ex) {
                System.err.println("Warning: Command with name '" + (String)kvp.getValue() + "' is erroneous and was ignored.");
            }
        }
        HashMap<String, HashMap<String, String>> appParams = new HashMap<String, HashMap<String, String>>(8);
        appParams.put("rmdu", this.parameters);
        Remote.MetaData metaData = new Remote.MetaData(IrpUtils.basename(origin), null, null, null, this.parameters.get("DeviceType"), this.parameters.get("Remote.name"));
        this.remote = new Remote(metaData, this.parameters.get("Description"), this.parameters.get("Notes"), this.getCommandIndex(), appParams, this.parameters.get("Protocol.name"), protocolParams);
        this.remoteSet = new RemoteSet(this.getCreatingUser(), origin, new Date().toString(), "IrScrutinizer", "1.3", null, null, null, this.remote);
    }

    @Override
    public String getFormatName() {
        return "RemoteMaster";
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-d", "--debug"}, description="Debug")
        int debug = 0;
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        boolean helpRequested = false;
        @Parameter(names={"-i", "--inifile"}, description="Path to protocols.ini")
        String inifile = null;
        @Parameter(names={"-o", "--outfile"}, description="Output filename")
        String outputfile = null;
        @Parameter(names={"-v", "--version"}, description="Display version information")
        boolean versionRequested;
        @Parameter(names={"-x", "--xslt"}, description="Link to XSLT stylesheet")
        String stylesheetUrl = null;
        @Parameter(description="[configfile]")
        ArrayList<String> configfile = new ArrayList(2);

        private CommandLineArgs() {
        }
    }
}

