/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.irscrutinizer.GuiMain;
import org.harctoolbox.irscrutinizer.HardwareUnavailableException;
import org.harctoolbox.irscrutinizer.importer.ImportType;

public class TreeImporter
extends JPanel
implements TreeExpansionListener {
    private GuiUtils guiUtils;
    private GuiMain guiMain = null;
    private DefaultMutableTreeNode root;
    private RemoteSet remoteSet;
    private boolean restrictedMode = false;
    private static final int maxRemotesForImportAll = 10;
    private JButton importAllButton;
    private JMenuItem importAllMenuItem;
    private JButton importAllRawButton;
    private JMenuItem importAllRawMenuItem;
    private JButton importSelectionButton;
    private JMenuItem importSelectionMenuItem;
    private JButton importSelectionRawButton;
    private JMenuItem importSelectionRawMenuItem;
    private JButton importSignalButton;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu popupMenu;
    private JMenuItem printSignalMenuItem;
    private JMenuItem scrutinizeSignalMenuItem;
    private JButton transmitSelectedButton;
    private JMenuItem transmitSignalMenuItem;
    private JTree tree;

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode remote = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (!Remote.class.isInstance(remote.getUserObject())) {
            return;
        }
        Enumeration<TreeNode> e = remote.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Command command = (Command)node.getUserObject();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public TreeImporter() {
        this((GuiUtils)null, false);
    }

    public TreeImporter(GuiUtils guiUtils) {
        this(guiUtils, false);
    }

    public TreeImporter(GuiUtils guiUtils, boolean restrictedMode) {
        this.guiUtils = guiUtils;
        this.restrictedMode = restrictedMode;
        this.initComponents();
        this.tree.setCellRenderer(new MyRenderer());
        this.tree.addTreeExpansionListener(this);
        if (restrictedMode) {
            this.tree.setComponentPopupMenu(null);
            this.tree.setToolTipText(null);
        }
    }

    public void setRemoteSet(RemoteSet remoteSet) {
        if (remoteSet == null || remoteSet.getRemotes().isEmpty()) {
            this.guiUtils.error("No remotes in import, aborting.");
            this.clear();
            return;
        }
        this.remoteSet = remoteSet;
        DefaultTreeModel treeModel = this.newTreeModel();
        this.tree.setModel(treeModel);
        this.tree.expandRow(1);
        this.enableStuff(true);
    }

    public void clear() {
        this.remoteSet = null;
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Remotes not yet loaded"));
        this.tree.setModel(treeModel);
        this.enableStuff(false);
    }

    private void enableStuff(boolean value) {
        boolean val = value && !this.restrictedMode;
        this.importAllButton.setEnabled(val && this.enableImportAll());
        this.importSelectionButton.setEnabled(val);
        this.transmitSelectedButton.setEnabled(val);
        this.importSignalButton.setEnabled(val);
        this.importSelectionRawButton.setEnabled(val);
        this.importAllRawButton.setEnabled(val && this.enableImportAll());
        this.scrutinizeSignalMenuItem.setEnabled(val);
        this.printSignalMenuItem.setEnabled(val);
        this.importAllMenuItem.setEnabled(val && this.enableImportAll());
        this.importSelectionMenuItem.setEnabled(val);
        this.transmitSignalMenuItem.setEnabled(val);
        this.importSelectionRawMenuItem.setEnabled(val && this.enableImportAll());
        this.importAllRawMenuItem.setEnabled(val);
    }

    private boolean enableImportAll() {
        return this.remoteSet == null || this.remoteSet.getRemotes().size() <= 10;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEditable(enabled);
    }

    private DefaultTreeModel newTreeModel() {
        this.root = new DefaultMutableTreeNode("Remotes");
        Collection<Remote> remotes = this.remoteSet.getRemotes();
        ArrayList<Remote> remoteList = new ArrayList<Remote>(remotes);
        Collections.sort(remoteList, new Remote.CompareNameCaseInsensitive());
        for (Remote remote : remoteList) {
            DefaultMutableTreeNode node = this.newRemoteNode(remote);
            this.root.add(node);
        }
        return new DefaultTreeModel(this.root);
    }

    private DefaultMutableTreeNode newRemoteNode(Remote remote) {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode(remote);
        for (Map.Entry<String, Command> kvp : remote.getCommands().entrySet()) {
            DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(kvp.getValue());
            n.add(leaf);
        }
        return n;
    }

    private int importSelectedSignals(boolean raw) throws IrpMasterException {
        int count = 0;
        TreePath[] paths = this.tree.getSelectionPaths();
        this.checkGuiMain();
        for (TreePath path : paths) {
            Object thing = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (Remote.class.isInstance(thing)) {
                this.guiMain.importCommands(((Remote)thing).getCommands().values(), raw);
                count += ((Remote)thing).getCommands().size();
                continue;
            }
            if (Command.class.isInstance(thing)) {
                this.guiMain.importCommand((Command)thing, raw);
                ++count;
                continue;
            }
            this.guiUtils.error("This cannot happen: " + thing.getClass().getCanonicalName());
        }
        return count;
    }

    private void importJump(int count, ImportType type) {
        boolean doJump = this.guiUtils.confirm("Import was successful with " + count + " signal(s). Jump to panel?");
        if (doJump) {
            this.guiMain.selectImportPane(type);
        }
    }

    private Command getSingleCommand() {
        if (this.tree.getSelectionCount() != 1) {
            this.guiUtils.error("Exactly one command has to be selected for this command.");
            return null;
        }
        TreePath path = this.tree.getSelectionPaths()[0];
        Object thing = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (!Command.class.isInstance(thing)) {
            this.guiUtils.error("A command (not remote) has to be selected for this command.");
            return null;
        }
        Command command = (Command)thing;
        return command;
    }

    private void checkGuiMain() {
        if (this.guiMain == null) {
            Container component = this.getRootPane().getParent();
            assert (component instanceof GuiMain);
            this.guiMain = (GuiMain)component;
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.scrutinizeSignalMenuItem = new JMenuItem();
        this.printSignalMenuItem = new JMenuItem();
        this.transmitSignalMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.importAllMenuItem = new JMenuItem();
        this.importSelectionMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.importAllRawMenuItem = new JMenuItem();
        this.importSelectionRawMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.importSignalButton = new JButton();
        this.importAllButton = new JButton();
        this.importSelectionButton = new JButton();
        this.transmitSelectedButton = new JButton();
        this.importAllRawButton = new JButton();
        this.importSelectionRawButton = new JButton();
        this.scrutinizeSignalMenuItem.setMnemonic('S');
        this.scrutinizeSignalMenuItem.setText("Scrutinize Selected");
        this.scrutinizeSignalMenuItem.setToolTipText("Transfer selected signal to Scrutinize Signal pane.");
        this.scrutinizeSignalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.scrutinizeSignalMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.scrutinizeSignalMenuItem);
        this.printSignalMenuItem.setMnemonic('P');
        this.printSignalMenuItem.setText("Print selected");
        this.printSignalMenuItem.setToolTipText("Print selected signal to console.");
        this.printSignalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.printSignalMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.printSignalMenuItem);
        this.transmitSignalMenuItem.setMnemonic('T');
        this.transmitSignalMenuItem.setText("Transmit selected");
        this.transmitSignalMenuItem.setToolTipText("Send the single selected signal with selected hardware.");
        this.transmitSignalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.transmitSignalMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.transmitSignalMenuItem);
        this.popupMenu.add(this.jSeparator1);
        this.importAllMenuItem.setMnemonic('A');
        this.importAllMenuItem.setText("Import all");
        this.importAllMenuItem.setToolTipText("Transfer all commands to either the raw or the parametrized remote.");
        this.importAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importAllMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.importAllMenuItem);
        this.importSelectionMenuItem.setMnemonic('L');
        this.importSelectionMenuItem.setText("Import selection");
        this.importSelectionMenuItem.setToolTipText("Transfers selected signals to raw or parametric remote.");
        this.importSelectionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importSelectionMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.importSelectionMenuItem);
        this.popupMenu.add(this.jSeparator2);
        this.importAllRawMenuItem.setText("Import all as raw");
        this.importAllRawMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importAllRawMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.importAllRawMenuItem);
        this.importSelectionRawMenuItem.setText("Import selection as raw");
        this.importSelectionRawMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importSelectionRawMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.importSelectionRawMenuItem);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Remotes not yet loaded");
        this.tree.setModel(new DefaultTreeModel(treeNode1));
        this.tree.setToolTipText("Select with left, right for popup menu.");
        this.tree.setComponentPopupMenu(this.popupMenu);
        this.jScrollPane1.setViewportView(this.tree);
        this.importSignalButton.setMnemonic('S');
        this.importSignalButton.setText("Import signal");
        this.importSignalButton.setToolTipText("Transfers the (single!) selected signal to \"Scrutinize signal\"");
        this.importSignalButton.setEnabled(false);
        this.importSignalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importSignalButtonActionPerformed(evt);
            }
        });
        this.importAllButton.setMnemonic('A');
        this.importAllButton.setText("Import all");
        this.importAllButton.setToolTipText("Transfers all signals to either the raw or the parametric remote");
        this.importAllButton.setEnabled(false);
        this.importAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importAllButtonActionPerformed(evt);
            }
        });
        this.importSelectionButton.setMnemonic('L');
        this.importSelectionButton.setText("Import selection");
        this.importSelectionButton.setToolTipText("Transfers the selected (remotes or commands) to either the raw or the parametrized remote.");
        this.importSelectionButton.setEnabled(false);
        this.importSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importSelectionButtonActionPerformed(evt);
            }
        });
        this.transmitSelectedButton.setMnemonic('T');
        this.transmitSelectedButton.setText("Transmit selected");
        this.transmitSelectedButton.setToolTipText("Send the single selected signal with selected hardware.");
        this.transmitSelectedButton.setEnabled(false);
        this.transmitSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.transmitSelectedButtonActionPerformed(evt);
            }
        });
        this.importAllRawButton.setText("Import all/raw");
        this.importAllRawButton.setEnabled(false);
        this.importAllRawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importAllRawButtonActionPerformed(evt);
            }
        });
        this.importSelectionRawButton.setText("Import select./raw");
        this.importSelectionRawButton.setEnabled(false);
        this.importSelectionRawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeImporter.this.importSelectionRawButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.importSignalButton, GroupLayout.Alignment.TRAILING).addComponent(this.importAllButton, GroupLayout.Alignment.TRAILING).addComponent(this.importSelectionButton, GroupLayout.Alignment.TRAILING)).addComponent(this.transmitSelectedButton).addComponent(this.importAllRawButton).addComponent(this.importSelectionRawButton)).addGap(6, 6, 6)));
        layout.linkSize(0, this.importAllButton, this.importAllRawButton, this.importSelectionButton, this.importSelectionRawButton, this.importSignalButton, this.transmitSelectedButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.importSignalButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importSelectionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importAllRawButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importSelectionRawButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 73, Short.MAX_VALUE).addComponent(this.transmitSelectedButton)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addGap(5, 5, 5)));
    }

    private void printSignalMenuItemActionPerformed(ActionEvent evt) {
        Command command = this.getSingleCommand();
        if (command == null) {
            return;
        }
        try {
            this.guiUtils.message(command.toPrintString());
        }
        catch (IrpMasterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void importSignalButtonActionPerformed(ActionEvent evt) {
        Command command = this.getSingleCommand();
        if (command == null) {
            return;
        }
        this.checkGuiMain();
        try {
            this.guiMain.scrutinizeIrSignal(command.toIrSignal());
            this.importJump(1, ImportType.signal);
        }
        catch (IrpMasterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void importAllButtonActionPerformed(ActionEvent evt) {
        this.checkGuiMain();
        int result = this.guiMain.importCommands(this.remoteSet.getAllCommands(), false);
        if (result > 0) {
            this.importJump(result, ImportType.parametricRemote);
        } else {
            this.guiUtils.error("Import failed after importing " + Integer.toString(-result) + " signal(s)");
        }
    }

    private void importSelectionButtonActionPerformed(ActionEvent evt) {
        try {
            int count = this.importSelectedSignals(false);
            this.importJump(count, ImportType.parametricRemote);
        }
        catch (IrpMasterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void importAllMenuItemActionPerformed(ActionEvent evt) {
        this.importAllButtonActionPerformed(evt);
    }

    private void importSelectionMenuItemActionPerformed(ActionEvent evt) {
        this.importSelectionButtonActionPerformed(evt);
    }

    private void transmitSelectedButtonActionPerformed(ActionEvent evt) {
        Command command = this.getSingleCommand();
        if (command == null) {
            return;
        }
        this.checkGuiMain();
        try {
            this.guiMain.transmit(command);
        }
        catch (IOException | IrpMasterException | HardwareUnavailableException ex) {
            this.guiUtils.error(ex);
        }
        catch (NoSuchTransmitterException ex) {
            this.guiUtils.error(ex);
        }
        catch (HarcHardwareException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void transmitSignalMenuItemActionPerformed(ActionEvent evt) {
        this.transmitSelectedButtonActionPerformed(evt);
    }

    private void importAllRawButtonActionPerformed(ActionEvent evt) {
        this.checkGuiMain();
        int result = this.guiMain.importCommands(this.remoteSet.getAllCommands(), true);
        if (result > 0) {
            this.importJump(result, ImportType.rawRemote);
        } else {
            this.guiUtils.error("Import failed after importing " + Integer.toString(-result) + " signals");
        }
    }

    private void importSelectionRawButtonActionPerformed(ActionEvent evt) {
        try {
            int count = this.importSelectedSignals(true);
            this.importJump(count, ImportType.rawRemote);
        }
        catch (IrpMasterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void importAllRawMenuItemActionPerformed(ActionEvent evt) {
        this.importAllRawButtonActionPerformed(evt);
    }

    private void importSelectionRawMenuItemActionPerformed(ActionEvent evt) {
        this.importSelectionRawButtonActionPerformed(evt);
    }

    private void scrutinizeSignalMenuItemActionPerformed(ActionEvent evt) {
        Command command = this.getSingleCommand();
        if (command == null) {
            return;
        }
        this.checkGuiMain();
        try {
            this.guiMain.scrutinizeIrSignal(command.toIrSignal());
        }
        catch (IrpMasterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private static class MyRenderer
    extends DefaultTreeCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object thing = ((DefaultMutableTreeNode)value).getUserObject();
            String name = Command.class.isInstance(thing) ? ((Command)thing).getName() : (Remote.class.isInstance(thing) ? ((Remote)thing).getName() : thing.toString());
            super.getTreeCellRendererComponent(tree, name, sel, expanded, leaf, row, hasFocus);
            if (Command.class.isInstance(thing)) {
                Command command = (Command)thing;
                this.setToolTipText(command.prettyValueString());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

