/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Wave;
import org.harctoolbox.irscrutinizer.importer.FileImporter;
import org.harctoolbox.irscrutinizer.importer.IFileImporter;
import org.harctoolbox.irscrutinizer.importer.IModulatedIrSequenceImporter;

public class WaveImporter
extends FileImporter
implements IModulatedIrSequenceImporter,
IFileImporter {
    private boolean divideCarrier;
    private ModulatedIrSequence sequence;

    public WaveImporter(boolean divideCarrier) {
        this.divideCarrier = divideCarrier;
    }

    public void setDivideCarrier(boolean divideCarrier) {
        this.divideCarrier = divideCarrier;
    }

    @Override
    public void load(File file, String origin, String charsetName) throws IOException {
        try {
            Wave wave = new Wave(file);
            this.sequence = wave.analyze(this.divideCarrier);
        }
        catch (UnsupportedAudioFileException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void load(File file) throws IOException, ParseException {
        this.load(file, "US-ASCII");
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Wave files (*.wav *.wave)", "wave", "wav"}};
    }

    @Override
    public String getFormatName() {
        return "Wave";
    }

    @Override
    public ModulatedIrSequence getModulatedIrSequence() {
        return this.sequence;
    }
}

