/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.importer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.irscrutinizer.importer.IReaderImporter;
import org.harctoolbox.irscrutinizer.importer.ProntoIrCode;
import org.harctoolbox.irscrutinizer.importer.RemoteSetImporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XcfImporter
extends RemoteSetImporter
implements IReaderImporter {
    private static final String xcfXmlFileName = "ConfigEdit.xml";
    private static final String defaultCharsetName = "WINDOWS-1252";
    private boolean translateProntoFont = true;
    private HashMap<String, String> nameIndex;
    private HashMap<String, Element> pageIndex;
    private HashMap<String, Element> actionListIndex;
    private HashMap<String, Element> moduleIndex;
    private HashMap<String, Element> actionIndex;
    private int learnedIrCodeIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document openConfig(File filename) throws SAXException, IOException {
        Document doc = null;
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(filename);
            ZipEntry entry = zipFile.getEntry(xcfXmlFileName);
            if (entry == null) {
                entry = zipFile.getEntry("/ConfigEdit.xml");
            }
            InputStream stream = zipFile.getInputStream(entry);
            doc = XmlUtils.openXmlStream(stream, null, false, false);
        }
        return doc;
    }

    private static HashMap<String, Element> mkIndex(Element element, String tagId) {
        LinkedHashMap<String, Element> index = new LinkedHashMap<String, Element>(16);
        NodeList things = element.getElementsByTagName(tagId);
        int length = things.getLength();
        for (int i = 0; i < length; ++i) {
            Element thing = (Element)things.item(i);
            index.put(thing.getAttribute("id"), thing);
        }
        return index;
    }

    public static RemoteSet importXcf(String filename) throws IOException, SAXException, ParseException, IrpMasterException {
        XcfImporter importer = new XcfImporter();
        importer.load(new File(filename), defaultCharsetName);
        return importer.getRemoteSet();
    }

    public static void main(String[] args) {
        try {
            RemoteSet buttons = XcfImporter.importXcf(args[0]);
            for (Remote button : buttons.getRemotes()) {
                System.out.println(button.toString());
            }
        }
        catch (SAXException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException | ParseException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void setTranslateProntoFont(boolean translateProntoFont) {
        this.translateProntoFont = translateProntoFont;
    }

    @Override
    public void load(File filename, String origin, String charsetName) throws IOException, ParseException {
        this.prepareLoad(origin);
        try {
            this.load(XcfImporter.openConfig(filename));
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private String transmogrify(String s) {
        return s.isEmpty() ? "empty_" + this.learnedIrCodeIndex++ : (s.equals("Learned IR Code") || s.equals("Learnt IR Code") ? s + "_" + this.learnedIrCodeIndex++ : s);
    }

    private void load(Document doc) throws ParseException {
        Element element;
        int i;
        this.learnedIrCodeIndex = 1;
        this.nameIndex = null;
        this.pageIndex = null;
        this.actionListIndex = null;
        this.moduleIndex = null;
        this.actionIndex = null;
        Element root = doc.getDocumentElement();
        NodeList topThings = root.getChildNodes();
        for (i = 0; i < topThings.getLength(); ++i) {
            if (topThings.item(i).getNodeType() != 1 || !(element = (Element)topThings.item(i)).getTagName().equals("Strings")) continue;
            this.setupNamesIndex(element);
        }
        block13: for (i = 0; i < topThings.getLength(); ++i) {
            if (topThings.item(i).getNodeType() != 1) continue;
            element = (Element)topThings.item(i);
            switch (element.getTagName()) {
                case "Actions": {
                    this.setupActionIndex(element);
                    continue block13;
                }
                case "Pages": {
                    this.pageIndex = XcfImporter.mkIndex(element, "PAGE");
                    continue block13;
                }
                case "ActionLists": {
                    this.actionListIndex = XcfImporter.mkIndex(element, "ACTIONLIST");
                    continue block13;
                }
                case "Modules": {
                    this.moduleIndex = XcfImporter.mkIndex(element, "MODULE");
                    continue block13;
                }
            }
        }
        if (this.moduleIndex == null) {
            throw new ParseException("No Modules element present.", -1);
        }
        HashMap<String, Remote> remotes = new HashMap<String, Remote>(16);
        for (Element module : this.moduleIndex.values()) {
            Remote remote = this.loadModule(module);
            if (remote.getCommands().isEmpty()) continue;
            remotes.put(remote.getName(), remote);
        }
        this.remoteSet = new RemoteSet(this.getCreatingUser(), this.origin, new Date().toString(), "IrScrutinizer", "1.3", null, null, null, remotes);
    }

    private Remote loadModule(Element module) {
        Element page;
        NodeList names = module.getElementsByTagName("Name");
        String nameId = ((Element)names.item(0)).getAttribute("id");
        String name = this.nameIndex.get(nameId);
        HashMap<String, Command> cmds = new HashMap<String, Command>(32);
        NodeList firstPages = module.getElementsByTagName("FirstPage");
        Element element = page = firstPages.getLength() > 0 ? this.pageIndex.get(((Element)firstPages.item(0)).getAttribute("id")) : null;
        while (page != null) {
            cmds.putAll(this.loadPage(page));
            NodeList nextpages = page.getElementsByTagName("Next");
            page = nextpages.getLength() > 0 ? this.pageIndex.get(((Element)nextpages.item(0)).getAttribute("id")) : null;
        }
        Remote remote = new Remote(new Remote.MetaData(name), null, null, cmds, null);
        return remote;
    }

    private HashMap<String, Command> loadPage(Element page) {
        HashMap<String, Command> cmds = new HashMap<String, Command>(16);
        NodeList items = page.getElementsByTagName("Item");
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            Command command = this.loadItem(item);
            if (command == null) continue;
            cmds.put(command.getName(), command);
        }
        return cmds;
    }

    private Command loadItem(Element item) {
        Element actionList = this.actionListIndex.get(item.getAttribute("id"));
        NodeList actions = actionList.getElementsByTagName("Action");
        if (actions.getLength() == 0) {
            return null;
        }
        Element action = this.actionIndex.get(((Element)actions.item(0)).getAttribute("id"));
        String ccf = this.actionCodeCcf(action);
        if (ccf == null || ccf.isEmpty()) {
            return null;
        }
        try {
            return new Command(this.actionCodeName(action), null, ccf);
        }
        catch (IrpMasterException ex) {
            return null;
        }
    }

    private String actionCodeCcf(Element action) {
        NodeList nl = action.getElementsByTagName("BASICIRCODE");
        if (nl.getLength() == 0) {
            return null;
        }
        if ((nl = ((Element)nl.item(0)).getElementsByTagName("Code")).getLength() == 0) {
            return null;
        }
        String ccf = nl.item(0).getTextContent();
        return ccf;
    }

    private String actionCodeName(Element action) {
        NodeList nl = action.getElementsByTagName("BASICIRCODE");
        if (nl.getLength() == 0) {
            return null;
        }
        if ((nl = ((Element)nl.item(0)).getElementsByTagName("Name")).getLength() == 0) {
            return null;
        }
        return this.nameIndex.get(((Element)nl.item(0)).getAttribute("id"));
    }

    private void setupNamesIndex(Element element) {
        this.nameIndex = new HashMap(32);
        NodeList nl = element.getElementsByTagName("STRING");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            NodeList vals = e.getElementsByTagName("Value");
            if (vals.getLength() <= 0) continue;
            this.nameIndex.put(e.getAttribute("id"), this.transmogrify(vals.item(0).getTextContent()));
        }
    }

    private void setupActionIndex(Element element) {
        this.actionIndex = XcfImporter.mkIndex(element, "ACTION");
        for (Element action : this.actionIndex.values()) {
            NodeList basicIrCodes = action.getElementsByTagName("BASICIRCODE");
            if (basicIrCodes.getLength() == 0) continue;
            Element basicIrCode = (Element)basicIrCodes.item(0);
            String name = this.nameIndex.get(((Element)basicIrCode.getElementsByTagName("Name").item(0)).getAttribute("id"));
            Element codeElement = (Element)basicIrCode.getElementsByTagName("Code").item(0);
            String ccf = codeElement.getTextContent();
            if (ccf.isEmpty()) continue;
            try {
                Command raw = new Command(this.translateProntoFont ? ProntoIrCode.translateProntoFont(name) : name, null, ccf);
                this.addCommand(raw);
            }
            catch (IrpMasterException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    @Override
    public boolean canImportDirectories() {
        return false;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{"Pronto professional files (*.xcf)", "xcf"}};
    }

    @Override
    public void load(Reader reader, String originName) throws IOException, FileNotFoundException, ParseException {
        this.dumbLoad(reader, originName, defaultCharsetName);
    }

    @Override
    public String getFormatName() {
        return "Pronto Professional";
    }
}

