/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.SerialPortBean;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.LocalSerialPort;

public class GenericSerialSenderBean
extends JPanel {
    private String portName;
    private int baud;
    private int dataSize;
    private LocalSerialPort.FlowControl flowControl;
    private LocalSerialPort.Parity parity;
    private int stopBits;
    private String command;
    private boolean raw;
    private boolean useSigns;
    private String separator;
    private String lineEnding;
    private GuiUtils guiUtils;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROP_PORTNAME = "PROP_PORTNAME";
    public static final String PROP_BAUDRATE = "PROP_BAUDRATE";
    public static final String PROP_DATASIZE = "PROP_DATASIZE";
    public static final String PROP_FLOWCONTROL = "PROP_FLOWCONTROL";
    public static final String PROP_PARITY = "PROP_PARITY";
    public static final String PROP_STOPBITS = "PROP_STOPBITS";
    public static final String PROP_COMMAND = "PROP_COMMAND";
    public static final String PROP_RAW = "PROP_RAW";
    public static final String PROP_USESIGNS = "PROP_USESIGNS";
    public static final String PROP_SEPARATOR = "PROP_SEPARATOR";
    public static final String PROP_LINEENDING = "PROP_LINEENDING";
    public static final String PROP_SERIALCOMMANDTEXTFIELD = "PROP_SERIALCOMMANDTEXTFIELD";
    private JLabel formatLabel;
    private JLabel jLabel1;
    private JLabel jLabel23;
    private JLabel jLabel5;
    private JLabel separatorLabel;
    private JTextField serialCommandTextField;
    private JComboBox<String> serialFormatComboBox;
    private JComboBox<String> serialLineEndingsComboBox;
    private SerialPortBean serialPortBean;
    private JComboBox<String> serialRawSeparatorComboBox;
    private JComboBox<String> serialSignedComboBox;

    public GenericSerialSenderBean(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
        this.initComponents();
        this.serialCommandTextFieldActionPerformed(null);
        this.serialSignedComboBoxActionPerformed(null);
        this.serialFormatComboBoxActionPerformed(null);
        this.serialRawSeparatorComboBoxActionPerformed(null);
        this.serialLineEndingsComboBoxActionPerformed(null);
        this.setPortName(this.serialPortBean.getPortName());
        this.setBaud(this.serialPortBean.getBaud());
        this.setDataSize(this.serialPortBean.getDataSize());
        this.setFlowControl(this.serialPortBean.getFlowControl());
        this.setParity(this.serialPortBean.getParity());
        this.setStopBits(this.serialPortBean.getStopBits());
        this.serialPortBean.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "PROP_PORTNAME": {
                        GenericSerialSenderBean.this.setPortName((String)evt.getNewValue());
                        break;
                    }
                    case "PROP_BAUD": {
                        GenericSerialSenderBean.this.setBaud((Integer)evt.getNewValue());
                        break;
                    }
                    case "PROP_DATASIZE": {
                        GenericSerialSenderBean.this.setDataSize((Integer)evt.getNewValue());
                        break;
                    }
                    case "PROP_FLOWCONTROL": {
                        GenericSerialSenderBean.this.setFlowControl((LocalSerialPort.FlowControl)((Object)evt.getNewValue()));
                        break;
                    }
                    case "PROP_PARITY": {
                        GenericSerialSenderBean.this.setParity((LocalSerialPort.Parity)((Object)evt.getNewValue()));
                        break;
                    }
                    case "PROP_STOPBITS": {
                        GenericSerialSenderBean.this.setStopBits((Integer)evt.getNewValue());
                        break;
                    }
                    default: {
                        throw new RuntimeException("This cannot happen");
                    }
                }
            }
        });
    }

    public GenericSerialSenderBean() {
        this((GuiUtils)null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getPortName() {
        return this.portName;
    }

    public final void setPortName(String portName) {
        String oldPortName = this.portName;
        this.portName = portName;
        this.propertyChangeSupport.firePropertyChange(PROP_PORTNAME, oldPortName, portName);
    }

    public int getBaud() {
        return this.baud;
    }

    public final void setBaud(int baud) {
        int oldBaud = this.baud;
        this.baud = baud;
        this.propertyChangeSupport.firePropertyChange(PROP_BAUDRATE, oldBaud, baud);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public final void setDataSize(int dataSize) {
        int oldDataSize = this.dataSize;
        this.dataSize = dataSize;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASIZE, oldDataSize, dataSize);
    }

    public LocalSerialPort.FlowControl getFlowControl() {
        return this.flowControl;
    }

    public final void setFlowControl(LocalSerialPort.FlowControl flowControl) {
        LocalSerialPort.FlowControl oldFlowControl = this.flowControl;
        this.flowControl = flowControl;
        this.propertyChangeSupport.firePropertyChange(PROP_FLOWCONTROL, (Object)oldFlowControl, (Object)flowControl);
    }

    public LocalSerialPort.Parity getParity() {
        return this.parity;
    }

    public final void setParity(LocalSerialPort.Parity parity) {
        LocalSerialPort.Parity oldParity = this.parity;
        this.parity = parity;
        this.propertyChangeSupport.firePropertyChange(PROP_PARITY, (Object)oldParity, (Object)parity);
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public final void setStopBits(int stopBits) {
        int oldStopBits = this.stopBits;
        this.stopBits = stopBits;
        this.propertyChangeSupport.firePropertyChange(PROP_STOPBITS, oldStopBits, stopBits);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        String oldCommand = this.command;
        this.command = command;
        this.propertyChangeSupport.firePropertyChange(PROP_COMMAND, oldCommand, command);
    }

    public boolean getRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        boolean oldRaw = this.raw;
        this.raw = raw;
        this.separatorLabel.setEnabled(raw);
        this.serialRawSeparatorComboBox.setEnabled(raw);
        this.serialSignedComboBox.setEnabled(raw);
        this.propertyChangeSupport.firePropertyChange(PROP_RAW, oldRaw, raw);
    }

    public boolean getUseSigns() {
        return this.useSigns;
    }

    public void setUseSigns(boolean useSigns) {
        boolean oldUseSigns = this.useSigns;
        this.useSigns = useSigns;
        this.propertyChangeSupport.firePropertyChange(PROP_USESIGNS, oldUseSigns, useSigns);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        String oldSeparator = this.separator;
        this.separator = separator;
        this.propertyChangeSupport.firePropertyChange(PROP_SEPARATOR, oldSeparator, separator);
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(String lineEnding) {
        String oldLineEnding = this.lineEnding;
        this.lineEnding = lineEnding;
        this.propertyChangeSupport.firePropertyChange(PROP_LINEENDING, oldLineEnding, lineEnding);
    }

    public void setHardware(IHarcHardware hardware) {
        this.serialPortBean.setHardware(hardware);
    }

    public void setup(String desiredPort) throws IOException {
        this.serialPortBean.setup(desiredPort);
        this.setPortName(this.serialPortBean.getPortName());
    }

    private void initComponents() {
        this.serialPortBean = new SerialPortBean(this.guiUtils);
        this.jLabel5 = new JLabel();
        this.formatLabel = new JLabel();
        this.serialCommandTextField = new JTextField();
        this.serialFormatComboBox = new JComboBox();
        this.separatorLabel = new JLabel();
        this.serialRawSeparatorComboBox = new JComboBox();
        this.jLabel23 = new JLabel();
        this.serialLineEndingsComboBox = new JComboBox();
        this.serialSignedComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel5.setText("Command");
        this.formatLabel.setText("Format");
        this.serialCommandTextField.setText("SEND");
        this.serialCommandTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericSerialSenderBean.this.serialCommandTextFieldActionPerformed(evt);
            }
        });
        this.serialFormatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"CCF", "RAW"}));
        this.serialFormatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericSerialSenderBean.this.serialFormatComboBoxActionPerformed(evt);
            }
        });
        this.separatorLabel.setText("Separator");
        this.separatorLabel.setEnabled(false);
        this.serialRawSeparatorComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", ",", ";"}));
        this.serialRawSeparatorComboBox.setEnabled(false);
        this.serialRawSeparatorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericSerialSenderBean.this.serialRawSeparatorComboBoxActionPerformed(evt);
            }
        });
        this.jLabel23.setText("Line endings");
        this.serialLineEndingsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"LF", "CR/LF", "CR"}));
        this.serialLineEndingsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericSerialSenderBean.this.serialLineEndingsComboBoxActionPerformed(evt);
            }
        });
        this.serialSignedComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Unsigned", "Signed"}));
        this.serialSignedComboBox.setEnabled(false);
        this.serialSignedComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenericSerialSenderBean.this.serialSignedComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Number format");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serialPortBean, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.serialCommandTextField, -2, 150, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serialFormatComboBox, -2, 112, -2).addComponent(this.formatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serialRawSeparatorComboBox, -2, -1, -2).addComponent(this.separatorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addComponent(this.serialLineEndingsComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.serialSignedComboBox, -2, -1, -2)))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serialPortBean, -2, -1, -2).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel23).addComponent(this.jLabel1).addComponent(this.separatorLabel))).addComponent(this.formatLabel, GroupLayout.Alignment.TRAILING)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serialCommandTextField, -2, -1, -2).addComponent(this.serialFormatComboBox, -2, -1, -2).addComponent(this.serialRawSeparatorComboBox, -2, -1, -2).addComponent(this.serialLineEndingsComboBox, -2, -1, -2).addComponent(this.serialSignedComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void serialCommandTextFieldActionPerformed(ActionEvent evt) {
        this.setCommand(this.serialCommandTextField.getText());
    }

    private void serialSignedComboBoxActionPerformed(ActionEvent evt) {
        this.setUseSigns(this.serialSignedComboBox.getSelectedIndex() != 0);
    }

    private void serialFormatComboBoxActionPerformed(ActionEvent evt) {
        this.setRaw(this.serialFormatComboBox.getSelectedItem().equals("RAW"));
    }

    private void serialRawSeparatorComboBoxActionPerformed(ActionEvent evt) {
        this.setSeparator((String)this.serialRawSeparatorComboBox.getSelectedItem());
    }

    private void serialLineEndingsComboBoxActionPerformed(ActionEvent evt) {
        String label = (String)this.serialLineEndingsComboBox.getSelectedItem();
        String ending = label.equals("LF") ? "\n" : (label.equals("CR") ? "\r" : "\r\n");
        this.setLineEnding(ending);
    }
}

