/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.devslashlirc.LircDeviceException;
import org.harctoolbox.guicomponents.DevLircBean;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.ir.DevLirc;
import org.harctoolbox.harchardware.ir.LircTransmitter;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;
import org.harctoolbox.irscrutinizer.sendinghardware.SendingHardware;

public class SendingDevLirc
extends SendingHardware<DevLirc>
implements ISendingHardware<DevLirc> {
    private DevLircBean devLircBean;
    private String portName;
    private DevLirc rawIrSender;

    public SendingDevLirc(JPanel panel, DevLircBean devLircBean, Props props, GuiUtils guiUtils_) {
        super(panel, props, guiUtils_);
        this.devLircBean = devLircBean;
        this.portName = devLircBean.getPortName();
        devLircBean.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName;
                switch (propertyName = evt.getPropertyName()) {
                    case "PROP_PROPS": {
                        break;
                    }
                    case "PROP_PORTNAME": {
                        if (evt.getNewValue() == null) {
                            return;
                        }
                        SendingDevLirc.this.setup();
                        break;
                    }
                    case "PROP_ISOPEN": {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown property " + propertyName);
                    }
                }
            }
        });
    }

    @Override
    public void setup() {
        String newPort = this.devLircBean.getPortName();
        if (newPort == null || this.rawIrSender != null && newPort.equals(this.portName)) {
            return;
        }
        if (this.rawIrSender != null) {
            this.rawIrSender.close();
        }
        this.rawIrSender = null;
        try {
            this.rawIrSender = new DevLirc(newPort, this.properties.getVerbose());
            this.rawIrSender.setBeginTimeout(this.properties.getSendingTimeout());
        }
        catch (IOException | LircDeviceException ex) {
            this.guiUtils.error(ex);
        }
        this.portName = newPort;
        this.properties.setDevLircName(newPort);
        this.devLircBean.setHardware(this.rawIrSender);
    }

    @Override
    public String getName() {
        return "/dev/lirc";
    }

    @Override
    public LircTransmitter getTransmitter() {
        return this.devLircBean.getTransmitter();
    }

    @Override
    public DevLirc getRawIrSender() {
        return this.rawIrSender;
    }
}

