/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.IrGenericSerial;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.GenericSerialSenderBean;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;
import org.harctoolbox.irscrutinizer.sendinghardware.SendingHardware;

public class SendingGenericSerialPort
extends SendingHardware<IrGenericSerial>
implements ISendingHardware<IrGenericSerial> {
    private GenericSerialSenderBean genericSerialSenderBean;
    private String initialPort;
    private String portName = null;
    private IrGenericSerial rawIrSender;

    public SendingGenericSerialPort(JPanel panel, GenericSerialSenderBean genericSerialSenderBean_, Props properties_, GuiUtils guiUtils_) {
        super(panel, properties_, guiUtils_);
        this.genericSerialSenderBean = genericSerialSenderBean_;
        this.rawIrSender = null;
        this.initialPort = this.properties.getGenericSerialPortDeviceName();
        this.genericSerialSenderBean.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "PROP_PORTNAME": {
                        SendingGenericSerialPort.this.properties.setGenericSerialPortDeviceName((String)evt.getNewValue());
                        try {
                            SendingGenericSerialPort.this.setupGenericSerialPort();
                        }
                        catch (IOException ex) {
                            SendingGenericSerialPort.this.guiUtils.error(ex);
                        }
                        break;
                    }
                    case "PROP_COMMAND": {
                        SendingGenericSerialPort.this.rawIrSender.setCommand(SendingGenericSerialPort.this.genericSerialSenderBean.getCommand());
                        break;
                    }
                    case "PROP_RAW": {
                        SendingGenericSerialPort.this.rawIrSender.setRaw(SendingGenericSerialPort.this.genericSerialSenderBean.getRaw());
                        break;
                    }
                    case "PROP_SEPARATOR": {
                        SendingGenericSerialPort.this.rawIrSender.setSeparator(SendingGenericSerialPort.this.genericSerialSenderBean.getSeparator());
                        break;
                    }
                    case "PROP_USESIGNS": {
                        SendingGenericSerialPort.this.rawIrSender.setUseSigns(SendingGenericSerialPort.this.genericSerialSenderBean.getUseSigns());
                        break;
                    }
                    case "PROP_LINEENDING": {
                        SendingGenericSerialPort.this.rawIrSender.setLineEnding(SendingGenericSerialPort.this.genericSerialSenderBean.getLineEnding());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Programming error");
                    }
                }
            }
        });
    }

    @Override
    public void setup() throws IOException, HarcHardwareException {
        this.genericSerialSenderBean.setup(this.initialPort);
        this.initialPort = null;
        this.setupGenericSerialPort();
    }

    private void setupGenericSerialPort() throws IOException {
        String newPort = this.genericSerialSenderBean.getPortName();
        if (this.rawIrSender != null && (newPort == null || newPort.equals(this.portName))) {
            return;
        }
        if (this.rawIrSender != null) {
            this.rawIrSender.close();
        }
        this.rawIrSender = null;
        this.close();
        try {
            this.rawIrSender = new IrGenericSerial(this.genericSerialSenderBean.getPortName(), this.genericSerialSenderBean.getBaud(), this.genericSerialSenderBean.getDataSize(), this.genericSerialSenderBean.getStopBits(), this.genericSerialSenderBean.getParity(), this.genericSerialSenderBean.getFlowControl(), this.properties.getSendingTimeout(), this.properties.getVerbose());
            this.rawIrSender.setCommand(this.genericSerialSenderBean.getCommand());
            this.rawIrSender.setRaw(this.genericSerialSenderBean.getRaw());
            this.rawIrSender.setSeparator(this.genericSerialSenderBean.getSeparator());
            this.rawIrSender.setUseSigns(this.genericSerialSenderBean.getUseSigns());
            this.rawIrSender.setLineEnding(this.genericSerialSenderBean.getLineEnding());
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException ex) {
            this.guiUtils.error(ex);
        }
        this.portName = this.genericSerialSenderBean.getPortName();
        this.genericSerialSenderBean.setHardware(this.rawIrSender);
    }

    @Override
    public String getName() {
        return "Generic serial port";
    }

    @Override
    public IrGenericSerial getRawIrSender() {
        return this.rawIrSender;
    }
}

