/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.guicomponents.GlobalCacheIrSenderSelector;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.GlobalCache;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;
import org.harctoolbox.irscrutinizer.HardwareUnavailableException;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;
import org.harctoolbox.irscrutinizer.sendinghardware.SendingHardware;

public class SendingGlobalCache
extends SendingHardware<GlobalCache>
implements ISendingHardware<GlobalCache> {
    private GlobalCacheIrSenderSelector globalCacheIrSenderSelector;
    private String initialIp;
    private GlobalCache rawIrSender;

    public SendingGlobalCache(JPanel panel, final Props properties, GuiUtils gui, GlobalCacheIrSenderSelector newGlobalCacheIrSenderSelector) {
        super(panel, properties, gui);
        this.initialIp = properties.getGlobalCacheIpName();
        this.globalCacheIrSenderSelector = newGlobalCacheIrSenderSelector;
        this.globalCacheIrSenderSelector.setTimeout(properties.getGlobalCacheTimeout());
        properties.addGlobalCacheTimeoutChangeListener(new Props.IPropertyChangeListener(){

            @Override
            public void propertyChange(String name, Object oldValue, Object newValue) {
                SendingGlobalCache.this.globalCacheIrSenderSelector.setTimeout((Integer)newValue);
            }
        });
        this.globalCacheIrSenderSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    SendingGlobalCache.this.setup();
                    switch (evt.getPropertyName()) {
                        case "PROP_IPNAME": {
                            SendingGlobalCache.this.rawIrSender = SendingGlobalCache.this.globalCacheIrSenderSelector.getGlobalCache();
                            properties.setGlobalCacheIpName((String)evt.getNewValue());
                            break;
                        }
                        case "PROP_MODULE": {
                            properties.setGlobalCacheModule((Integer)evt.getNewValue());
                            break;
                        }
                        case "PROP_PORT": {
                            properties.setGlobalCachePort((Integer)evt.getNewValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Programming error");
                        }
                    }
                }
                catch (IOException | HarcHardwareException ex) {
                    SendingGlobalCache.this.guiUtils.error(ex);
                }
            }
        });
    }

    @Override
    public boolean sendIr(IrSignal irSignal, int count) throws NoSuchTransmitterException, IrpMasterException, IOException, HardwareUnavailableException, HarcHardwareException {
        if (this.rawIrSender == null) {
            throw new HardwareUnavailableException("No Global Cach\u00e9 unit selected.");
        }
        return super.sendIr(irSignal, count);
    }

    @Override
    public String getName() {
        return "Global Cach\u00e9";
    }

    @Override
    public Transmitter getTransmitter() throws NoSuchTransmitterException, HardwareUnavailableException {
        try {
            return this.globalCacheIrSenderSelector.getTransmitter();
        }
        catch (NullPointerException ex) {
            throw new HardwareUnavailableException();
        }
    }

    @Override
    public void setup() throws IOException, HarcHardwareException {
        try {
            this.globalCacheIrSenderSelector.setIpName(this.initialIp);
        }
        finally {
            this.initialIp = null;
        }
        String globalCacheIp = this.globalCacheIrSenderSelector.getIpName();
        if (globalCacheIp != null) {
            this.properties.setGlobalCacheIpName(globalCacheIp);
        }
        this.rawIrSender = this.globalCacheIrSenderSelector.getGlobalCache();
    }

    @Override
    public GlobalCache getRawIrSender() {
        return this.rawIrSender;
    }
}

