/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;
import org.harctoolbox.irscrutinizer.HardwareUnavailableException;
import org.harctoolbox.irscrutinizer.Props;

public abstract class SendingHardware<T extends IRawIrSender & IHarcHardware> {
    public static final String PROP_PANEL = "PROP_PANEL";
    public static final String PROP_RAWIRSENDER = "PROP_RAWIRSENDER";
    public static final String PROP_VERBOSE = "PROP_VERBOSE";
    private final JPanel panel;
    protected Props properties;
    protected GuiUtils guiUtils;

    protected SendingHardware(JPanel panel, Props properties, GuiUtils guiUtils) {
        this.panel = panel;
        this.properties = properties;
        this.guiUtils = guiUtils;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public abstract T getRawIrSender();

    public void setVerbosity(boolean verbose) {
        if (this.getRawIrSender() != null) {
            ((IHarcHardware)this.getRawIrSender()).setVerbosity(verbose);
        }
    }

    public Transmitter getTransmitter() throws NoSuchTransmitterException, HardwareUnavailableException {
        return null;
    }

    public boolean sendIr(IrSignal irSignal, int count) throws NoSuchTransmitterException, IrpMasterException, IOException, HardwareUnavailableException, HarcHardwareException {
        if (this.getRawIrSender() == null) {
            throw new HardwareUnavailableException("Internal error: rawIrSender == null");
        }
        if (!((IHarcHardware)this.getRawIrSender()).isValid()) {
            throw new HardwareUnavailableException();
        }
        return this.getRawIrSender().sendIr(irSignal, count, this.getTransmitter());
    }

    public void close() {
        if (this.getRawIrSender() != null) {
            try {
                ((Closeable)this.getRawIrSender()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isValid() {
        return this.getRawIrSender() != null && ((IHarcHardware)this.getRawIrSender()).isValid();
    }

    public abstract void setup() throws IOException, HarcHardwareException;

    public abstract String getName();
}

