/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.irscrutinizer.HardwareUnavailableException;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;

public class SendingHardwareManager {
    private final LinkedHashMap<String, ISendingHardware<?>> table;
    private final JTabbedPane tabbedPane;
    private JMenu menu = null;
    private ButtonGroup buttonGroup;
    private final GuiUtils guiUtils;
    private final Props properties;
    private ISendingHardware<?> selected = null;

    public SendingHardwareManager(GuiUtils guiUtils, Props properties, JTabbedPane tabbedPane) {
        this.guiUtils = guiUtils;
        this.properties = properties;
        this.tabbedPane = tabbedPane;
        this.table = new LinkedHashMap(16);
    }

    public Collection<ISendingHardware<?>> getSendingHardware() {
        return this.table.values();
    }

    public void add(ISendingHardware<?> sender) {
        if (this.table.containsKey(sender.getName())) {
            throw new IllegalArgumentException(sender.getName() + " already exists in map.");
        }
        this.table.put(sender.getName(), sender);
    }

    public String[] getNames() {
        return this.table.keySet().toArray(new String[this.table.size()]);
    }

    public ISendingHardware<?> getSendingHardware(String name) {
        return this.table.get(name);
    }

    public String getSelectedHardwareName() {
        return this.selected.getName();
    }

    public void setVerbosity(boolean verbose) {
        this.selected.setVerbosity(verbose);
    }

    public boolean sendIr(IrSignal irSignal, int count) throws IOException, IrpMasterException, NoSuchTransmitterException, HardwareUnavailableException, HarcHardwareException {
        if (this.selected == null) {
            throw new HardwareUnavailableException("No transitting hardware selected.");
        }
        return this.selected.sendIr(irSignal, count);
    }

    private void createMenu(String selection) {
        this.menu = new JMenu();
        this.menu.setText("Transmitting Hardware");
        this.menu.setToolTipText("Allows direct selection of transmitting hardware");
        this.buttonGroup = new ButtonGroup();
        for (Map.Entry<String, ISendingHardware<?>> kvp : this.table.entrySet()) {
            String name = kvp.getKey();
            final ISendingHardware<?> hardware = kvp.getValue();
            JRadioButton menuItem = new JRadioButton(name);
            menuItem.setSelected(name.equals(selection));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SendingHardwareManager.this.select(hardware);
                    }
                    catch (HarcHardwareException ex) {
                        SendingHardwareManager.this.guiUtils.error(ex);
                    }
                }
            });
            this.buttonGroup.add(menuItem);
            this.menu.add(menuItem);
        }
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.createMenu(this.selected != null ? this.selected.getName() : null);
        }
        return this.menu;
    }

    public void select(String name) throws HarcHardwareException {
        ISendingHardware<?> hardware = this.table.get(name);
        if (hardware == null) {
            return;
        }
        this.select(hardware);
    }

    private void select(ISendingHardware<?> hardware) throws HarcHardwareException {
        this.tabbedPane.setSelectedComponent(hardware.getPanel());
        if (this.selected == null) {
            this.selectDoWork(hardware);
        }
    }

    public void selectDoWork(String name) throws HarcHardwareException {
        ISendingHardware<?> hardware = this.table.get(name);
        if (hardware == null) {
            return;
        }
        this.selectDoWork(hardware);
    }

    private void selectDoWork(ISendingHardware<?> hardware) throws HarcHardwareException {
        this.selected = null;
        try {
            hardware.setup();
            hardware.setVerbosity(this.properties.getVerbose());
            this.selected = hardware;
            this.properties.setTransmitHardware(hardware.getName());
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
        if (this.menu != null) {
            for (Component component : this.menu.getMenuComponents()) {
                JRadioButton menuItem = (JRadioButton)component;
                menuItem.setSelected(menuItem.getText().equals(hardware.getName()));
            }
        }
    }

    public void close() {
        for (ISendingHardware<?> hardware : this.table.values()) {
            hardware.close();
        }
    }
}

