/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.InternetHostPanel;
import org.harctoolbox.guicomponents.NamedCommandLauncher;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.IrTransIRDB;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;
import org.harctoolbox.irscrutinizer.sendinghardware.SendingHardware;

public class SendingIrTrans
extends SendingHardware<IrTransIRDB>
implements ISendingHardware<IrTransIRDB> {
    private final InternetHostPanel internetHostPanel;
    private final NamedCommandLauncher namedCommandLauncher;
    private String desiredIp;
    private String currentIp = null;
    private IrTransIRDB rawIrSender;

    public SendingIrTrans(JPanel panel, Props properties, GuiUtils gui, InternetHostPanel internetHostPanel, NamedCommandLauncher namedCommandLauncher) {
        super(panel, properties, gui);
        this.internetHostPanel = internetHostPanel;
        this.namedCommandLauncher = namedCommandLauncher;
        this.desiredIp = properties.getIrTransIpName();
        this.internetHostPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    SendingIrTrans.this.setup();
                }
                catch (IOException | HarcHardwareException exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public String getName() {
        return "IrTrans";
    }

    @Override
    public Transmitter getTransmitter() throws NoSuchTransmitterException {
        return this.namedCommandLauncher.getTransmitter();
    }

    @Override
    public void setup() throws IOException, HarcHardwareException {
        this.internetHostPanel.setIpName(this.desiredIp);
        this.desiredIp = null;
        if (this.rawIrSender == null || this.currentIp == null || !this.currentIp.equals(this.internetHostPanel.getIpName())) {
            this.close();
            this.rawIrSender = null;
            this.rawIrSender = new IrTransIRDB(this.internetHostPanel.getIpName(), this.properties.getVerbose(), this.properties.getSendingTimeout());
            this.namedCommandLauncher.setHardware(this.rawIrSender);
            this.currentIp = this.internetHostPanel.getIpName();
            this.properties.setIrTransIpName(this.internetHostPanel.getIpName());
        }
    }

    @Override
    public IrTransIRDB getRawIrSender() {
        return this.rawIrSender;
    }
}

