/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.InternetHostPanel;
import org.harctoolbox.guicomponents.NamedCommandLauncher;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.LircCcfClient;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;
import org.harctoolbox.irscrutinizer.sendinghardware.SendingHardware;

public class SendingLircClient
extends SendingHardware<LircCcfClient>
implements ISendingHardware<LircCcfClient> {
    private final InternetHostPanel internetHostPanel;
    private final NamedCommandLauncher namedCommandLauncher;
    private LircCcfClient rawIrSender;

    public SendingLircClient(JPanel panel, Props properties, GuiUtils gui, InternetHostPanel internetHostPanel, NamedCommandLauncher namedCommandLauncher) {
        super(panel, properties, gui);
        this.internetHostPanel = internetHostPanel;
        this.namedCommandLauncher = namedCommandLauncher;
        this.internetHostPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    SendingLircClient.this.setup();
                }
                catch (IOException | HarcHardwareException ex) {
                    SendingLircClient.this.guiUtils.error(ex);
                }
            }
        });
    }

    public void setTimeout(int timeout) {
        this.rawIrSender.setTimeout(timeout);
    }

    @Override
    public String getName() {
        return "Lirc";
    }

    @Override
    public Transmitter getTransmitter() throws NoSuchTransmitterException {
        return this.namedCommandLauncher.getTransmitter();
    }

    @Override
    public void setup() throws IOException, HarcHardwareException {
        String lircIp = this.internetHostPanel.getIpName();
        int lircPort = this.internetHostPanel.getPortNumber();
        this.rawIrSender = new LircCcfClient(lircIp, lircPort, this.properties.getVerbose(), this.properties.getLircTimeout());
        try {
            this.internetHostPanel.setHardware(this.rawIrSender);
        }
        catch (IOException ex) {
            this.namedCommandLauncher.setHardware(null);
            throw ex;
        }
        this.namedCommandLauncher.setHardware(this.rawIrSender);
        this.properties.setLircIpName(lircIp);
        this.properties.setLircPort(lircPort);
    }

    @Override
    public LircCcfClient getRawIrSender() {
        return this.rawIrSender;
    }
}

