/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.sendinghardware;

import gnu.io.NoSuchPortException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.SerialPortSimpleBean;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.sendinghardware.ISendingHardware;
import org.harctoolbox.irscrutinizer.sendinghardware.SendingHardware;

public class SendingSerial<T extends IRawIrSender & IHarcHardware>
extends SendingHardware<T>
implements ISendingHardware<T> {
    private SerialPortSimpleBean serialPortSimpleBean;
    private String portName;
    private int baudRate;
    private Class<T> clazz;
    private T rawIrSender;

    public SendingSerial(Class<T> clazz, JPanel panel, SerialPortSimpleBean serialPortSimpleBean, Props props, GuiUtils guiUtils_) {
        super(panel, props, guiUtils_);
        this.serialPortSimpleBean = serialPortSimpleBean;
        this.baudRate = serialPortSimpleBean.getBaudRate();
        this.portName = serialPortSimpleBean.getPortName();
        this.clazz = clazz;
        serialPortSimpleBean.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                try {
                    switch (propertyName) {
                        case "PROP_PORTNAME": {
                            if (evt.getNewValue() == null) {
                                return;
                            }
                            SendingSerial.this.setup();
                            break;
                        }
                        case "PROP_BAUD": {
                            SendingSerial.this.setup();
                            break;
                        }
                        case "PROP_ISOPEN": {
                            break;
                        }
                        default: {
                            SendingSerial.this.guiUtils.error("Unknown property " + propertyName);
                            break;
                        }
                    }
                }
                catch (IOException ex) {
                    SendingSerial.this.guiUtils.error(ex);
                }
            }
        });
    }

    @Override
    public void setup() throws IOException {
        int newBaud = this.serialPortSimpleBean.getBaudRate();
        String newPort = this.serialPortSimpleBean.getPortName();
        if (newPort == null || this.rawIrSender != null && newPort.equals(this.portName) && this.baudRate == newBaud) {
            return;
        }
        if (this.rawIrSender != null) {
            ((Closeable)this.rawIrSender).close();
        }
        this.rawIrSender = null;
        try {
            this.rawIrSender = (IRawIrSender)this.clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE).newInstance(newPort, newBaud, this.properties.getSendingTimeout(), this.properties.getVerbose());
            this.portName = newPort;
            Props.class.getMethod("set" + this.clazz.getSimpleName() + "PortName", String.class).invoke((Object)this.properties, this.portName);
            this.baudRate = newBaud;
            Props.class.getMethod("set" + this.clazz.getSimpleName() + "PortBaudRate", Integer.TYPE).invoke((Object)this.properties, newBaud);
            this.serialPortSimpleBean.setHardware((IHarcHardware)this.rawIrSender);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException ex) {
            this.guiUtils.error(ex);
        }
        catch (InvocationTargetException ex) {
            if (NoSuchPortException.class.isInstance(ex.getCause())) {
                throw new IOException("No such port: " + newPort);
            }
            this.guiUtils.error(ex);
            this.guiUtils.error(ex.getCause().getClass().getName() + " " + ex.getCause().getMessage());
        }
    }

    @Override
    public String getName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public T getRawIrSender() {
        return this.rawIrSender;
    }
}

