/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.jirc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.jirc.IrNCode;
import org.harctoolbox.jirc.IrRemote;

public final class ConfigFile {
    public static final String defaultCharsetName = "WINDOWS-1252";
    private List<IrRemote> remotes = new ArrayList<IrRemote>();
    private LineNumberReader reader;
    private String line;
    private String[] words;

    private ConfigFile(File configFileName, String source, String charsetName, boolean rejectLircCode) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(configFileName), charsetName), source, rejectLircCode);
    }

    private ConfigFile(Reader reader, String source, boolean rejectLircCode) throws IOException {
        this.reader = new LineNumberReader(reader);
        this.line = null;
        this.words = new String[0];
        this.remotes = this.remotes(source, rejectLircCode);
        IrRemote last = null;
        for (IrRemote rem : this.remotes) {
            rem.next = null;
            if (last != null) {
                last.next = rem;
            }
            last = rem;
        }
    }

    public static Collection<IrRemote> readConfig(File filename, String charsetName, boolean rejectLircCode) throws IOException {
        if (filename.isFile()) {
            ConfigFile config = new ConfigFile(filename, filename.getCanonicalPath(), charsetName, rejectLircCode);
            return config.remotes;
        }
        if (filename.isDirectory()) {
            File[] files = filename.listFiles();
            HashMap<String, IrRemote> dictionary = new HashMap<String, IrRemote>();
            for (File file : files) {
                if (file.getName().endsWith(".jpg") || file.getName().endsWith(".png") || file.getName().endsWith(".gif") || file.getName().endsWith(".html")) {
                    System.err.println("Rejecting file " + file.getCanonicalPath());
                    continue;
                }
                Collection<IrRemote> map = ConfigFile.readConfig(file, charsetName, rejectLircCode);
                for (IrRemote irRemote : map) {
                    String remoteName = irRemote.getName();
                    int n = 1;
                    while (dictionary.containsKey(remoteName)) {
                        remoteName = irRemote.getName() + "$" + n++;
                    }
                    if (n > 1) {
                        System.err.println("Warning: remote name " + irRemote.getName() + " (source: " + irRemote.getSource() + ") already present, renaming to " + remoteName);
                    }
                    dictionary.put(remoteName, irRemote);
                }
            }
            return dictionary.values();
        }
        if (!filename.canRead()) {
            throw new FileNotFoundException(filename.getCanonicalPath());
        }
        return null;
    }

    public static Collection<IrRemote> readConfig(Reader reader, String source, boolean rejectLircCode) throws IOException {
        ConfigFile config = new ConfigFile(reader, source, rejectLircCode);
        return config.remotes;
    }

    public static RemoteSet parseConfig(File filename, String charsetName, boolean rejectLircCode, String creatingUser, boolean alternatingSigns) throws IOException {
        Collection<IrRemote> lircRemotes = ConfigFile.readConfig(filename, charsetName, rejectLircCode);
        return IrRemote.newRemoteSet(lircRemotes, filename.getCanonicalPath(), creatingUser, alternatingSigns, 0);
    }

    public static RemoteSet parseConfig(Reader reader, String source, boolean rejectLircCode, String creatingUser, boolean alternatingSigns) throws IOException {
        Collection<IrRemote> lircRemotes = ConfigFile.readConfig(reader, source, rejectLircCode);
        return IrRemote.newRemoteSet(lircRemotes, source, creatingUser, alternatingSigns, 0);
    }

    /*
     * Loose catch block
     */
    private List<IrRemote> remotes(String source, boolean rejectLircCode) throws IOException {
        ArrayList<IrRemote> rems = new ArrayList<IrRemote>();
        while (true) {
            try {
                while (true) {
                    IrRemote remote = this.remote();
                    remote.setSource(source);
                    if (remote.isTimingInfo() || !rejectLircCode) {
                        rems.add(remote);
                        continue;
                    }
                    System.err.println("Ignoring timingless remote " + remote.getName() + " in " + remote.getSource() + ". Unset \"Reject Lirc imports without timing\" if this is not desired.");
                }
            }
            catch (ParseException ex) {
                try {
                    this.lookFor("end", "remote");
                }
                catch (EofException ex1) {
                    return rems;
                }
            }
        }
        catch (EofException ex) {
            return rems;
        }
    }

    private IrRemote remote() throws IOException, ParseException, EofException {
        this.lookFor("begin", "remote");
        ProtocolParameters parameters = this.parameters();
        List<IrNCode> codes = this.codes();
        this.gobble("end", "remote");
        IrRemote irRemote = new IrRemote(parameters.name, parameters.driver, parameters.flags, parameters.unaryParameters, parameters.binaryParameters, codes);
        return irRemote;
    }

    private void readLine() throws IOException, EofException {
        if (this.line != null) {
            return;
        }
        this.words = new String[0];
        while (this.words.length == 0) {
            this.line = this.reader.readLine();
            if (this.line == null) {
                throw new EofException();
            }
            this.line = this.line.trim();
            int idx = this.line.indexOf(35);
            if (idx != -1) {
                this.line = this.line.substring(0, idx).trim();
            }
            if (this.line.isEmpty()) continue;
            this.words = this.line.split("\\s+");
        }
    }

    private void consumeLine() {
        this.line = null;
    }

    private void gobble(String ... tokens) throws IOException, EofException, ParseException {
        this.readLine();
        for (int i = 0; i < tokens.length; ++i) {
            if (this.words.length >= tokens.length && this.words[i].equalsIgnoreCase(tokens[i])) continue;
            throw new ParseException("Did not find " + ConfigFile.join(tokens), this.reader.getLineNumber());
        }
        this.consumeLine();
    }

    private void lookFor(String ... tokens) throws IOException, EofException {
        boolean hit;
        do {
            this.readLine();
            hit = true;
            for (int i = 0; i < tokens.length; ++i) {
                if (this.words.length >= tokens.length && this.words[i].equalsIgnoreCase(tokens[i])) continue;
                hit = false;
                break;
            }
            this.consumeLine();
        } while (!hit);
    }

    private static String join(String[] str) {
        return ConfigFile.join(str, 0);
    }

    private static String join(String[] str, int start) {
        StringBuilder result = new StringBuilder();
        for (int i = start; i < str.length; ++i) {
            result.append(str[i]).append(" ");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    private ProtocolParameters parameters() throws IOException, ParseException, EofException {
        parameters = new ProtocolParameters();
        while (true) {
            this.readLine();
            var2_2 = this.words[0];
            var3_3 = -1;
            switch (var2_2.hashCode()) {
                case 3373707: {
                    if (!var2_2.equals("name")) break;
                    var3_3 = 0;
                    break;
                }
                case -1323526104: {
                    if (!var2_2.equals("driver")) break;
                    var3_3 = 1;
                    break;
                }
                case 97513095: {
                    if (!var2_2.equals("flags")) break;
                    var3_3 = 2;
                    break;
                }
                case 93616297: {
                    if (!var2_2.equals("begin")) break;
                    var3_3 = 3;
                }
            }
            switch (var3_3) {
                case 0: {
                    ProtocolParameters.access$002(parameters, this.words[1]);
                    break;
                }
                case 1: {
                    ProtocolParameters.access$102(parameters, this.words[1]);
                    break;
                }
                case 2: {
                    parameters.flags = this.flags(this.words);
                    break;
                }
                case 3: {
                    return parameters;
                }
                default: {
                    try {
                        switch (this.words.length) {
                            case 2: {
                                parameters.add(this.words[0], IrNCode.parseLircNumber(this.words[1]));
                                ** break;
                            }
                            case 3: {
                                parameters.add(this.words[0], IrNCode.parseLircNumber(this.words[1]), IrNCode.parseLircNumber(this.words[2]));
                                ** break;
                            }
                        }
                        throw new ParseException("silly parameter decl: " + this.line, this.reader.getLineNumber());
lbl46:
                        // 2 sources

                        break;
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("Could not parse line \"" + this.line + "\": " + ex);
                    }
                }
            }
            this.consumeLine();
        }
    }

    private List<String> flags(String[] words) {
        String str = ConfigFile.join(words, 1);
        String[] array = str.split("\\s*\\|\\s*");
        return Arrays.asList(array);
    }

    private List<IrNCode> codes() throws IOException, EofException, ParseException {
        try {
            return this.cookedCodes();
        }
        catch (ParseException ex) {
            return this.rawCodes();
        }
    }

    private List<IrNCode> cookedCodes() throws IOException, EofException, ParseException {
        this.gobble("begin", "codes");
        ArrayList<IrNCode> codes = new ArrayList<IrNCode>();
        try {
            while (true) {
                IrNCode code = this.cookedCode();
                codes.add(code);
            }
        }
        catch (ParseException ex) {
            this.gobble("end", "codes");
            return codes;
        }
    }

    private IrNCode cookedCode() throws IOException, EofException, ParseException {
        this.readLine();
        if (this.words.length < 2) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        if (this.words[0].equalsIgnoreCase("end") && this.words[1].equalsIgnoreCase("codes")) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        ArrayList<Long> codes = new ArrayList<Long>();
        for (int i = 1; i < this.words.length; ++i) {
            codes.add(IrNCode.parseLircNumber(this.words[i]));
        }
        IrNCode irNCode = new IrNCode(this.words[0], codes);
        this.consumeLine();
        return irNCode;
    }

    private List<IrNCode> rawCodes() throws IOException, EofException, ParseException {
        this.gobble("begin", "raw_codes");
        ArrayList<IrNCode> codes = new ArrayList<IrNCode>();
        try {
            while (true) {
                IrNCode code = this.rawCode();
                codes.add(code);
            }
        }
        catch (ParseException ex) {
            this.gobble("end", "raw_codes");
            return codes;
        }
    }

    private IrNCode rawCode() throws IOException, EofException, ParseException {
        this.readLine();
        if (this.words.length < 2) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        if (this.words[0].equalsIgnoreCase("end") && this.words[1].equalsIgnoreCase("raw_codes")) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        if (!this.words[0].equalsIgnoreCase("name")) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        String cmdName = this.words[1];
        this.consumeLine();
        List<Integer> codes = this.integerList();
        IrNCode irNCode = new IrNCode(cmdName, 0L, codes);
        return irNCode;
    }

    private List<Integer> integerList() throws IOException, EofException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        while (true) {
            this.readLine();
            try {
                for (String w : this.words) {
                    numbers.add(Integer.parseInt(w));
                }
            }
            catch (NumberFormatException ex) {
                return numbers;
            }
            this.consumeLine();
        }
    }

    private static class ProtocolParameters {
        private String name = null;
        private String driver;
        List<String> flags = new ArrayList<String>();
        HashMap<String, Long> unaryParameters = new HashMap();
        HashMap<String, IrRemote.XY> binaryParameters = new HashMap();

        private ProtocolParameters() {
        }

        public void add(String name, long x) {
            this.unaryParameters.put(name, x);
        }

        public void add(String name, long x, long y) {
            this.binaryParameters.put(name, new IrRemote.XY(x, y));
        }

        static /* synthetic */ String access$002(ProtocolParameters x0, String x1) {
            x0.name = x1;
            return x0.name;
        }

        static /* synthetic */ String access$102(ProtocolParameters x0, String x1) {
            x0.driver = x1;
            return x0.driver;
        }
    }

    private static class EofException
    extends Exception {
        EofException(String str) {
            super(str);
        }

        private EofException() {
        }
    }
}

