/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.jirc;

import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import org.harctoolbox.jirc.IrCodeNode;

final class IrNCode {
    private String name;
    private long code;
    private List<Integer> signals;
    private IrCodeNode next;
    private IrCodeNode current;
    private IrCodeNode transmit_state;

    IrNCode(String name, long code, List<Integer> signals) {
        this.name = name;
        this.code = code;
        this.signals = signals;
    }

    IrNCode(String name, long code) {
        this(name, code, null);
    }

    IrNCode(String name, List<Long> codelist) {
        this(name, codelist.get(0), null);
        codelist.remove(0);
        this.next = codelist.isEmpty() ? null : new IrCodeNode(codelist);
    }

    public static long parseLircNumber(String s) {
        return s.toLowerCase(Locale.US).startsWith("0x") ? IrNCode.parseUnsignedLongHex(s.substring(2)) : (s.startsWith("0") ? Long.parseLong(s, 8) : Long.parseLong(s));
    }

    private static long parseUnsignedLongHex(String s) {
        if (s.length() == 16) {
            long value = new BigInteger(s, 16).longValue();
            return value;
        }
        return Long.parseLong(s, 16);
    }

    public String getName() {
        return this.name;
    }

    public long getCode() {
        return this.code;
    }

    public List<Integer> getSignals() {
        return this.signals;
    }

    public IrCodeNode getNext() {
        return this.next;
    }

    public IrCodeNode getCurrent() {
        return this.current;
    }

    public IrCodeNode getTransmit_state() {
        return this.transmit_state;
    }

    public void setCurrent(IrCodeNode current) {
        this.current = current;
    }

    public void setTransmit_state(IrCodeNode transmit_state) {
        this.transmit_state = transmit_state;
    }

    public void setCode(long code) {
        this.code = code;
    }
}

