/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.jirc;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.jirc.IrCodeNode;
import org.harctoolbox.jirc.IrNCode;
import org.harctoolbox.jirc.Transmit;

public final class IrRemote {
    private final int debug = 0;
    private static final int LOG_ERR = 1;
    private static final int LOG_WARNING = 2;
    private static IrRemote repeat_remote = null;
    static final int IR_PROTOCOL_MASK = 2047;
    static final int RAW_CODES = 1;
    static final int RC5 = 2;
    static final int SHIFT_ENC = 2;
    static final int RC6 = 4;
    static final int RCMM = 8;
    static final int SPACE_ENC = 16;
    static final int SPACE_FIRST = 32;
    static final int GOLDSTAR = 64;
    static final int GRUNDIG = 128;
    static final int BO = 256;
    static final int XMP = 1024;
    static final int REVERSE = 2048;
    static final int NO_HEAD_REP = 4096;
    static final int NO_FOOT_REP = 8192;
    static final int CONST_LENGTH = 16384;
    static final int REPEAT_HEADER = 32768;
    static final int COMPAT_REVERSE = 65536;
    static final int REPEAT_MAX_DEFAULT = 600;
    static final int DEFAULT_FREQ = 38000;
    private static final int PULSE_BIT = 0x1000000;
    private static final HashMap<String, Integer> all_flags = new HashMap<String, Integer>(){
        {
            this.put("RAW_CODES", 1);
            this.put("RC5", 2);
            this.put("SHIFT_ENC", 2);
            this.put("RC6", 4);
            this.put("RCMM", 8);
            this.put("SPACE_ENC", 16);
            this.put("SPACE_FIRST", 32);
            this.put("GOLDSTAR", 64);
            this.put("GRUNDIG", 128);
            this.put("BO", 256);
            this.put("XMP", 1024);
            this.put("REVERSE", 2048);
            this.put("NO_HEAD_REP", 4096);
            this.put("NO_FOOT_REP", 8192);
            this.put("CONST_LENGTH", 16384);
            this.put("REPEAT_HEADER", 32768);
        }
    };
    private String name;
    private String driver;
    private boolean timingInfo;
    private String source;
    private List<IrNCode> codes;
    int bits;
    int flags;
    int eps;
    int aeps;
    int phead;
    int shead;
    int pthree;
    int sthree;
    int ptwo;
    int stwo;
    int pone;
    int sone;
    int pzero;
    int szero;
    int plead;
    int ptrail;
    int pfoot;
    int sfoot;
    int prepeat;
    int srepeat;
    int pre_data_bits;
    long pre_data;
    int post_data_bits;
    long post_data;
    int pre_p;
    int pre_s;
    int post_p;
    int post_s;
    int gap;
    int gap2;
    int repeat_gap;
    int toggle_bit;
    long toggle_bit_mask;
    int suppress_repeat;
    int min_repeat;
    int min_code_repeat;
    int freq = 38000;
    int duty_cycle;
    int baud;
    long toggle_mask;
    long rc6_mask;
    long ignore_mask;
    long toggle_bit_mask_state;
    int toggle_mask_state;
    int repeat_countdown;
    IrNCode last_code;
    IrNCode toggle_code;
    int reps;
    Date last_send;
    int min_remaining_gap;
    int max_remaining_gap;
    int min_total_signal_length;
    private int max_total_signal_length;
    int min_gap_length;
    int max_gap_length;
    int min_pulse_length;
    int max_pulse_length;
    int min_space_length;
    int max_space_length;
    boolean release_detected;
    IrRemote next;

    private void logprintf(int level, String format, Object ... args) {
        System.err.println(String.format(format, args));
    }

    public static IrRemote getRepeat_remote() {
        return repeat_remote;
    }

    public static void setRepeat_remote(IrRemote remote) {
        repeat_remote = remote;
    }

    public HashMap<String, String> getApplicationData() {
        LinkedHashMap<String, String> applicationData = new LinkedHashMap<String, String>();
        if (this.driver != null) {
            applicationData.put("driver", this.driver);
        }
        applicationData.put("type", this.lircProtocolType());
        applicationData.put("bits", Integer.toString(this.bits));
        applicationData.put("flags", Integer.toString(this.flags));
        applicationData.put("eps", Integer.toString(this.eps));
        applicationData.put("aeps", Integer.toString(this.aeps));
        applicationData.put("pthree", Integer.toString(this.pthree));
        applicationData.put("sthree", Integer.toString(this.sthree));
        applicationData.put("ptwo", Integer.toString(this.ptwo));
        applicationData.put("stwo", Integer.toString(this.stwo));
        applicationData.put("pone", Integer.toString(this.pone));
        applicationData.put("sone", Integer.toString(this.sone));
        applicationData.put("pzero", Integer.toString(this.pzero));
        applicationData.put("szero", Integer.toString(this.szero));
        applicationData.put("plead", Integer.toString(this.plead));
        applicationData.put("ptrail", Integer.toString(this.ptrail));
        applicationData.put("pfoot", Integer.toString(this.pfoot));
        applicationData.put("sfoot", Integer.toString(this.sfoot));
        applicationData.put("prepeat", Integer.toString(this.prepeat));
        applicationData.put("srepeat", Integer.toString(this.srepeat));
        applicationData.put("pre_data_bits", Integer.toString(this.pre_data_bits));
        applicationData.put("pre_data", Long.toString(this.pre_data));
        applicationData.put("post_data_bits", Integer.toString(this.post_data_bits));
        applicationData.put("post_data", Long.toString(this.post_data));
        applicationData.put("pre_p", Integer.toString(this.pre_p));
        applicationData.put("pre_s", Integer.toString(this.pre_s));
        applicationData.put("post_p", Integer.toString(this.post_p));
        applicationData.put("post_s", Integer.toString(this.post_s));
        applicationData.put("gap", Integer.toString(this.gap));
        applicationData.put("gap2", Integer.toString(this.gap2));
        applicationData.put("repeat_gap", Integer.toString(this.repeat_gap));
        applicationData.put("toggle_bit", Integer.toString(this.toggle_bit));
        applicationData.put("toggle_bit_mask", Long.toString(this.toggle_bit_mask));
        applicationData.put("min_repeat", Integer.toString(this.min_repeat));
        applicationData.put("min_code_repeat", Integer.toString(this.min_code_repeat));
        applicationData.put("freq", Integer.toString(this.freq != -1 ? this.freq : 38000));
        applicationData.put("duty_cycle", Integer.toString(this.duty_cycle));
        applicationData.put("baud", Integer.toString(this.baud));
        applicationData.put("toggle_mask", Long.toString(this.toggle_mask));
        applicationData.put("rc6_mask", Long.toString(this.rc6_mask));
        applicationData.put("ignore_mask", Long.toString(this.ignore_mask));
        return applicationData;
    }

    public Remote toRemote(boolean alternatingSigns, int debug) {
        LinkedHashMap<String, HashMap<String, String>> appDataMap = new LinkedHashMap<String, HashMap<String, String>>();
        appDataMap.put("jirc", this.getApplicationData());
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>();
        for (IrNCode c : this.getCodes()) {
            Command command = this.toCommand(c, alternatingSigns, debug);
            if (command == null) continue;
            commands.put(command.getName(), command);
        }
        Remote.MetaData metaData = new Remote.MetaData(this.getName());
        return new Remote(metaData, null, null, commands, appDataMap);
    }

    Command toCommand(IrNCode code, boolean alternatingSigns, int debug) {
        return this.isTimingInfo() ? this.toTimedCommand(code, alternatingSigns, debug) : this.toLircCodeCommand(code);
    }

    Command toLircCodeCommand(IrNCode code) {
        HashMap<String, Long> parameters = new HashMap<String, Long>(1);
        parameters.put("lirc", code.getCode());
        try {
            return new Command(code.getName(), null, "lircdriver:" + this.driver, parameters);
        }
        catch (IrpMasterException ex) {
            throw new InternalError();
        }
    }

    Command toTimedCommand(IrNCode code, boolean alternatingSigns, int debug) {
        IrSignal irSignal = this.toIrSignal(code, alternatingSigns, debug);
        return irSignal != null ? new Command(code.getName(), null, irSignal) : null;
    }

    IrSignal toIrSignal(IrNCode code, boolean alternatingSigns, int debug) {
        IrSequence repeat;
        IrSequence intro = new IrSequence();
        do {
            IrSequence seq;
            if ((seq = this.render(code, alternatingSigns, false, debug)) == null || seq.isEmpty()) continue;
            intro = intro.append(seq);
        } while (code.getTransmit_state() != null);
        if ((code.getSignals() == null || code.getSignals().isEmpty()) && (intro == null || intro.isEmpty())) {
            return null;
        }
        if (code.getNext() == null) {
            repeat = this.render(code, alternatingSigns, true, debug);
        } else {
            repeat = intro;
            intro = null;
        }
        return new IrSignal((double)this.freq, -1.0, intro, repeat, null);
    }

    public static RemoteSet newRemoteSet(Collection<IrRemote> remotes, String configFilename, String creatingUser, boolean alternatingSigns, int debug) {
        if (remotes == null) {
            return null;
        }
        String decodeir_version = DecodeIR.getVersion();
        LinkedHashMap<String, Remote> girrRemotes = new LinkedHashMap<String, Remote>();
        for (IrRemote irRemote : remotes) {
            Remote remote = irRemote.toRemote(alternatingSigns, debug);
            girrRemotes.put(remote.getName(), remote);
        }
        RemoteSet girr = new RemoteSet(creatingUser == null ? System.getProperty("user.name") : creatingUser, configFilename, new Date().toString(), "Jirc", "1.3", "DecodeIr", decodeir_version != null ? decodeir_version : "not found", null, girrRemotes);
        return girr;
    }

    private boolean setNamedFlag(String flagName) {
        if (!all_flags.containsKey(flagName)) {
            return false;
        }
        this.flags |= all_flags.get(flagName).intValue();
        return false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTimingInfo() {
        return this.timingInfo;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    List<IrNCode> getCodes() {
        return this.codes;
    }

    public int getFreq() {
        return this.freq;
    }

    public int getDutyCycle() {
        return this.duty_cycle;
    }

    private IrRemote() {
    }

    IrRemote(String name, String driver, List<String> flags, HashMap<String, Long> unaryParameters, HashMap<String, XY> binaryParameters, List<IrNCode> codes) {
        this.name = name;
        this.driver = driver;
        for (String string : flags) {
            this.setNamedFlag(string);
        }
        for (Map.Entry entry : unaryParameters.entrySet()) {
            this.setNamedParameter((String)entry.getKey(), (Long)entry.getValue());
        }
        for (Map.Entry entry : binaryParameters.entrySet()) {
            this.setNamedParameter((String)entry.getKey(), ((XY)entry.getValue()).x, ((XY)entry.getValue()).y);
        }
        this.codes = codes;
        this.timingInfo = this.hasSaneTimingInfo() || this.is_raw();
        this.sanityChecks();
    }

    public int bit_count() {
        return this.pre_data_bits + this.bits + this.post_data_bits;
    }

    static int bit_count(IrRemote remote) {
        return remote.pre_data_bits + remote.bits + remote.post_data_bits;
    }

    static int bits_set(long data) {
        return Long.bitCount(data);
    }

    static long reverse(long data, int bits) {
        long c = 0L;
        for (int i = 0; i < bits; ++i) {
            c |= (long)((data & 1L << i) != 0L ? 1 : 0) << bits - 1 - i;
        }
        return c;
    }

    static boolean is_pulse(int data) {
        return (data & 0x1000000) != 0;
    }

    static boolean is_space(int data) {
        return !IrRemote.is_pulse(data);
    }

    public boolean has_repeat() {
        return this.prepeat > 0 && this.srepeat > 0;
    }

    static boolean has_repeat(IrRemote remote) {
        return remote.prepeat > 0 && remote.srepeat > 0;
    }

    static void set_protocol(IrRemote remote, int protocol) {
        remote.flags &= 0xFFFFF800;
        remote.flags |= protocol;
    }

    public void set_protocol(int protocol) {
        this.flags &= 0xFFFFF800;
        this.flags |= protocol;
    }

    public boolean is_raw() {
        return (this.flags & 0x7FF) == 1;
    }

    public static boolean is_raw(IrRemote remote) {
        return remote.is_raw();
    }

    public boolean is_space_enc() {
        return (this.flags & 0x7FF) == 16;
    }

    static boolean is_space_enc(IrRemote remote) {
        return remote.is_space_enc();
    }

    public boolean is_space_first() {
        return (this.flags & 0x7FF) == 32;
    }

    public static boolean is_space_first(IrRemote remote) {
        return remote.is_space_first();
    }

    public boolean is_rc5() {
        return (this.flags & 0x7FF) == 2;
    }

    public static boolean is_rc5(IrRemote remote) {
        return remote.is_rc5();
    }

    public boolean is_rc6() {
        return (this.flags & 0x7FF) == 4 || this.rc6_mask != 0L;
    }

    public static boolean is_rc6(IrRemote remote) {
        return remote.is_rc6();
    }

    boolean is_biphase() {
        return this.is_rc5() || this.is_rc6();
    }

    static boolean is_biphase(IrRemote remote) {
        return remote.is_biphase();
    }

    public boolean is_rcmm() {
        return (this.flags & 0x7FF) == 8;
    }

    public static boolean is_rcmm(IrRemote remote) {
        return remote.is_rcmm();
    }

    public boolean is_goldstar() {
        return (this.flags & 0x7FF) == 64;
    }

    public static boolean is_goldstar(IrRemote remote) {
        return remote.is_goldstar();
    }

    public boolean is_grundig() {
        return (this.flags & 0x7FF) == 128;
    }

    public static boolean is_grundig(IrRemote remote) {
        return remote.is_grundig();
    }

    public boolean is_bo() {
        return (this.flags & 0x7FF) == 256;
    }

    public static boolean is_bo(IrRemote remote) {
        return remote.is_bo();
    }

    public boolean is_xmp() {
        return (this.flags & 0x7FF) == 1024;
    }

    public static boolean is_xmp(IrRemote remote) {
        return remote.is_xmp();
    }

    public boolean is_const() {
        return (this.flags & 0x4000) != 0;
    }

    static boolean is_const(IrRemote remote) {
        return (remote.flags & 0x4000) != 0;
    }

    public boolean has_repeat_gap() {
        return this.repeat_gap > 0;
    }

    static boolean has_repeat_gap(IrRemote remote) {
        return remote.repeat_gap > 0;
    }

    public boolean has_pre() {
        return this.pre_data_bits > 0;
    }

    static boolean has_pre(IrRemote remote) {
        return remote.pre_data_bits > 0;
    }

    public boolean has_post() {
        return this.post_data_bits > 0;
    }

    static boolean has_post(IrRemote remote) {
        return remote.post_data_bits > 0;
    }

    public boolean has_header() {
        return this.phead > 0 && this.shead > 0;
    }

    public static boolean has_header(IrRemote remote) {
        return remote.has_header();
    }

    boolean has_foot() {
        return this.pfoot > 0 && this.sfoot > 0;
    }

    static boolean has_foot(IrRemote remote) {
        return remote.has_foot();
    }

    public boolean has_toggle_bit_mask() {
        return this.toggle_bit_mask > 0L;
    }

    static boolean has_toggle_bit_mask(IrRemote remote) {
        return remote.toggle_bit_mask > 0L;
    }

    static boolean has_ignore_mask(IrRemote remote) {
        return remote.ignore_mask > 0L;
    }

    boolean has_toggle_mask() {
        return this.toggle_mask > 0L;
    }

    static boolean has_toggle_mask(IrRemote remote) {
        return remote.has_toggle_mask();
    }

    public int min_gap() {
        return this.gap2 != 0 && this.gap2 < this.gap ? this.gap2 : this.gap;
    }

    static int min_gap(IrRemote remote) {
        return remote.gap2 != 0 && remote.gap2 < remote.gap ? remote.gap2 : remote.gap;
    }

    public int max_gap() {
        return this.gap2 > this.gap ? this.gap2 : this.gap;
    }

    static int max_gap(IrRemote remote) {
        return remote.gap2 > remote.gap ? remote.gap2 : remote.gap;
    }

    static long gen_mask(int bits) {
        long mask = 0L;
        for (int i = 0; i < bits; ++i) {
            mask <<= 1;
            mask |= 1L;
        }
        return mask;
    }

    private boolean hasSaneTimingInfo() {
        return this.pzero != 0 && this.szero != 0 && this.pone != 0 && this.sone != 0;
    }

    private boolean sanityChecks() {
        if (this.name == null) {
            this.logprintf(1, "you must specify a remote name", new Object[0]);
            return false;
        }
        if (this.gap == 0) {
            this.logprintf(2, "you should specify a valid gap value", new Object[0]);
        }
        if (this.has_repeat_gap() && this.is_const()) {
            this.logprintf(2, "repeat_gap will be ignored if CONST_LENGTH flag is set", new Object[0]);
        }
        if (this.is_raw()) {
            return true;
        }
        if ((this.pre_data & IrRemote.gen_mask(this.pre_data_bits)) != this.pre_data) {
            this.logprintf(2, "invalid pre_data found for %s", this.name);
            this.pre_data &= IrRemote.gen_mask(this.pre_data_bits);
        }
        if ((this.post_data & IrRemote.gen_mask(this.post_data_bits)) != this.post_data) {
            this.logprintf(2, "invalid post_data found for %s", this.name);
            this.post_data &= IrRemote.gen_mask(this.post_data_bits);
        }
        for (IrNCode codes : this.codes) {
            if ((codes.getCode() & IrRemote.gen_mask(this.bits)) != codes.getCode()) {
                this.logprintf(2, "invalid code found for %s: %s", this.name, codes.getName());
                codes.setCode(codes.getCode() & IrRemote.gen_mask(this.bits));
            }
            for (IrCodeNode node = codes.getNext(); node != null; node = node.getNext()) {
                if ((node.getCode() & IrRemote.gen_mask(this.bits)) == node.getCode()) continue;
                this.logprintf(2, "invalid code found for %s: %s", this.name, codes.getName());
                node.setCode(node.getCode() & IrRemote.gen_mask(this.bits));
            }
        }
        return true;
    }

    private boolean setNamedParameter(String key, long val) {
        if (key.equalsIgnoreCase("bits")) {
            this.bits = (int)val;
        } else if (key.equalsIgnoreCase("eps")) {
            this.eps = (int)val;
        } else if (key.equalsIgnoreCase("aeps")) {
            this.aeps = (int)val;
        } else if (key.equalsIgnoreCase("plead")) {
            this.plead = (int)val;
        } else if (key.equalsIgnoreCase("ptrail")) {
            this.ptrail = (int)val;
        } else if (key.equalsIgnoreCase("pre_data_bits")) {
            this.pre_data_bits = (int)val;
        } else if (key.equalsIgnoreCase("pre_data")) {
            this.pre_data = val;
        } else if (key.equalsIgnoreCase("post_data_bits")) {
            this.post_data_bits = (int)val;
        } else if (key.equalsIgnoreCase("post_data")) {
            this.post_data = val;
        } else if (key.equalsIgnoreCase("gap")) {
            this.gap = (int)val;
        } else if (key.equalsIgnoreCase("repeat_gap")) {
            this.repeat_gap = (int)val;
        } else if (key.equalsIgnoreCase("toggle_bit")) {
            this.toggle_bit = (int)val;
        } else if (key.equalsIgnoreCase("toggle_bit_mask")) {
            this.toggle_bit_mask = val;
        } else if (key.equalsIgnoreCase("toggle_mask")) {
            this.toggle_mask = val;
        } else if (key.equalsIgnoreCase("rc6_mask")) {
            this.rc6_mask = val;
        } else if (key.equalsIgnoreCase("ignore_mask")) {
            this.ignore_mask = val;
        } else if (key.equalsIgnoreCase("repeat_bit")) {
            this.toggle_bit = (int)val;
        } else if (key.equalsIgnoreCase("suppress_repeat")) {
            this.suppress_repeat = (int)val;
        } else if (key.equalsIgnoreCase("min_repeat")) {
            this.min_repeat = (int)val;
        } else if (key.equalsIgnoreCase("min_code_repeat")) {
            this.min_code_repeat = (int)val;
        } else if (key.equalsIgnoreCase("frequency")) {
            this.freq = (int)val;
        } else if (key.equalsIgnoreCase("duty_cycle")) {
            this.duty_cycle = (int)val;
        } else if (key.equalsIgnoreCase("baud")) {
            this.baud = (int)val;
        } else {
            this.logprintf(1, "unknown definiton or too few arguments: \"%s %s\"", key, val);
            return false;
        }
        return true;
    }

    private boolean setNamedParameter(String key, long x, long y) {
        if (key.equalsIgnoreCase("gap")) {
            this.gap = (int)x;
            this.gap2 = (int)y;
        } else if (key.equalsIgnoreCase("header")) {
            this.phead = (int)x;
            this.shead = (int)y;
        } else if (key.equalsIgnoreCase("three")) {
            this.pthree = (int)x;
            this.sthree = (int)y;
        } else if (key.equalsIgnoreCase("two")) {
            this.ptwo = (int)x;
            this.stwo = (int)y;
        } else if (key.equalsIgnoreCase("one")) {
            this.pone = (int)x;
            this.sone = (int)y;
        } else if (key.equalsIgnoreCase("zero")) {
            this.pzero = (int)x;
            this.szero = (int)y;
        } else if (key.equalsIgnoreCase("foot")) {
            this.pfoot = (int)x;
            this.sfoot = (int)y;
        } else if (key.equalsIgnoreCase("repeat")) {
            this.prepeat = (int)x;
            this.srepeat = (int)y;
        } else if (key.equalsIgnoreCase("pre")) {
            this.pre_p = (int)x;
            this.pre_s = (int)y;
        } else if (key.equalsIgnoreCase("post")) {
            this.post_p = (int)x;
            this.post_s = (int)y;
        } else {
            this.logprintf(1, "unknown definiton: \"%s %s %s\"", key, x, y);
            return false;
        }
        return true;
    }

    public String lircProtocolType() {
        return this.is_raw() ? "RAW_CODES" : (this.is_space_enc() ? "SPACE_ENC" : (this.is_space_first() ? "SPACE_FIRST" : (this.is_rc5() ? "RC5" : (this.is_rc6() ? "RC6" : (this.is_rcmm() ? "RCMM" : (this.is_goldstar() ? "GOLDSTAR" : (this.is_grundig() ? "GRUNDIG" : (this.is_bo() ? "BO" : (this.is_xmp() ? "XMP" : "??")))))))));
    }

    public ModulatedIrSequence toSequence(int[] array, boolean alternatingSigns) throws IncompatibleArgumentException {
        if (array[array.length - 1] == 0) {
            array[array.length - 1] = alternatingSigns ? -this.gap : this.gap;
        }
        return new ModulatedIrSequence(array, (double)this.freq);
    }

    public ModulatedIrSequence toSequence(List<Integer> signals, boolean alternatingSigns) throws IncompatibleArgumentException {
        int[] array = new int[signals.size() + signals.size() % 2];
        array[array.length - 1] = 0;
        int index = 0;
        for (Integer d : signals) {
            array[index] = alternatingSigns && index & true ? -d.intValue() : d;
            ++index;
        }
        return this.toSequence(array, alternatingSigns);
    }

    IrSequence render(IrNCode code, boolean useSignsInRawSequences, boolean repeat, int debug) {
        ModulatedIrSequence seq = null;
        try {
            Transmit transmit = null;
            if (code.getSignals() != null && !code.getSignals().isEmpty()) {
                seq = repeat ? this.toSequence(code.getSignals(), useSignsInRawSequences) : null;
            } else {
                transmit = new Transmit(this, code, debug, repeat);
                boolean success = transmit.getValid();
                if (success) {
                    int[] arr = transmit.getData(this.min_remaining_gap);
                    seq = this.toSequence(arr, useSignsInRawSequences);
                }
            }
        }
        catch (IncompatibleArgumentException ex) {
            System.err.println(ex.getMessage());
        }
        return seq;
    }

    static class XY {
        public long x;
        public long y;

        XY(long x, long y) {
            this.x = x;
            this.y = y;
        }
    }
}

