/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.jirc;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.jirc.ConfigFile;
import org.harctoolbox.jirc.IrRemote;
import org.w3c.dom.Document;

public final class Lirc2Xml {
    static final boolean useSignsInRawSequences = true;
    static final String defaultExtension = "girr";
    static final String DEFAULT_EXPORTDIR = ".";
    private static JCommander argumentParser;
    private static CommandLineArgs commandLineArgs;

    private static String basename(String s) {
        StringBuilder sb = new StringBuilder(s);
        int n = sb.lastIndexOf(File.separator);
        if (n != -1) {
            sb.delete(0, n + 1);
        }
        if ((n = sb.lastIndexOf(DEFAULT_EXPORTDIR)) != -1) {
            sb.delete(n, sb.length());
        }
        return sb.toString();
    }

    private Lirc2Xml() {
    }

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder();
        argumentParser.usage(str);
        (exitcode == 0 ? System.out : System.err).println(str);
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        String configFilename;
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("Lirc2Xml");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        if (Lirc2Xml.commandLineArgs.helpRequested) {
            Lirc2Xml.usage(0);
        }
        if (Lirc2Xml.commandLineArgs.versionRequested) {
            System.out.println("Jirc version 1.3");
            System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
            System.out.println("DecodeIR version " + DecodeIR.getVersion());
            System.out.println();
            System.out.println("Copyright (C) 2011, 2012, 2013, 2014, 2015, 2016 Bengt Martensson.\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.");
            System.exit(0);
        }
        if (!(Lirc2Xml.commandLineArgs.generateCcf || Lirc2Xml.commandLineArgs.generateRaw || Lirc2Xml.commandLineArgs.generateParameters)) {
            System.out.println("Warning: Neither parameters (\"-p\"), ccf/hex (\"-c\"), nor raw (\"-R\") requested.");
            System.err.println("Output will be generated per your request, but it will likely be useless.");
        }
        String string = configFilename = Lirc2Xml.commandLineArgs.configfile.isEmpty() ? null : Lirc2Xml.commandLineArgs.configfile.get(0);
        if (Lirc2Xml.commandLineArgs.debug > 0) {
            System.err.println("debug = " + Lirc2Xml.commandLineArgs.debug);
            System.err.println("outputfilename = " + Lirc2Xml.commandLineArgs.outputfile);
            System.err.println("configfile = " + configFilename);
            System.err.println("remote = " + Lirc2Xml.commandLineArgs.remote);
        }
        try {
            OutputStream xmlStream;
            RemoteSet remoteSet;
            Collection<IrRemote> remotes;
            if (configFilename == null) {
                if (Lirc2Xml.commandLineArgs.debug > 0) {
                    System.err.println("Reading stdin.");
                }
                remotes = ConfigFile.readConfig(new InputStreamReader(System.in, Lirc2Xml.commandLineArgs.inputEncoding), "<stdin>", Lirc2Xml.commandLineArgs.lircCode);
            } else {
                try {
                    URL url = new URL(configFilename);
                    if (Lirc2Xml.commandLineArgs.debug > 0) {
                        System.err.println("Looks like an url.");
                    }
                    URLConnection urlConnection = url.openConnection();
                    InputStream inputStream = urlConnection.getInputStream();
                    remotes = ConfigFile.readConfig(new InputStreamReader(inputStream, Lirc2Xml.commandLineArgs.inputEncoding), url.toString(), Lirc2Xml.commandLineArgs.lircCode);
                }
                catch (MalformedURLException ex) {
                    if (Lirc2Xml.commandLineArgs.debug > 0) {
                        System.err.println("Does not look like an url, hope it is a file.");
                    }
                    remotes = ConfigFile.readConfig(new File(configFilename), Lirc2Xml.commandLineArgs.inputEncoding, Lirc2Xml.commandLineArgs.lircCode);
                }
            }
            if (Lirc2Xml.commandLineArgs.remote != null) {
                IrRemote selected = null;
                for (IrRemote irRemote : remotes) {
                    if (!irRemote.getName().equals(Lirc2Xml.commandLineArgs.remote)) continue;
                    selected = irRemote;
                    break;
                }
                if (selected != null) {
                    remotes = new ArrayList<IrRemote>(1);
                    remotes.add(selected);
                } else {
                    System.err.println("No such remote " + Lirc2Xml.commandLineArgs.remote + " found, exiting.");
                    System.exit(3);
                }
            }
            if ((remoteSet = IrRemote.newRemoteSet(remotes, configFilename, System.getProperty("user.name", "unknown"), true, Lirc2Xml.commandLineArgs.debug)) == null) {
                System.err.println("No remotes in found in file " + configFilename + ", no output generated.");
                System.exit(3);
            }
            Document doc = remoteSet.xmlExportDocument("Lirc2XML export from " + configFilename, "xsl", Lirc2Xml.commandLineArgs.stylesheetUrl, Lirc2Xml.commandLineArgs.fatRaw, Lirc2Xml.commandLineArgs.createSchemaLocation, Lirc2Xml.commandLineArgs.generateRaw, Lirc2Xml.commandLineArgs.generateCcf, Lirc2Xml.commandLineArgs.generateParameters);
            String outFilename = null;
            if (Lirc2Xml.commandLineArgs.outputfile == null) {
                String outputDirName;
                String string2 = outputDirName = System.getenv("LIRC_XML_EXPORTDIR") != null ? System.getenv("LIRC_XML_EXPORTDIR") : DEFAULT_EXPORTDIR;
                if (configFilename == null) {
                    configFilename = "STDIN";
                }
                if (configFilename.endsWith(File.separator)) {
                    configFilename = configFilename.substring(0, configFilename.length() - 1);
                }
                File f = new File(outputDirName, Lirc2Xml.basename(configFilename) + DEFAULT_EXPORTDIR + defaultExtension);
                outFilename = f.getCanonicalPath();
                xmlStream = new FileOutputStream(f);
            } else if (Lirc2Xml.commandLineArgs.outputfile.equals("-")) {
                xmlStream = System.out;
                outFilename = "<stdout>";
            } else {
                xmlStream = new FileOutputStream(Lirc2Xml.commandLineArgs.outputfile);
                outFilename = Lirc2Xml.commandLineArgs.outputfile;
            }
            XmlUtils.printDOM(xmlStream, doc, Lirc2Xml.commandLineArgs.encoding);
            System.err.println(remotes.size() + " remote(s) written to XML export file " + outFilename + DEFAULT_EXPORTDIR);
            System.exit(0);
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Unsupported encoding: " + ex.getMessage());
            System.exit(1);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage() + " could not be found.");
            System.exit(5);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(7);
        }
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-c", "--ccf", "--hex", "--pronto"}, description="Generate the CCF (\"Hex\", \"Pronto\") form of the signals")
        boolean generateCcf = false;
        @Parameter(names={"-d", "--debug"}, description="Debug. Not really useful...")
        int debug = 0;
        @Parameter(names={"-e", "--encoding", "--outputencoding"}, description="Character encoding of the generated XML file")
        String encoding = "UTF-8";
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        boolean helpRequested = false;
        @Parameter(names={"-f", "--fatraw"}, description="Use the fat format for raw signals")
        boolean fatRaw = false;
        @Parameter(names={"-i", "--inputencoding"}, description="Character encoding used for reading input")
        String inputEncoding = "WINDOWS-1252";
        @Parameter(names={"-l", "--lirccode"}, description="Also accept lirc files without timing info, so-called Lirccode remotes.")
        boolean lircCode = false;
        @Parameter(names={"-o", "--outfile"}, description="Output filename")
        String outputfile = null;
        @Parameter(names={"-p", "--parameters"}, description="Generate the protocol name and parameters (if possible) for the signals")
        boolean generateParameters = false;
        @Parameter(names={"-s", "--schemalocation"}, description="Create schema location attribute")
        boolean createSchemaLocation = false;
        @Parameter(names={"-r", "--remote"}, description="Name of the remote to include in the export (will export all if left empty)")
        String remote = null;
        @Parameter(names={"-R", "--raw"}, description="Generate the raw form of the signals")
        boolean generateRaw = false;
        @Parameter(names={"-v", "--version"}, description="Display version information")
        boolean versionRequested;
        @Parameter(names={"-x", "--xslt"}, description="Link to XSLT stylesheet")
        String stylesheetUrl = null;
        @Parameter(description="[configfile]")
        ArrayList<String> configfile = new ArrayList();

        private CommandLineArgs() {
        }
    }
}

