/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.jirc;

import java.util.List;
import org.harctoolbox.jirc.IrNCode;
import org.harctoolbox.jirc.IrRemote;

final class Transmit {
    private IrRemote remote;
    private boolean valid = false;
    private int debug = 0;
    private static final int WBUF_SIZE = 1024;
    private static final int LOG_ERR = 1;
    private static final int LOG_WARNING = 2;
    private static final int LIRCD_EXACT_GAP_THRESHOLD = 10000;
    private Sbuf send_buffer = new Sbuf();

    private Transmit() {
    }

    Transmit(IrRemote remote, IrNCode code, int debug, boolean repeat) {
        this.remote = remote;
        IrRemote.setRepeat_remote(null);
        this.valid = this.init_send(remote, code, debug);
        if (repeat) {
            remote.repeat_countdown = 1;
            IrRemote.setRepeat_remote(remote);
            this.init_send(remote, code, debug);
        }
    }

    public boolean getValid() {
        return this.valid;
    }

    public int[] getData(int gap) {
        return this.valid ? this.send_buffer.getData(gap) : null;
    }

    public int[] getData() {
        return this.valid ? this.send_buffer.getData() : null;
    }

    private void logprintf(int level, String format, Object ... args) {
        System.err.println(String.format(this.remote.getSource() + " (" + this.remote.getName() + "): " + format, args));
    }

    private void LOGPRINTF(int level, String format, Object ... args) {
        if (this.debug > 0) {
            System.err.println(String.format(this.remote.getName() + ": " + format, args));
        }
    }

    private void clear_send_buffer() {
        this.LOGPRINTF(3, "clearing transmit buffer", new Object[0]);
        this.send_buffer.wptr = 0;
        this.send_buffer.too_long = false;
        this.send_buffer.is_biphase = false;
        this.send_buffer.pendingp = 0;
        this.send_buffer.pendings = 0;
        this.send_buffer.sum = 0;
    }

    private void add_send_buffer(int data) {
        if (this.send_buffer.wptr < 1024) {
            this.LOGPRINTF(3, "adding to transmit buffer: %d", data);
            this.send_buffer.sum += data;
            this.send_buffer._data[this.send_buffer.wptr] = data;
            ++this.send_buffer.wptr;
        } else {
            this.send_buffer.too_long = true;
        }
    }

    private void send_pulse(int data) {
        if (this.send_buffer.pendingp > 0) {
            this.send_buffer.pendingp += data;
        } else {
            if (this.send_buffer.pendings > 0) {
                this.add_send_buffer(this.send_buffer.pendings);
                this.send_buffer.pendings = 0;
            }
            this.send_buffer.pendingp = data;
        }
    }

    private void send_space(int data) {
        if (this.send_buffer.wptr == 0 && this.send_buffer.pendingp == 0) {
            this.LOGPRINTF(1, "first signal is a space!", new Object[0]);
            return;
        }
        if (this.send_buffer.pendings > 0) {
            this.send_buffer.pendings += data;
        } else {
            if (this.send_buffer.pendingp > 0) {
                this.add_send_buffer(this.send_buffer.pendingp);
                this.send_buffer.pendingp = 0;
            }
            this.send_buffer.pendings = data;
        }
    }

    private boolean bad_send_buffer() {
        if (this.send_buffer.too_long) {
            return true;
        }
        return this.send_buffer.wptr == 1024 && this.send_buffer.pendingp > 0;
    }

    private boolean check_send_buffer() {
        if (this.send_buffer.wptr == 0) {
            this.LOGPRINTF(1, "nothing to send", new Object[0]);
            return false;
        }
        for (int i = 0; i < this.send_buffer.wptr; ++i) {
            if (this.send_buffer.data[i] != 0) continue;
            if (i % 2 != 0) {
                this.LOGPRINTF(1, "invalid space: %d", i);
            } else {
                this.LOGPRINTF(1, "invalid pulse: %d", i);
            }
            return false;
        }
        return true;
    }

    private void flush_send_buffer() {
        if (this.send_buffer.pendingp > 0) {
            this.add_send_buffer(this.send_buffer.pendingp);
            this.send_buffer.pendingp = 0;
        }
        if (this.send_buffer.pendings > 0) {
            this.add_send_buffer(this.send_buffer.pendings);
            this.send_buffer.pendings = 0;
        }
    }

    private void sync_send_buffer() {
        if (this.send_buffer.pendingp > 0) {
            this.add_send_buffer(this.send_buffer.pendingp);
            this.send_buffer.pendingp = 0;
        }
        if (this.send_buffer.wptr > 0 && this.send_buffer.wptr % 2 == 0) {
            --this.send_buffer.wptr;
        }
    }

    private void send_header(IrRemote remote) {
        if (remote.has_header()) {
            this.send_pulse(remote.phead);
            this.send_space(remote.shead);
        }
    }

    private void send_foot(IrRemote remote) {
        if (remote.has_foot()) {
            this.send_space(remote.sfoot);
            this.send_pulse(remote.pfoot);
        }
    }

    private void send_lead(IrRemote remote) {
        if (remote.plead != 0) {
            this.send_pulse(remote.plead);
        }
    }

    private void send_trail(IrRemote remote) {
        if (remote.ptrail != 0) {
            this.send_pulse(remote.ptrail);
        }
    }

    private void send_data(IrRemote remote, long data, int bits, int done) {
        int all_bits = remote.bit_count();
        int toggle_bit_mask_bits = IrRemote.bits_set(remote.toggle_bit_mask);
        data = IrRemote.reverse(data, bits);
        if (remote.is_rcmm()) {
            long mask = 1 << all_bits - 1 - done;
            if (bits % 2 != 0 || done % 2 != 0) {
                this.logprintf(1, "invalid bit number.", new Object[0]);
                return;
            }
            int i = 0;
            while (i < bits) {
                switch ((int)(data & 3L)) {
                    case 0: {
                        this.send_pulse(remote.pzero);
                        this.send_space(remote.szero);
                        break;
                    }
                    case 2: {
                        this.send_pulse(remote.pone);
                        this.send_space(remote.sone);
                        break;
                    }
                    case 1: {
                        this.send_pulse(remote.ptwo);
                        this.send_space(remote.stwo);
                        break;
                    }
                    case 3: {
                        this.send_pulse(remote.pthree);
                        this.send_space(remote.sthree);
                    }
                }
                data >>= 2;
                i += 2;
                mask >>= 2;
            }
            return;
        }
        if (remote.is_xmp()) {
            if (bits % 4 != 0 || done % 4 != 0) {
                this.logprintf(1, "invalid bit number.", new Object[0]);
                return;
            }
            for (int i = 0; i < bits; i += 4) {
                long nibble = IrRemote.reverse(data & 0xFL, 4);
                this.send_pulse(remote.pzero);
                this.send_space((int)((long)remote.szero + nibble * (long)remote.sone));
                data >>= 4;
            }
            return;
        }
        long mask = 1L << all_bits - 1 - done;
        int i = 0;
        while (i < bits) {
            if (remote.has_toggle_bit_mask() && (mask & remote.toggle_bit_mask) != 0L) {
                if (toggle_bit_mask_bits == 1) {
                    data &= 0xFFFFFFFFFFFFFFFEL;
                    if ((remote.toggle_bit_mask_state & mask) != 0L) {
                        data |= 1L;
                    }
                } else if ((remote.toggle_bit_mask_state & mask) != 0L) {
                    data ^= 1L;
                }
            }
            if (remote.has_toggle_mask() && (mask & remote.toggle_mask) != 0L && remote.toggle_mask_state % 2 != 0) {
                data ^= 1L;
            }
            if ((data & 1L) != 0L) {
                if (remote.is_biphase()) {
                    if ((mask & remote.rc6_mask) != 0L) {
                        this.send_space(2 * remote.sone);
                        this.send_pulse(2 * remote.pone);
                    } else {
                        this.send_space(remote.sone);
                        this.send_pulse(remote.pone);
                    }
                } else if (remote.is_space_first()) {
                    this.send_space(remote.sone);
                    this.send_pulse(remote.pone);
                } else {
                    this.send_pulse(remote.pone);
                    this.send_space(remote.sone);
                }
            } else if ((mask & remote.rc6_mask) != 0L) {
                this.send_pulse(2 * remote.pzero);
                this.send_space(2 * remote.szero);
            } else if (remote.is_space_first()) {
                this.send_space(remote.szero);
                this.send_pulse(remote.pzero);
            } else {
                this.send_pulse(remote.pzero);
                this.send_space(remote.szero);
            }
            data >>= 1;
            ++i;
            mask >>= 1;
        }
    }

    private void send_pre(IrRemote remote) {
        if (remote.has_pre()) {
            this.send_data(remote, remote.pre_data, remote.pre_data_bits, 0);
            if (remote.pre_p > 0 && remote.pre_s > 0) {
                this.send_pulse(remote.pre_p);
                this.send_space(remote.pre_s);
            }
        }
    }

    private void send_post(IrRemote remote) {
        if (remote.has_post()) {
            if (remote.post_p > 0 && remote.post_s > 0) {
                this.send_pulse(remote.post_p);
                this.send_space(remote.post_s);
            }
            this.send_data(remote, remote.post_data, remote.post_data_bits, remote.pre_data_bits + remote.bits);
        }
    }

    private void send_repeat(IrRemote remote) {
        this.send_lead(remote);
        this.send_pulse(remote.prepeat);
        this.send_space(remote.srepeat);
        this.send_trail(remote);
    }

    private void send_code(IrRemote remote, long code, boolean repeat) {
        if (!repeat || (remote.flags & 0x1000) == 0) {
            this.send_header(remote);
        }
        this.send_lead(remote);
        this.send_pre(remote);
        this.send_data(remote, code, remote.bits, remote.pre_data_bits);
        this.send_post(remote);
        this.send_trail(remote);
        if (!repeat || (remote.flags & 0x2000) == 0) {
            this.send_foot(remote);
        }
        if (!repeat && (remote.flags & 0x1000) != 0 && (remote.flags & 0x4000) != 0) {
            this.send_buffer.sum -= remote.phead + remote.shead;
        }
    }

    private void send_signals(int[] signals, int n) {
        for (int i = 0; i < n; ++i) {
            this.add_send_buffer(signals[i]);
        }
    }

    private void send_signals(List<Integer> signals) {
        for (Integer s : signals) {
            this.add_send_buffer(s);
        }
    }

    private boolean init_send(IrRemote remote, IrNCode code, int debug) {
        return this.init_send_or_sim(remote, code, false, 0, debug);
    }

    private boolean init_send_or_sim(IrRemote remote, IrNCode code, boolean sim, int repeat_preset, int debug) {
        boolean success;
        this.debug = debug;
        int repeat = repeat_preset;
        if (remote.is_grundig() || remote.is_goldstar() || remote.is_bo()) {
            if (!sim) {
                this.logprintf(1, "sorry, can't send this protocol yet", new Object[0]);
            }
            return false;
        }
        this.clear_send_buffer();
        this.send_buffer.is_biphase = remote.is_biphase();
        if (!sim) {
            if (IrRemote.getRepeat_remote() == null) {
                remote.repeat_countdown = remote.min_repeat;
            } else {
                repeat = 1;
            }
        }
        if (success = this.send_loop(remote, code, repeat, sim)) {
            this.LOGPRINTF(3, "transmit buffer ready", new Object[0]);
            return this.final_check(sim);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean send_loop(IrRemote remote, IrNCode code, int repeat, boolean sim) {
        while (true) {
            if (repeat > 0 && remote.has_repeat()) {
                if ((remote.flags & 0x8000) != 0 && remote.has_header()) {
                    this.send_header(remote);
                }
                this.send_repeat(remote);
            } else if (!remote.is_raw()) {
                long next_code = sim || code.getTransmit_state() == null ? code.getCode() : code.getTransmit_state().getCode();
                this.send_code(remote, next_code, repeat != 0);
                if (!sim && remote.has_toggle_mask()) {
                    ++remote.toggle_mask_state;
                    if (remote.toggle_mask_state == 4) {
                        remote.toggle_mask_state = 2;
                    }
                }
                this.send_buffer.data = this.send_buffer._data;
            } else {
                if (code.getSignals() == null) {
                    if (!sim) {
                        this.logprintf(1, "no signals for raw send", new Object[0]);
                    }
                    return false;
                }
                if (this.send_buffer.wptr > 0) {
                    this.send_signals(code.getSignals());
                } else {
                    this.send_buffer.data = new int[code.getSignals().size()];
                    this.send_buffer.wptr = code.getSignals().size();
                    for (int i = 0; i < code.getSignals().size(); this.send_buffer.sum += code.getSignals().get(i).intValue(), ++i) {
                        this.send_buffer.data[i] = code.getSignals().get(i);
                    }
                }
            }
            this.sync_send_buffer();
            if (this.bad_send_buffer()) {
                if (!sim) {
                    this.logprintf(1, "buffer too small", new Object[0]);
                }
                return false;
            }
            if (sim) {
                return this.final_check(sim);
            }
            if (remote.has_repeat_gap() && repeat != 0 && remote.has_repeat()) {
                remote.min_remaining_gap = remote.repeat_gap;
                remote.max_remaining_gap = remote.repeat_gap;
            } else if (remote.is_const()) {
                if (remote.min_gap() <= this.send_buffer.sum) {
                    this.logprintf(1, "too short gap: %d", remote.gap);
                    remote.min_remaining_gap = remote.min_gap();
                    remote.max_remaining_gap = remote.max_gap();
                    return false;
                }
                remote.min_remaining_gap = remote.min_gap() - this.send_buffer.sum;
                remote.max_remaining_gap = remote.max_gap() - this.send_buffer.sum;
            } else {
                remote.min_remaining_gap = remote.min_gap();
                remote.max_remaining_gap = remote.max_gap();
            }
            if (code.getNext() != null) {
                if (code.getTransmit_state() == null) {
                    code.setTransmit_state(code.getNext());
                } else {
                    code.setTransmit_state(code.getTransmit_state().getNext());
                    if (remote.is_xmp() && code.getTransmit_state() == null) {
                        code.setTransmit_state(code.getNext());
                    }
                }
            }
            if (remote.repeat_countdown <= 0 && code.getTransmit_state() == null || remote.min_remaining_gap >= 10000) break;
            if (this.send_buffer.data != this.send_buffer._data) {
                this.LOGPRINTF(1, "unrolling raw signal optimisation", new Object[0]);
                int[] signals = this.send_buffer.data;
                int n = this.send_buffer.wptr;
                this.send_buffer.data = this.send_buffer._data;
                this.send_buffer.wptr = 0;
                this.send_signals(signals, n);
            }
            this.LOGPRINTF(1, "concatenating low gap signals", new Object[0]);
            if (code.getNext() == null || code.getTransmit_state() == null) {
                --remote.repeat_countdown;
            }
            this.send_space(remote.min_remaining_gap);
            this.flush_send_buffer();
            this.send_buffer.sum = 0;
            repeat = 1;
        }
        return true;
    }

    private boolean final_check(boolean sim) {
        if (!this.check_send_buffer()) {
            if (!sim) {
                this.logprintf(1, "invalid send buffer", new Object[0]);
                this.logprintf(1, "this remote configuration cannot be used to transmit", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static class Sbuf {
        int[] data;
        int[] _data = new int[1024];
        int wptr;
        boolean too_long;
        boolean is_biphase;
        int pendingp;
        int pendings;
        int sum;

        private Sbuf() {
        }

        public int[] getData(int gap) {
            int[] array = new int[this.wptr + this.wptr % 2];
            System.arraycopy(this.data, 0, array, 0, this.wptr);
            if ((this.wptr & 1) == 1) {
                array[array.length - 1] = gap;
            }
            return array;
        }

        public int[] getData() {
            int[] array = new int[this.wptr];
            System.arraycopy(this.data, 0, array, 0, this.wptr);
            return array;
        }
    }
}

