/*
 * Decompiled with CFR 0.152.
 */
package osbaldeston.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import osbaldeston.io.PCBinaryInputStream;
import osbaldeston.io.PCBinaryOutputStream;

public class BMP {
    private Image image;
    private BmpFileheader bmp_fileheader = new BmpFileheader();
    private BmpInfoHeader bmp_infoheader = new BmpInfoHeader();
    private BmpPalette bmp_palette;
    private int width;
    private int height;

    public BMP(File file) {
        try {
            PCBinaryInputStream pCBinaryInputStream = new PCBinaryInputStream(file);
            this.read(pCBinaryInputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public BMP(URL uRL) {
        try {
            PCBinaryInputStream pCBinaryInputStream = new PCBinaryInputStream(uRL);
            this.read(pCBinaryInputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public BMP(InputStream inputStream) {
        try {
            PCBinaryInputStream pCBinaryInputStream = new PCBinaryInputStream(inputStream);
            this.read(pCBinaryInputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public BMP(Image image) {
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.bmp_infoheader.biWidth = (short)this.width;
        this.bmp_infoheader.biHeight = (short)this.height;
        this.bmp_infoheader.biBitCount = (short)24;
        this.bmp_infoheader.biClrUsed = 0;
    }

    public Image getImage() {
        return this.image;
    }

    public void write(File file) {
        try {
            PCBinaryOutputStream pCBinaryOutputStream = new PCBinaryOutputStream(file);
            this.write(pCBinaryOutputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void write(URL uRL) {
        try {
            PCBinaryOutputStream pCBinaryOutputStream = new PCBinaryOutputStream(uRL);
            this.write(pCBinaryOutputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void write(PCBinaryOutputStream pCBinaryOutputStream) {
        try {
            byte[] byArray;
            int[] nArray = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, nArray, 0, this.width);
            this.bmp_palette = new BmpPalette(pixelGrabber.getColorModel());
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
            }
            ColorModel colorModel = pixelGrabber.getColorModel();
            this.bmp_fileheader.bfOffBits = this.bmp_fileheader.getSize() + this.bmp_infoheader.getSize() + this.bmp_palette.getSize();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = this.width * 3;
            int n7 = this.height - 1;
            if (n6 % 4 != 0) {
                n6 += 4 - n6 % 4;
            }
            if (colorModel instanceof IndexColorModel) {
                byArray = new byte[this.width * this.bmp_infoheader.biHeight];
                for (n2 = n7; n2 >= 0; --n2) {
                    n3 = (n7 - n2) * this.width;
                    n4 = n2 * this.width;
                    for (n = 0; n < this.width; ++n) {
                        byArray[n4++] = (byte)nArray[n3 + n];
                    }
                }
                this.bmp_fileheader.bfSize = this.bmp_fileheader.bfOffBits + this.width * this.bmp_infoheader.biHeight;
            } else {
                byArray = new byte[n6 * this.bmp_infoheader.biHeight];
                for (n2 = 0; n2 < this.height; ++n2) {
                    n3 = (n7 - n2) * this.width;
                    n4 = n2 * n6;
                    for (n = 0; n < this.width; ++n) {
                        n5 = n3 + n;
                        byArray[n4++] = (byte)(colorModel.getBlue(nArray[n5]) & 0xFF);
                        byArray[n4++] = (byte)(colorModel.getGreen(nArray[n5]) & 0xFF);
                        byArray[n4++] = (byte)(colorModel.getRed(nArray[n5]) & 0xFF);
                    }
                }
            }
            nArray = null;
            this.bmp_fileheader.bfSize = this.bmp_fileheader.bfOffBits + n6 * this.bmp_infoheader.biHeight;
            this.bmp_fileheader.write(pCBinaryOutputStream);
            this.bmp_infoheader.write(pCBinaryOutputStream);
            this.bmp_palette.write(pCBinaryOutputStream);
            pCBinaryOutputStream.writeByteArray(byArray);
            byArray = null;
            pCBinaryOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void read(PCBinaryInputStream pCBinaryInputStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        try {
            this.bmp_fileheader.read(pCBinaryInputStream);
            this.bmp_infoheader.read(pCBinaryInputStream);
            if (this.bmp_infoheader.biClrUsed != 0) {
                n = this.bmp_infoheader.biClrUsed;
            } else if (this.bmp_infoheader.biBitCount < 16) {
                n = 1 << this.bmp_infoheader.biBitCount;
            }
            this.bmp_palette = new BmpPalette(n);
            this.bmp_palette.read(pCBinaryInputStream);
            long l = this.bmp_fileheader.bfOffBits - (this.bmp_fileheader.getSize() + this.bmp_infoheader.getSize() + this.bmp_palette.getSize());
            if (l > 0L) {
                pCBinaryInputStream.skip(l);
            }
            n2 = (this.bmp_infoheader.biWidth * this.bmp_infoheader.biBitCount + 31) / 32 * 4;
            n3 = this.bmp_infoheader.biSizeImage != 0 ? this.bmp_infoheader.biSizeImage : n2 * this.bmp_infoheader.biHeight;
            byArray = new byte[n3];
            pCBinaryInputStream.readByteArray(byArray);
            pCBinaryInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (byArray != null) {
            this.image = this.bmp_infoheader.biBitCount > 8 ? this.unpack24(byArray, n2) : this.unpack08(byArray, n2);
        }
        byArray = null;
    }

    Image unpack24(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.bmp_infoheader.biWidth * this.bmp_infoheader.biHeight];
        try {
            for (n5 = 0; n5 < this.bmp_infoheader.biHeight; ++n5) {
                n2 = (this.bmp_infoheader.biHeight - 1 - n5) * this.bmp_infoheader.biWidth;
                n3 = n5 * n;
                for (n4 = 0; n4 < this.bmp_infoheader.biWidth; ++n4) {
                    nArray[n4 + n2] = 0xFF000000 | byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.bmp_infoheader.biWidth, this.bmp_infoheader.biHeight, ColorModel.getRGBdefault(), nArray, 0, this.bmp_infoheader.biWidth));
    }

    Image unpack08(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[this.bmp_infoheader.biWidth * this.bmp_infoheader.biHeight];
        try {
            if (this.bmp_infoheader.biBitCount == 1) {
                for (n6 = 0; n6 < this.bmp_infoheader.biHeight; ++n6) {
                    n2 = (this.bmp_infoheader.biHeight - 1 - n6) * this.bmp_infoheader.biWidth;
                    n3 = n6 * n;
                    for (n5 = 0; n5 < this.bmp_infoheader.biWidth - 8; n5 += 8) {
                        byArray2[n2 + n5 + 7] = (byte)(byArray[n3] & 1);
                        byArray2[n2 + n5 + 6] = (byte)(byArray[n3] >>> 1 & 1);
                        byArray2[n2 + n5 + 5] = (byte)(byArray[n3] >>> 2 & 1);
                        byArray2[n2 + n5 + 4] = (byte)(byArray[n3] >>> 3 & 1);
                        byArray2[n2 + n5 + 3] = (byte)(byArray[n3] >>> 4 & 1);
                        byArray2[n2 + n5 + 2] = (byte)(byArray[n3] >>> 5 & 1);
                        byArray2[n2 + n5 + 1] = (byte)(byArray[n3] >>> 6 & 1);
                        byArray2[n2 + n5] = (byte)(byArray[n3] >>> 7 & 1);
                        ++n3;
                    }
                    for (n4 = 7; n4 >= 0; --n4) {
                        if (n4 + n5 >= this.bmp_infoheader.biWidth) continue;
                        byArray2[n2 + n5 + n4] = (byte)(byArray[n3] >>> 7 - n4 & 1);
                    }
                }
            } else if (this.bmp_infoheader.biBitCount == 4) {
                for (n6 = 0; n6 < this.bmp_infoheader.biHeight; ++n6) {
                    n2 = (this.bmp_infoheader.biHeight - 1 - n6) * this.bmp_infoheader.biWidth;
                    n3 = n6 * n;
                    for (n5 = 0; n5 < this.bmp_infoheader.biWidth - 2; n5 += 2) {
                        byArray2[n2 + n5] = (byte)(byArray[n3] >> 4 & 0xF);
                        byArray2[n2 + n5 + 1] = (byte)(byArray[n3] & 0xF);
                        ++n3;
                    }
                    for (n4 = 1; n4 >= 0; --n4) {
                        if (n4 + n5 >= this.bmp_infoheader.biWidth) continue;
                        byArray2[n2 + n5 + n4] = (byte)(byArray[n3] >>> (1 - n4 << 2) & 0xF);
                    }
                }
            } else {
                for (n6 = 0; n6 < this.bmp_infoheader.biHeight; ++n6) {
                    n2 = (this.bmp_infoheader.biHeight - 1 - n6) * this.bmp_infoheader.biWidth;
                    n3 = n6 * n;
                    for (n5 = 0; n5 < this.bmp_infoheader.biWidth; ++n5) {
                        byArray2[n5 + n2] = (byte)(byArray[n3++] & 0xFF);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IndexColorModel indexColorModel = new IndexColorModel((int)this.bmp_infoheader.biBitCount, this.bmp_palette.length, this.bmp_palette.r, this.bmp_palette.g, this.bmp_palette.b);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.bmp_infoheader.biWidth, this.bmp_infoheader.biHeight, (ColorModel)indexColorModel, byArray2, 0, this.bmp_infoheader.biWidth));
    }

    class BmpPalette {
        int length;
        byte[] r;
        byte[] g;
        byte[] b;

        public BmpPalette(int n) {
            this.length = n;
            this.r = new byte[n];
            this.g = new byte[n];
            this.b = new byte[n];
        }

        int getSize() {
            return this.length * 4;
        }

        public BmpPalette(ColorModel colorModel) {
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                this.length = indexColorModel.getMapSize();
                this.r = new byte[this.length];
                indexColorModel.getReds(this.r);
                this.g = new byte[this.length];
                indexColorModel.getGreens(this.g);
                this.b = new byte[this.length];
                indexColorModel.getBlues(this.b);
                ((BMP)BMP.this).bmp_infoheader.biBitCount = (short)indexColorModel.getPixelSize();
                ((BMP)BMP.this).bmp_infoheader.biClrUsed = this.length;
            }
        }

        void read(PCBinaryInputStream pCBinaryInputStream) {
            if (this.length > 0) {
                try {
                    for (int i = 0; i < this.length; ++i) {
                        this.b[i] = pCBinaryInputStream.readByte();
                        this.g[i] = pCBinaryInputStream.readByte();
                        this.r[i] = pCBinaryInputStream.readByte();
                        byte by = pCBinaryInputStream.readByte();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }

        void write(PCBinaryOutputStream pCBinaryOutputStream) {
            if (this.length > 0) {
                try {
                    byte by = 0;
                    for (int i = 0; i < this.length; ++i) {
                        pCBinaryOutputStream.writeByte(this.b[i]);
                        pCBinaryOutputStream.writeByte(this.g[i]);
                        pCBinaryOutputStream.writeByte(this.r[i]);
                        pCBinaryOutputStream.writeByte(by);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
    }

    class BmpFileheader {
        byte[] bfType = new byte[]{66, 77};
        int bfSize;
        short bfReserved1 = 0;
        short bfReserved2 = 0;
        int bfOffBits;

        BmpFileheader() {
        }

        int getSize() {
            return 14;
        }

        void read(PCBinaryInputStream pCBinaryInputStream) {
            try {
                this.bfType[0] = pCBinaryInputStream.readByte();
                this.bfType[1] = pCBinaryInputStream.readByte();
                if (this.bfType[0] != 66 && this.bfType[1] != 77) {
                    throw new IOException("Invalid BMP 3.0 File.");
                }
                this.bfSize = pCBinaryInputStream.readInt();
                this.bfReserved1 = pCBinaryInputStream.readShort();
                this.bfReserved2 = pCBinaryInputStream.readShort();
                this.bfOffBits = pCBinaryInputStream.readInt();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }

        void write(PCBinaryOutputStream pCBinaryOutputStream) {
            try {
                pCBinaryOutputStream.writeByte(this.bfType[0]);
                pCBinaryOutputStream.writeByte(this.bfType[1]);
                pCBinaryOutputStream.writeInt(this.bfSize);
                pCBinaryOutputStream.writeShort(this.bfReserved1);
                pCBinaryOutputStream.writeShort(this.bfReserved2);
                pCBinaryOutputStream.writeInt(this.bfOffBits);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    class BmpInfoHeader {
        int biSize = 40;
        int biWidth;
        int biHeight;
        short biPlanes = 1;
        short biBitCount;
        int biCompression;
        int biSizeImage;
        int biXPelsPerMeter;
        int biYPelsPerMeter;
        int biClrUsed;
        int biClrImportant;

        BmpInfoHeader() {
        }

        int getSize() {
            return this.biSize;
        }

        void read(PCBinaryInputStream pCBinaryInputStream) {
            try {
                this.biSize = pCBinaryInputStream.readInt();
                if (this.biSize == 12) {
                    this.biWidth = pCBinaryInputStream.readShort();
                    this.biHeight = pCBinaryInputStream.readShort();
                    this.biPlanes = pCBinaryInputStream.readShort();
                    this.biBitCount = pCBinaryInputStream.readShort();
                } else {
                    this.biWidth = pCBinaryInputStream.readInt();
                    this.biHeight = pCBinaryInputStream.readInt();
                    this.biPlanes = pCBinaryInputStream.readShort();
                    this.biBitCount = pCBinaryInputStream.readShort();
                    this.biCompression = pCBinaryInputStream.readInt();
                    this.biSizeImage = pCBinaryInputStream.readInt();
                    this.biXPelsPerMeter = pCBinaryInputStream.readInt();
                    this.biYPelsPerMeter = pCBinaryInputStream.readInt();
                    this.biClrUsed = pCBinaryInputStream.readInt();
                    this.biClrImportant = pCBinaryInputStream.readInt();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            if (this.biSizeImage == 0) {
                this.biSizeImage = (this.biWidth * this.biBitCount + 31 >> 5 << 2) * this.biHeight;
            }
            if (this.biClrUsed == 0 && this.biBitCount < 16) {
                this.biClrUsed = 1 << this.biBitCount;
            }
        }

        void write(PCBinaryOutputStream pCBinaryOutputStream) {
            try {
                pCBinaryOutputStream.writeInt(this.biSize);
                if (this.biSize == 12) {
                    pCBinaryOutputStream.writeShort((short)this.biWidth);
                    pCBinaryOutputStream.writeShort((short)this.biHeight);
                    pCBinaryOutputStream.writeShort(this.biPlanes);
                    pCBinaryOutputStream.writeShort(this.biBitCount);
                } else {
                    pCBinaryOutputStream.writeInt(this.biWidth);
                    pCBinaryOutputStream.writeInt(this.biHeight);
                    pCBinaryOutputStream.writeShort(this.biPlanes);
                    pCBinaryOutputStream.writeShort(this.biBitCount);
                    pCBinaryOutputStream.writeInt(this.biCompression);
                    pCBinaryOutputStream.writeInt(this.biSizeImage);
                    pCBinaryOutputStream.writeInt(this.biXPelsPerMeter);
                    pCBinaryOutputStream.writeInt(this.biYPelsPerMeter);
                    pCBinaryOutputStream.writeInt(this.biClrUsed);
                    pCBinaryOutputStream.writeInt(this.biClrImportant);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }
}

