/*
 * Decompiled with CFR 0.152.
 */
package osbaldeston.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PCBinaryInputStream {
    DataInputStream file;

    public PCBinaryInputStream(File file) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public PCBinaryInputStream(URL uRL) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(uRL.openConnection().getInputStream()));
    }

    public PCBinaryInputStream(InputStream inputStream) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(inputStream));
    }

    public int readInt() throws IOException {
        int n = this.file.readInt();
        return n << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >>> 8 | n >>> 24;
    }

    public short readShort() throws IOException {
        int n = this.file.readUnsignedShort();
        return (short)(n << 8 | n >>> 8);
    }

    public byte readByte() throws IOException {
        return (byte)this.file.readUnsignedByte();
    }

    public void readByteArray(byte[] byArray) throws IOException {
        this.file.readFully(byArray);
    }

    public void skip(long l) throws IOException {
        this.file.skip(l);
    }

    public void close() throws IOException {
        this.file.close();
        this.file = null;
    }

    public void finalize() {
        if (this.file != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

